import 'package:absenkuv3/Repository/Model/SalesActivity/mDataProduct.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownProdukLayananEvent {}

class GetDataDropdownProdukLayanan extends DropdownProdukLayananEvent {}

class SelectDataDropdownProdukLayanan extends DropdownProdukLayananEvent {
  DataProduct selectedValue;
  SelectDataDropdownProdukLayanan(this.selectedValue);
}

abstract class DropdownProdukLayananState {}

class DropdownProdukLayananProgressState extends DropdownProdukLayananState {}

class DropdownProdukLayananSuccessState extends DropdownProdukLayananState {
  DataProductRespon dropdownRespon;
  DataProduct? selectedValue;
  DropdownProdukLayananSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownProdukLayananErrorState extends DropdownProdukLayananState {}

class DropdownProdukLayananBloc extends Bloc<DropdownProdukLayananEvent, DropdownProdukLayananState> {
  DropdownProdukLayananBloc(DropdownProdukLayananState initialState) : super(initialState);
  DataProduct? selectedValue;
  DataProductRespon? dropdownRespon;

  @override
  Stream<DropdownProdukLayananState> mapEventToState(DropdownProdukLayananEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownProdukLayanan) {
      yield DropdownProdukLayananProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownApi().getDataProduct();
      if (dropdownRespon!.data != null)
        yield DropdownProdukLayananSuccessState(dropdownRespon!, null);
      else
        yield DropdownProdukLayananErrorState();
    } else if (event is SelectDataDropdownProdukLayanan) {
      selectedValue = event.selectedValue;
      yield DropdownProdukLayananSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
