import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownKecamatanEvent {}

class GetDataDropdownKecamatan extends DropdownKecamatanEvent {}

class SelectDataDropdownKecamatan extends DropdownKecamatanEvent {
  JenisData selectedValue;
  SelectDataDropdownKecamatan(this.selectedValue);
}

abstract class DropdownKecamatanState {}

class DropdownKecamatanProgressState extends DropdownKecamatanState {}

class DropdownKecamatanSuccessState extends DropdownKecamatanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownKecamatanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownKecamatanSetValueSuccessState extends DropdownKecamatanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownKecamatanSetValueSuccessState(this.dropdownRespon, this.selectedValue);
}

class SetKabupaten extends DropdownKecamatanEvent{
  String? idKabupaten;
  JenisData? selectedValue;
  SetKabupaten(this.idKabupaten, this.selectedValue);
}

class SetValueKabupaten extends DropdownKecamatanEvent{
  String? idKabupaten;
  JenisData? selectedValue;
  SetValueKabupaten(this.idKabupaten, this.selectedValue);
}

class ClearDataDropdownKecamatan extends DropdownKecamatanEvent {}

class DropdownKecamatanErrorState extends DropdownKecamatanState {}

class DropdownKecamatanBloc extends Bloc<DropdownKecamatanEvent, DropdownKecamatanState> {
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;
  DropdownKecamatanBloc(DropdownKecamatanState initialState) : super(initialState);

  @override
  Stream<DropdownKecamatanState> mapEventToState(DropdownKecamatanEvent event) async* {
    // TODO: implement mapEventToState
    // if (event is GetDataDropdownKecamatan) {
    //   yield DropdownKecamatanProgressState();
    //   selectedValue = null;
    //   dropdownRespon = await AkunApi().getJenisKecamatan();
    //   if (dropdownRespon.data != null)
    //     yield DropdownKecamatanSuccessState(dropdownRespon, null);
    //   else
    //     yield DropdownAgamaErrorState();
    // } else
    if (event is SelectDataDropdownKecamatan) {
      selectedValue = event.selectedValue;
      yield DropdownKecamatanSuccessState(dropdownRespon!, selectedValue!);
    }else if(event is SetKabupaten){
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisKecamatan(event.idKabupaten);
      if (dropdownRespon!.data != null)
        yield DropdownKecamatanSuccessState(dropdownRespon!, event.selectedValue);
      else
        yield DropdownKecamatanErrorState();
    }else if(event is SetValueKabupaten){
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisKecamatan(event.idKabupaten);
      if (dropdownRespon!.data != null)
        yield DropdownKecamatanSetValueSuccessState(dropdownRespon!, event.selectedValue);
      else
        yield DropdownKecamatanErrorState();
    }else if(event is ClearDataDropdownKecamatan){
      selectedValue = null;
      dropdownRespon = null;
      yield DropdownKecamatanProgressState();
    }
  }
}
