import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownAgamaEvent {}

class GetDataDropdownAgama extends DropdownAgamaEvent {}

class SelectDataDropdownAgama extends DropdownAgamaEvent {
  JenisData selectedValue;
  SelectDataDropdownAgama(this.selectedValue);
}

abstract class DropdownAgamaState {}

class DropdownAgamaProgressState extends DropdownAgamaState {}

class DropdownAgamaSuccessState extends DropdownAgamaState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownAgamaSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownAgamaErrorState extends DropdownAgamaState {}

class DropdownAgamaBloc extends Bloc<DropdownAgamaEvent, DropdownAgamaState> {
  DropdownAgamaBloc(DropdownAgamaState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownAgamaState> mapEventToState(DropdownAgamaEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownAgama) {
      yield DropdownAgamaProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisAgama();
      if (dropdownRespon!.data != null)
        yield DropdownAgamaSuccessState(dropdownRespon!, null);
      else
        yield DropdownAgamaErrorState();
    } else if (event is SelectDataDropdownAgama) {
      selectedValue = event.selectedValue;
      yield DropdownAgamaSuccessState(dropdownRespon!, selectedValue);
    }
  }
}
