import 'package:absenkuv3/Repository/Model/mDashboardNew.dart';
import 'package:absenkuv3/Repository/Service/dashboardApi.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../CustomFunction.dart';

abstract class DashboardEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class DashboardState{}

class GetDataDashboard extends DashboardEvent{
  GetDataDashboard(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey){
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class GetSuccess extends DashboardState{
  DataDashboard? dataDashboard;
  GetSuccess(this.dataDashboard) {

  }
}

class GetProgress extends DashboardState{}

class GetFailed extends DashboardState{
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  BuildContext context;
  GetFailed(this.message, this.scaffoldKey, this.context){
    showSnackBarDelayed(scaffoldKey, message, context);
  }
}

class DashboardBloc extends Bloc<DashboardEvent, DashboardState>{
  DashboardBloc(DashboardState initialState) : super(initialState);


  @override
  Stream<DashboardState> mapEventToState(DashboardEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetDataDashboard){
      yield GetProgress();
      await sharedPreferences().setInitialPermanentStatus(false);
      DashboardRespon dashboardRespon = await DashboardApi().getData();
      if(dashboardRespon.success!) yield GetSuccess(dashboardRespon.data);
      else yield GetFailed(dashboardRespon.message, event.scaffoldKey, event.context!);
    }
  }
}