import 'package:absenkuv3/Repository/Model/Cuti/mDataHistoryCuti.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/cutiApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

abstract class HistoryCutiEvent {
  BuildContext? context;
  late String konteks;
  late String periodeAwal;
  late String periodeAkhir;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListHistoryCutiEvent extends HistoryCutiEvent {
  getListHistoryCutiEvent(BuildContext? _context, String _konteks,String _periodeAwal,String _periodeAkhir) {
    context = _context;
    konteks = _konteks;
    periodeAwal = _periodeAwal;
    periodeAkhir=_periodeAkhir;
  }
}

class loadMoreEvent extends HistoryCutiEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController,String _konteks) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
    konteks=_konteks;
  }
}

abstract class HistoryCutiState {
  List<DataHistoryCuti>? data;
}

class getListHistoryCutiSuccessState extends HistoryCutiState {
  getListHistoryCutiSuccessState(
      HistoryCutiEvent _event, List<DataHistoryCuti>? _data) {
    data = _data;
  }
}

class HistoryCutiProgressState extends HistoryCutiState {}

class LoadMoreProgressState extends HistoryCutiState {
  LoadMoreProgressState(List<DataHistoryCuti>? _data) {
    data = _data;
  }
}

class HistoryCutiErrorState extends HistoryCutiState {}

class HistoryCutiBloc extends Bloc<HistoryCutiEvent, HistoryCutiState> {
  final dateFormat = new DateFormat('yyyy-MM');
  HistoryCutiState? initialState;
  List<DataHistoryCuti>? listRiwayat;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  HistoryCutiBloc(HistoryCutiState initialState) : super(initialState);

  @override
  Stream<HistoryCutiState> mapEventToState(HistoryCutiEvent event) async* {
    if (event is getListHistoryCutiEvent) {
      offset = 0;
      yield HistoryCutiProgressState();
      Responlisthistorycuti cutiResponse =
          await CutiApi().getHistoryCuti(event.konteks,offset,event.periodeAwal,event.periodeAkhir);
      if (cutiResponse.success!) {
        listRiwayat = cutiResponse.data;
        yield getListHistoryCutiSuccessState(event, listRiwayat);
      } else
        yield HistoryCutiErrorState();
    } else if (event is loadMoreEvent) {
      // if (event.scrollController.offset >=
      //         event.scrollController.position.maxScrollExtent &&
      //     !event.scrollController.position.outOfRange) {
      //   offset = offset + limit;
      //   yield LoadMoreProgressState(listRiwayat);
      //   Responlisthistorycuti cutiResponse =
      //       await CutiApi().getHistoryCuti(event.konteks,offset);
      //   if (cutiResponse.success!) {
      //     listRiwayat!.addAll(cutiResponse.data!);
      //   }
      //   yield getListHistoryCutiSuccessState(event, listRiwayat);
      // }
    }
  }
}
