import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Service/notifApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgeNotificationDashboardEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class BadgeNotificationDashboardState {}

class GetBadgeNotificationDashboard extends BadgeNotificationDashboardEvent {
  GetBadgeNotificationDashboard(BuildContext _context) {
    context = _context;
  }
}

class GetBadgeNotificationDashboardSuccess extends BadgeNotificationDashboardState {
  JumlahBadge? dataDashboard;
  GetBadgeNotificationDashboardSuccess(this.dataDashboard) {}
}

class GetBadgeNotificationDashboardProgress extends BadgeNotificationDashboardState {}

class GetBadgeNotificationDashboardFailed extends BadgeNotificationDashboardState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetBadgeNotificationDashboardFailed(this.message, this.scaffoldKey);
}

class BadgeNotificationDashboardBloc extends Bloc<BadgeNotificationDashboardEvent, BadgeNotificationDashboardState> {
  BadgeNotificationDashboardBloc(BadgeNotificationDashboardState initialState) : super(initialState);

  @override
  Stream<BadgeNotificationDashboardState> mapEventToState(BadgeNotificationDashboardEvent event) async* {
    if (event is GetBadgeNotificationDashboard) {
      yield GetBadgeNotificationDashboardProgress();
      JumlahBadge dashboardRespon = await NotifApi().badgeNotif();
      if (dashboardRespon.success!)
        yield GetBadgeNotificationDashboardSuccess(dashboardRespon);
      else
        yield GetBadgeNotificationDashboardFailed(dashboardRespon.message, event.scaffoldKey);
    }
  }
}
