import 'package:absenkuv3/Repository/Model/Akun/mKontakPegawai.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/Akun/dataSemuaKontakPegawaiApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class KontakPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListKontakPegawai extends KontakPegawaiEvent {
  ModelFilter? modelFilter;
  String? konteks;
  String? cari;

  getListKontakPegawai(
      BuildContext? _context, this.modelFilter, this.konteks, this.cari) {
    context = _context;
    konteks = konteks;
    cari = cari;
    modelFilter = modelFilter;
  }
}

abstract class KontakPegawaiState {
  List<DataKontak>? data;
  DataKontak? dataKontakPegawai;
}

class getListKontakPegawaiState extends KontakPegawaiState {
  getListKontakPegawaiState(
      KontakPegawaiEvent _event, List<DataKontak>? _data) {
    data = _data;
  }
}

class loadMoreEvent extends KontakPegawaiEvent {
  late ScrollController scrollController;
  String? konteks;
  String? cari;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController, this.konteks, this.cari) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
    konteks = konteks;
    cari = cari;
  }
}

class KontakPegawaiProgressState extends KontakPegawaiState {}

class LoadMoreProgressDataKontakState extends KontakPegawaiState {
  LoadMoreProgressDataKontakState(List<DataKontak>? _data) {
    data = _data;
  }
}

class DataKontakPegawaiErrorState extends KontakPegawaiState {}

class KontakPegawaiBloc extends Bloc<KontakPegawaiEvent, KontakPegawaiState> {
  KontakPegawaiState? initialState;
  List<DataKontak>? listKontakPegawai;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;
  KontakPegawaiBloc(KontakPegawaiState initialState) : super(initialState);

  @override
  Stream<KontakPegawaiState> mapEventToState(KontakPegawaiEvent event) async* {
    if (event is getListKontakPegawai) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield KontakPegawaiProgressState();
      KontakPegawaiRespon kontakPegawaiRespon =
          await DataKontakSemuaPegawaiApi()
              .getListKontakSemuaPegawai(offset, event.konteks, event.cari,event.modelFilter);
      if (kontakPegawaiRespon.success!) {
        listKontakPegawai = kontakPegawaiRespon.data;
        yield getListKontakPegawaiState(event, listKontakPegawai);
      } else {
        yield DataKontakPegawaiErrorState();
      }
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressDataKontakState(listKontakPegawai);
        KontakPegawaiRespon kontakPegawaiRespon =
            await DataKontakSemuaPegawaiApi()
                .getListKontakSemuaPegawai(offset, event.konteks, event.cari,modelFilter);
        if (kontakPegawaiRespon.success!) {
          listKontakPegawai!.addAll(kontakPegawaiRespon.data!);
        }
        yield getListKontakPegawaiState(event, listKontakPegawai);
      }
    }
  }
}
