import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/KelengkapanFile/mKelengkapanFile.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/Akun/dataKelengkapanFileApi.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class KelengkapanFileEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? id;
}

class getKelengkapanFileTerverifikasiEvent extends KelengkapanFileEvent{
  getKelengkapanFileTerverifikasiEvent(BuildContext _context){
    context = _context;
  }
}

class getKelengkapanFilePengajuanEvent extends KelengkapanFileEvent{
  getKelengkapanFilePengajuanEvent(BuildContext _context){
    context = _context;
  }
}

class getDetailDataKelengkapanFileByIdEvent extends KelengkapanFileEvent{
  DataNotifikasiAkun? dataNotifikasiAkun;
  getDetailDataKelengkapanFileByIdEvent(BuildContext _context, DataNotifikasiAkun _data){
    context = _context;
    dataNotifikasiAkun = _data;
  }
}

class getKelengkapanFilePengajuanByIdEvent extends KelengkapanFileEvent{
  String? konteks;
  getKelengkapanFilePengajuanByIdEvent(BuildContext _context, _idKelengkapanFile, String _konteks){
    context = _context;
    id = _idKelengkapanFile;
    konteks = _konteks;
  }
}

class deleteKelengkapanFileEvent extends KelengkapanFileEvent{
  deleteKelengkapanFileEvent(BuildContext _context, _idPendidikan){
    context = _context;
    id = _idPendidikan;
  }
}

class deletePengajuanKelengkapanFileEvent extends KelengkapanFileEvent{
  deletePengajuanKelengkapanFileEvent(BuildContext _context, _idKelengkapanFile){
    context = _context;
    id = _idKelengkapanFile;
  }
}

abstract class KelengkapanFileState{
  List<DataDatakelengkapanfile>? data;
}

class getKelengkapanFileSuccessState extends KelengkapanFileState{
  getKelengkapanFileSuccessState(KelengkapanFileEvent _event, List<DataDatakelengkapanfile> _data){
    data = _data;
  }
}

class PengajuanTambahKelengkapanFileEvent extends KelengkapanFileEvent {
  DataDatakelengkapanfile? data;
  List<MultiImagePickerModel>? listImageFile;
  PengajuanTambahKelengkapanFileEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatakelengkapanfile _data, List<MultiImagePickerModel>? _file) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImageFile = _file;
  }
}

class EditPengajuanKelengkapanFileEvent extends KelengkapanFileEvent {
  DataDatakelengkapanfile? data;
  List<MultiImagePickerModel>? listImageFile;
  EditPengajuanKelengkapanFileEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatakelengkapanfile _data, List<MultiImagePickerModel>? _file) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImageFile = _file;
  }
}

class EditKelengkapanFileEvent extends KelengkapanFileEvent {
  DataDatakelengkapanfile? data;
  List<MultiImagePickerModel>? listImageFile;
  EditKelengkapanFileEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatakelengkapanfile _data, List<MultiImagePickerModel>? _file) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
    listImageFile = _file;
  }
}

class KelengkapanFileProgressState extends KelengkapanFileState{}

class KelengkapanFileErrorState extends KelengkapanFileState{}

class KelengkapanFileBloc extends Bloc<KelengkapanFileEvent, KelengkapanFileState>{
  final dateFormat = new DateFormat('yyyy-MM');
  List<DataDatakelengkapanfile>? dataDatakelengkapanfile;
  ModelFilter? modelFilter;
  bool dimmisable = false;
  int offset = 0;
  int limit = ServerInfo.limit;
  KelengkapanFileBloc(KelengkapanFileState initialState) : super(initialState);

  @override
  Stream<KelengkapanFileState> mapEventToState(KelengkapanFileEvent event) async*{
    if(event is getKelengkapanFileTerverifikasiEvent){
      offset = 0;
      yield KelengkapanFileProgressState();
      DataKelengkapanFileRespon data = await DataKelengkapanFileApi().getDataKelengkapanFileTerferifikasi();
      if(data.success!){
        dataDatakelengkapanfile = data.dataDatakelengkapanfile!;
        yield getKelengkapanFileSuccessState(event, dataDatakelengkapanfile!);
      }
      else yield KelengkapanFileErrorState();
    }
    else if(event is getKelengkapanFilePengajuanEvent){
      offset = 0;
      yield KelengkapanFileProgressState();
      DataKelengkapanFileRespon data = await DataKelengkapanFileApi().getDataKelengkapanFilePengajuan();
      if(data.success!){
        dataDatakelengkapanfile = data.dataDatakelengkapanfile!;
        yield getKelengkapanFileSuccessState(event, dataDatakelengkapanfile!);
      }
      else yield KelengkapanFileErrorState();
    }
    else if(event is getKelengkapanFilePengajuanByIdEvent){
      offset = 0;
      yield KelengkapanFileProgressState();
      DataKelengkapanFileRespon data = await DataKelengkapanFileApi().getDataPKelengkapanFilePengajuanById(event.id, event.konteks);
      if(data.success!){
        yield getKelengkapanFileSuccessState(event, data.dataDatakelengkapanfile!);
      }
      else yield KelengkapanFileErrorState();
    }
    else if(event is PengajuanTambahKelengkapanFileEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dimmisable);
      BasicRespon basicRespon = await DataKelengkapanFileApi().pengajuanTambahDataKelengkapanFile(event.data!, event.listImageFile);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKelengkapanFile(event.context!, 1));
        });
      }
    }
    else if(event is EditPengajuanKelengkapanFileEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dimmisable);
      BasicRespon basicRespon = await DataKelengkapanFileApi().editPengajuanDataKelengkapanFile(event.data!, event.listImageFile);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKelengkapanFile(event.context!, 1));
        });
      }
    }
    else if(event is EditKelengkapanFileEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dimmisable);
      BasicRespon basicRespon = await DataKelengkapanFileApi().editDataKelengkapanFile(event.data!, event.listImageFile);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKelengkapanFile(event.context!, 1));
        });
      }
    }
    else if(event is deleteKelengkapanFileEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dimmisable);
      BasicRespon basicRespon = await DataKelengkapanFileApi().deleteDataKelengkapanFile(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKelengkapanFile(event.context!, 1));
        });
      }
    }
    else if(event is deletePengajuanKelengkapanFileEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: dimmisable);
      BasicRespon basicRespon = await DataKelengkapanFileApi().deletePengajuanDataKelengkapanFile(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        StatusPengajuanDataRespon statusPengajuanDataRespon = await NotifikasiAkunApi().getStatusPengajuan();
        Future.delayed(Duration(milliseconds: 1000)).then((value) {
          if(statusPengajuanDataRespon.statusDataKeluarga == false){
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKelengkapanFile(event.context!, 0));
          }else{
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKelengkapanFile(event.context!, 1));
          }
        });
      }
    }
    else if(event is getDetailDataKelengkapanFileByIdEvent){
      offset = 0;
      yield KelengkapanFileProgressState();
      DataKelengkapanFileRespon data = await DataKelengkapanFileApi().getDetailDataKelengkapanFileById(event.dataNotifikasiAkun!);
      if(data.success!){
        yield getKelengkapanFileSuccessState(event, data.dataDatakelengkapanfile!);
      }
      else yield KelengkapanFileErrorState();
    }
  }
}