import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluarga.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluargaById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/Akun/dataKeluargaApi.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DataKeluargaEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? id;
}

class getDataKeluargaTerverifikasiEvent extends DataKeluargaEvent{
  getDataKeluargaTerverifikasiEvent(BuildContext _context){
    context = _context;
  }
}

class getDataKeluargaPengajuanEvent extends DataKeluargaEvent{
  getDataKeluargaPengajuanEvent(BuildContext _context){
    context = _context;
  }
}

class getDataKeluargaPengajuanByIdEvent extends DataKeluargaEvent{
  String? konteks;
  getDataKeluargaPengajuanByIdEvent(BuildContext _context, _idKeluarga, String _konteks){
    context = _context;
    id = _idKeluarga;
    konteks = _konteks;
  }
}

class deleteDataKeluargaEvent extends DataKeluargaEvent{
  deleteDataKeluargaEvent(BuildContext _context, _idKeluarga){
    context = _context;
    id = _idKeluarga;
  }
}

class deletePengajuanDataKeluargaEvent extends DataKeluargaEvent{
  deletePengajuanDataKeluargaEvent(BuildContext _context, _idKeluarga){
    context = _context;
    id = _idKeluarga;
  }
}

abstract class DataKeluargaState{
  List<DataDatakeluarga>? data;
  List<DataDatakeluargaById>? dataById;
}

class getDataKeluargaSuccessState extends DataKeluargaState{
  getDataKeluargaSuccessState(DataKeluargaEvent _event, List<DataDatakeluarga> _data){
    data = _data;
  }
}

class getDataKeluargaByIdSuccessState extends DataKeluargaState{
  getDataKeluargaByIdSuccessState(DataKeluargaEvent _event, List<DataDatakeluargaById> _data){
    dataById = _data;
  }
}

class PengajuanTambahDataKeluargaEvent extends DataKeluargaEvent {
  DataDatakeluarga? data;
  PengajuanTambahDataKeluargaEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, this.data) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class EditPengajuanDataKeluargaEvent extends DataKeluargaEvent {
  DataDatakeluarga? data;
  EditPengajuanDataKeluargaEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatakeluarga _data) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
  }
}

class EditDataKeluargaEvent extends DataKeluargaEvent {
  DataDatakeluarga? data;
  EditDataKeluargaEvent(_context, GlobalKey<ScaffoldState> _scaffoldKey, DataDatakeluarga _data) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    data = _data;
  }
}

class getDetailDataKeluargaByIdEvent extends DataKeluargaEvent{
  DataNotifikasiAkun? dataNotifikasiAkun;
  getDetailDataKeluargaByIdEvent(BuildContext _context, DataNotifikasiAkun _data){
    context = _context;
    dataNotifikasiAkun = _data;
  }
}

class DataKeluargaProgressState extends DataKeluargaState{}

class DataKeluargaErrorState extends DataKeluargaState{}

class DataKeluargaBloc extends Bloc<DataKeluargaEvent, DataKeluargaState>{
  final dateFormat = new DateFormat('yyyy-MM');
  List<DataDatakeluarga>? dataDatakeluarga;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;
  DataKeluargaBloc(DataKeluargaState initialState) : super(initialState);

  @override
  Stream<DataKeluargaState> mapEventToState(DataKeluargaEvent event) async*{
    if(event is getDataKeluargaTerverifikasiEvent){
      offset = 0;
      yield DataKeluargaProgressState();
      DataKeluargaRespon data = await DataKeluargaApi().getDataKeluargaTerferifikasi();
      if(data.success!){
        dataDatakeluarga = data.dataDatakeluarga!;
        yield getDataKeluargaSuccessState(event, dataDatakeluarga!);
      }
      else yield DataKeluargaErrorState();
    }
    else if(event is getDataKeluargaPengajuanEvent){
      offset = 0;
      yield DataKeluargaProgressState();
      DataKeluargaRespon data = await DataKeluargaApi().getDataKeluargaPengajuan();
      if(data.success!){
        dataDatakeluarga = data.dataDatakeluarga!;
        yield getDataKeluargaSuccessState(event, dataDatakeluarga!);
      }
      else yield DataKeluargaErrorState();
    }
    else if(event is getDataKeluargaPengajuanByIdEvent){
      offset = 0;
      yield DataKeluargaProgressState();
      DataKeluargaByIdRespon data = await DataKeluargaApi().getDataKeluargaPengajuanById(event.id, event.konteks);
      if(data.success!){
        // dataDatakeluarga = data.dataDatakeluarga!;
        yield getDataKeluargaByIdSuccessState(event, data.dataDatakeluargaById!);
      }
      else yield DataKeluargaErrorState();
    }
    else if(event is PengajuanTambahDataKeluargaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon = await DataKeluargaApi().pengajuanTambahDataKeluarga(event.data!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKeluarga(event.context!, 1));
        });
      }
    }
    else if(event is EditPengajuanDataKeluargaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon = await DataKeluargaApi().editPengajuanDataKeluarga(event.data!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKeluarga(event.context!, 1));
        });
      }
    }
    else if(event is EditDataKeluargaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon = await DataKeluargaApi().editDataKeluarga(event.data!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          // BlocProvider.of<NavigatorBloc>(event.context!)
          //     .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKeluarga(event.context!, 1));
        });
      }
    }
    else if(event is deleteDataKeluargaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon = await DataKeluargaApi().deleteDataKeluarga(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKeluarga(event.context!, 1));
        });
      }
    }
    else if(event is deletePengajuanDataKeluargaEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon = await DataKeluargaApi().deletePengajuanDataKeluarga(event.id!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);

      if (basicRespon.success!) {
        StatusPengajuanDataRespon statusPengajuanDataRespon = await NotifikasiAkunApi().getStatusPengajuan();
        Future.delayed(Duration(milliseconds: 1000)).then((value) {
          if(statusPengajuanDataRespon.statusDataKeluarga == false){
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKeluarga(event.context!, 0));
          }else{
            BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToReplaceHalamanDataKeluarga(event.context!, 1));
          }

        });
      }
    }
    else if(event is getDetailDataKeluargaByIdEvent){
      offset = 0;
      yield DataKeluargaProgressState();
      DataKeluargaRespon data = await DataKeluargaApi().getDetailDataKeluargaById(event.dataNotifikasiAkun!);
      if(data.success!){
        yield getDataKeluargaSuccessState(event, data.dataDatakeluarga!);
      }
      else yield DataKeluargaErrorState();
    }
  }
}