import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/aktivitasApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class AktivitasPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListAktivitasEvent extends AktivitasPegawaiEvent {
  ModelFilter? modelFilter;
  getListAktivitasEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class loadMoreEvent extends AktivitasPegawaiEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class AktivitasPegawaiState {
  List<DataAktivitas>? data;
  DataAktivitas? dataAktivitas;
}

class getListAktivitasSuccessState extends AktivitasPegawaiState {
  getListAktivitasSuccessState(
      AktivitasPegawaiEvent _event, List<DataAktivitas>? _data) {
    data = _data;
  }
}

class AktivitasProgressState extends AktivitasPegawaiState {}

class LoadMoreProgressState extends AktivitasPegawaiState {
  LoadMoreProgressState(List<DataAktivitas>? _data) {
    data = _data;
  }
}

class AktivitasErrorState extends AktivitasPegawaiState {}

class AktivitasPegawaiBloc
    extends Bloc<AktivitasPegawaiEvent, AktivitasPegawaiState> {
  AktivitasPegawaiState? initialState;
  List<DataAktivitas>? listAktivitas;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  AktivitasPegawaiBloc(AktivitasPegawaiState initialState)
      : super(initialState);

  @override
  Stream<AktivitasPegawaiState> mapEventToState(
      AktivitasPegawaiEvent event) async* {
    if (event is getListAktivitasEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield AktivitasProgressState();
      AktivitasRespon aktivitasRespon =
          await ActivitasApi().getDataAktivitasPegawai(offset, modelFilter);
      if (aktivitasRespon.success!) {
        listAktivitas = aktivitasRespon.data;
        yield getListAktivitasSuccessState(event, listAktivitas);
      } else
        yield AktivitasErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAktivitas);
        AktivitasRespon aktivitasRespon =
            await ActivitasApi().getDataAktivitasPegawai(offset, modelFilter);
        if (aktivitasRespon.success!) {
          listAktivitas!.addAll(aktivitasRespon.data!);
        }
        yield getListAktivitasSuccessState(event, listAktivitas);
      }
    }
  }
}
