package com.example.absenkuv3.security

import android.content.Context
import android.content.pm.PackageManager

class SecurityChecker(private val context: Context) {

    external fun isDeveloperModeEnabled(context: Context): Boolean

    fun isDevMode(): Boolean {
        return isDeveloperModeEnabled(context)
    }

    fun verifyAppSignature(): Boolean {
        val packageName = context.packageName
        val packageInfo = context.packageManager.getPackageInfo(
            packageName,
            PackageManager.GET_SIGNATURES
        )

        val signatures = packageInfo.signatures
        val currentSignature = signatures?.first()?.toCharsString()

        return VALID_SIGNATURE_HASH == currentSignature.hashCode()
    }

    companion object {
        init {
            System.loadLibrary("security_checks")
        }

        private const val VALID_SIGNATURE_HASH = 123456789
    }
}