<style>
@media (max-width: 576px) {
  .pl-0 {padding-left: 15px !important}
}
</style>
<script src="https://maps.googleapis.com/maps/api/js?key=<?= $this->config->item('api_map_key') ?>&sensor=false" type="text/javascript"></script>
<body>
  <div class="content-body">
    <div class="container">
      <!-- MultiStep Form -->
      <div class="container-fluid">
        <div class="row justify-content-center mt-0">
          <div class="col-11 col-sm-9 col-md-7 col-lg-9 text-center p-0 mt-3">
            <div class="card px-0 pt-2 pb-0" style="background-color: transparent;">
              <div class="row">
                <div class="col-md-12 mx-0">
                  <form id="msform">
                    <!-- progressbar -->
                    <div class="section-progressbar">
                      <h2 id="judul" class="fs-title text-center">Quick Setup</h2>
                      <ul id="progressbar">
                        <li class="active" id="lokasi"><span></span> Tambah Lokasi Absensi</li>
                        <li id="akun"><span></span> Tambah Akun</li>
                        <li id="tambah_akun"><span></span> Tambah Akun</li>
                        <li id="finish"><span></span> Finish</li>
                      </ul>
                    </div>
                    <!-- fieldsets -->
                    <fieldset class="gllpLatlonPicker">
                      <div class="form-card">
                        <!-- <h2 class="fs-title">Lokasi Absensi</h2> -->
                          <div class="row">
                            <div class="col-md-8">
                              <div class="row">
                                <div class="form-group col-md-10">
                                  <div class="form-pencarian">
                                    <i class="fa fa-search"></i>
                                    <!-- <input type="text" class="form-control gllpSearchField" placeholder="CARI LOKASI ANDA"> -->
                                    <input type="text" class="form-control form-input gllpSearchField" placeholder="Cari Lokasi Anda / Nama Kantor Anda">
                                  </div>
                                </div>
                                <div class="col-md-2 mb-2 pl-0">
                                  <button type="button" class="btn btn-success col-12 gllpSearchButton">Cari</button>
                                </div>
                              </div>
                              <div class="form-group">
                                  <input type="hidden" class="gllpLatitude" value="-0.4183772" />
                                  <input type="hidden" class="gllpLongitude" value="117.4237542" />
                                  <input type="hidden" class="gllpZoom" value="4" />
                                  <div class="gllpMap" style="width:100%;height: 250px;">Google Maps</div>
                              </div>
                            </div>
                            <div id="form_input" class="col-md-4">
                              <div class="form-group">
                                <input type="hidden" class="form-control gllpLatitude" name='lat' id='lat' onkeyup="this.value = this.value.replace(/[^0-9.-]/g, '')">
                                <input type="hidden" class="form-control gllpLongitude" name='lng' id='lng' onkeyup="this.value = this.value.replace(/[^0-9.]/g, '')">
                                <label class="control-label">Nama Lokasi Kantor Anda *</label>
                                <input type="text" id="kantor" class="form-control" placeholder="">
                              </div>
                              <div class="form-group">
                                <label class="control-label">Radius Absensi*</label>
                                <input type="text" id="jarak" class="form-control" placeholder="">
                                <small class="form-control-feedback"><i class="fa fa-map-marker text-danger"></i><i>Radius dalam satuan meter</i> </small>
                              </div>
                            </div>
                          </div>
                          <div class="input-control text-left">
                              <div id="message"></div>
                          </div>
                      </div>
                      <button type="button" name="next" class="action-button float-right ladda-button next" data-style="expand-left"> Berikutnya </button>
                    </fieldset>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="footer">
      Copyright © 2021 Absenku Profesional
    </div>
  </div>
</body>
</html>
<script type="text/javascript">
    (function($) {

        // for ie9 doesn't support debug console >>>
        if (!window.console)
            window.console = {};
        if (!window.console.log)
            window.console.log = function() {};

        $.fn.gMapsLatLonPicker = (function() {

            var _self = this;

            ///////////////////////////////////////////////////////////////////////////////////////////////
            // PARAMETERS (MODIFY THIS PART) //////////////////////////////////////////////////////////////
            _self.params = {
                defLat: 0,
                defLng: 0,
                defZoom: 7,
                queryLocationNameWhenLatLngChanges: true,
                queryElevationWhenLatLngChanges: true,
                mapOptions: {
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                    mapTypeControl: false,
                    disableDoubleClickZoom: true,
                    zoomControlOptions: true,
                    streetViewControl: false,
                    // center: google.maps.LatLng(-6.990581698473311, 110.42295643957527)
                    center: google.maps.LatLng(-1.1686938,117.8632823)
                },
                strings: {
                    markerText: "Drag this Marker",
                    error_empty_field: '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Tidak dapat menemukan koordinat untuk tempat ini</font>',
                    error_no_results: '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Tidak dapat menemukan koordinat untuk tempat ini</font>'
                },
                displayError: function(message) {
                    $(".gllpLatlonPicker #msg_maps").html(message);
                    // alert(message);
                }
            };


            ///////////////////////////////////////////////////////////////////////////////////////////////
            // VARIABLES USED BY THE FUNCTION (DON'T MODIFY THIS PART) ////////////////////////////////////
            _self.vars = {
                ID: null,
                LATLNG: null,
                map: null,
                marker: null,
                geocoder: null
            };

            ///////////////////////////////////////////////////////////////////////////////////////////////
            // PRIVATE FUNCTIONS FOR MANIPULATING DATA ////////////////////////////////////////////////////
            var setPosition = function(position) {
                _self.vars.marker.setPosition(position);
                _self.vars.map.panTo(position);

                $(_self.vars.cssID + ".gllpZoom").val(_self.vars.map.getZoom());
                $(_self.vars.cssID + ".gllpLongitude").val(position.lng());
                $(_self.vars.cssID + ".gllpLatitude").val(position.lat());

                $(_self.vars.cssID).trigger("location_changed", $(_self.vars.cssID));

                if (_self.params.queryLocationNameWhenLatLngChanges) {
                    getLocationName(position);
                }
                if (_self.params.queryElevationWhenLatLngChanges) {
                    getElevation(position);
                }
            };

            // for reverse geocoding
            var getLocationName = function(position) {
                var latlng = new google.maps.LatLng(position.lat(), position.lng());
                _self.vars.geocoder.geocode({
                    'latLng': latlng
                }, function(results, status) {
                    if (status == google.maps.GeocoderStatus.OK && results[1]) {
                        $(_self.vars.cssID + ".gllpLocationName").val(results[1].formatted_address);
                    } else {
                        $(_self.vars.cssID + ".gllpLocationName").val("");
                    }
                    $(_self.vars.cssID).trigger("location_name_changed", $(_self.vars.cssID));
                });
            };

            // for getting the elevation value for a position
            var getElevation = function(position) {
                var latlng = new google.maps.LatLng(position.lat(), position.lng());

                var locations = [latlng];

                var positionalRequest = {
                    'locations': locations
                };

                _self.vars.elevator.getElevationForLocations(positionalRequest, function(results, status) {
                    if (status == google.maps.ElevationStatus.OK) {
                        if (results[0]) {
                            $(_self.vars.cssID + ".gllpElevation").val(results[0].elevation.toFixed(3));
                        } else {
                            $(_self.vars.cssID + ".gllpElevation").val("");
                        }
                    } else {
                        $(_self.vars.cssID + ".gllpElevation").val("");
                    }
                    $(_self.vars.cssID).trigger("elevation_changed", $(_self.vars.cssID));
                });
            };

            // search maps
            var performSearch = function(string, silent) {
                if (string == "") {
                    if (!silent) {
                        _self.params.displayError(_self.params.strings.error_empty_field);
                    }
                    return;
                }
                _self.vars.geocoder.geocode({
                    "address": string
                    },
                    function(results, status) {
                        // alert(status);
                        if (status == google.maps.GeocoderStatus.OK) {
                            $(_self.vars.cssID + ".gllpZoom").val(13);
                            _self.vars.map.setZoom(parseInt($(_self.vars.cssID + ".gllpZoom").val()));
                            setPosition(results[0].geometry.location);
                        } else {
                            if (!silent) {
                                _self.params.displayError(_self.params.strings.error_no_results);
                            }
                        }
                    }
                );
            };

            ///////////////////////////////////////////////////////////////////////////////////////////////
            // PUBLIC FUNCTIONS  //////////////////////////////////////////////////////////////////////////
            var publicfunc = {
                // INITIALIZE MAP ON DIV //////////////////////////////////////////////////////////////////
                init: function(object) {

                    if (!$(object).attr("id")) {
                        if ($(object).attr("name")) {
                            $(object).attr("id", $(object).attr("name"));
                        } else {
                            $(object).attr("id", "_MAP_" + Math.ceil(Math.random() * 10000));
                        }
                    }

                    _self.vars.ID = $(object).attr("id");
                    _self.vars.cssID = "#" + _self.vars.ID + " ";

                    _self.params.defLat = $(_self.vars.cssID + ".gllpLatitude").val() ? $(_self.vars.cssID + ".gllpLatitude").val() : _self.params.defLat;
                    _self.params.defLng = $(_self.vars.cssID + ".gllpLongitude").val() ? $(_self.vars.cssID + ".gllpLongitude").val() : _self.params.defLng;
                    _self.params.defZoom = $(_self.vars.cssID + ".gllpZoom").val() ? parseInt($(_self.vars.cssID + ".gllpZoom").val()) : _self.params.defZoom;

                    _self.vars.LATLNG = new google.maps.LatLng(_self.params.defLat, _self.params.defLng);

                    _self.vars.MAPOPTIONS = _self.params.mapOptions;
                    _self.vars.MAPOPTIONS.zoom = _self.params.defZoom;
                    _self.vars.MAPOPTIONS.center = _self.vars.LATLNG;

                    _self.vars.map = new google.maps.Map($(_self.vars.cssID + ".gllpMap").get(0), _self.vars.MAPOPTIONS);
                    _self.vars.geocoder = new google.maps.Geocoder();
                    _self.vars.elevator = new google.maps.ElevationService();

                    // var goldStar = {
                    //     path: 'M 125,5 155,90 245,90 175,145 200,230 125,180 50,230 75,145 5,90 95,90 z',
                    //     fillColor: 'yellow',
                    //     fillOpacity: 0.8,
                    //     scale: 1,
                    //     strokeColor: 'gold',
                    //     strokeWeight: 14
                    // };

                    // var svgMarker = {
                    //     path: "M10.453 14.016l6.563-6.609-1.406-1.406-5.156 5.203-2.063-2.109-1.406 1.406zM12 2.016q2.906 0 4.945 2.039t2.039 4.945q0 1.453-0.727 3.328t-1.758 3.516-2.039 3.070-1.711 2.273l-0.75 0.797q-0.281-0.328-0.75-0.867t-1.688-2.156-2.133-3.141-1.664-3.445-0.75-3.375q0-2.906 2.039-4.945t4.945-2.039z",
                    //     fillColor: "blue",
                    //     fillOpacity: 0.6,
                    //     strokeWeight: 0,
                    //     rotation: 0,
                    //     scale: 2,
                    //     anchor: new google.maps.Point(15, 30),
                    // };

                    _self.vars.marker = new google.maps.Marker({
                        position: _self.vars.LATLNG,
                        position: google.maps.LatLng(-6.990581698473311, 110.42295643957527),
                        map: _self.vars.map,
                        // icon: goldStar,
                        // icon: "https://your_domain.com/your_directory/your_image.jpg",
                        // icon: "https://www.pngkit.com/png/full/444-4449930_airport-map-marker-icon-clipart-computer-icons-8.png",
                        // icon:svgMarker,
                        title: _self.params.strings.markerText,
                        draggable: true
                    });



                    // Set position on doubleclick
                    google.maps.event.addListener(_self.vars.map, 'dblclick', function(event) {
                        setPosition(event.latLng);
                    });

                    // Set position on marker move
                    google.maps.event.addListener(_self.vars.marker, 'dragend', function(event) {
                        setPosition(_self.vars.marker.position);
                    });

                    // Set zoom feld's value when user changes zoom on the map
                    google.maps.event.addListener(_self.vars.map, 'zoom_changed', function(event) {
                        $(_self.vars.cssID + ".gllpZoom").val(_self.vars.map.getZoom());
                        $(_self.vars.cssID).trigger("location_changed", $(_self.vars.cssID));
                    });

                    // Update location and zoom values based on input field's value
                    $(_self.vars.cssID + ".gllpUpdateButton").bind("click", function() {
                        var lat = $(_self.vars.cssID + ".gllpLatitude").val();
                        var lng = $(_self.vars.cssID + ".gllpLongitude").val();
                        var latlng = new google.maps.LatLng(lat, lng);
                        _self.vars.map.setZoom(parseInt($(_self.vars.cssID + ".gllpZoom").val()));
                        setPosition(latlng);
                    });

                    // Search function by search button
                    $(_self.vars.cssID + ".gllpSearchButton").bind("click", function() {
                        performSearch($(_self.vars.cssID + ".gllpSearchField").val(), false);
                    });

                    $(_self.vars.cssID + ".gllpSearchField").bind("keypress", function(e) {
                        if(e.which == 13) {
                            performSearch($(_self.vars.cssID + ".gllpSearchField").val(), false);
                            $(".gllpLatlonPicker #msg_maps").html("");
                        }

                    });

                    // Search function by gllp_perform_search listener
                    $(document).bind("gllp_perform_search", function(event, object) {
                        performSearch($(object).attr('string'), true);
                    });

                    // Zoom function triggered by gllp_perform_zoom listener
                    $(document).bind("gllp_update_fields", function(event) {
                        var lat = $(_self.vars.cssID + ".gllpLatitude").val();
                        var lng = $(_self.vars.cssID + ".gllpLongitude").val();
                        var latlng = new google.maps.LatLng(lat, lng);
                        _self.vars.map.setZoom(parseInt($(_self.vars.cssID + ".gllpZoom").val()));
                        setPosition(latlng);
                    });
                },
                // EXPORT PARAMS TO EASILY MODIFY THEM ////////////////////////////////////////////////////
                params: _self.params

            };

            return publicfunc;
        });

        $(document).ready(function() {
            if (!$.gMapsLatLonPickerNoAutoInit) {
                $(".gllpLatlonPicker").each(function() {
                    $obj = $(document).gMapsLatLonPicker();
                    $obj.init($(this));
                });
            }
        });

        $(document).bind("location_changed", function(event, object) {
            console.log("changed: " + $(object).attr('id'));
        });

        $(document).ready(function() {
            var i = 1;

            var dropdown = <?php echo json_encode(form_dropdown('name[]', $dd_nama, $nama_selected, 'class="form-control name_list "')); ?>;

            $('#add').click(function() {
                i++;
                $('#dynamic_field').append('<tr id="row' + i + '" class="dynamic-added"><td>' + dropdown + '</td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">X</button></td></tr>');
                $('#' + i).focus();
            });


            $(document).on('click', '.btn_remove', function() {
                var button_id = $(this).attr("id");
                $('#row' + button_id + '').remove();
            });
        });

        $(document).on('keypress',function(e) {
            if(e.which == 13) {
                $('.gllpSearchButton').click();
                $('.gllpSearchField').click();
            }
        });

    }(jQuery));

    $(document).on("click",".action-button",function(e){
        e.preventDefault();
        $('#message').html("");
        var loading = Ladda.create(this);

        if(!$("#lat").val()){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Silahkan tentukan lokasi absensi Anda terlebih dahulu pada peta diatas</font>");
            $('#lat').focus();
            return false;
        }else if(!$("#lng").val()){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Silahkan tentukan lokasi absensi Anda terlebih dahulu pada peta diatas</font>");
            $('#lng').focus();
            return false;
        }else if(!$("#kantor").val()){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama Lokasi belum diisi</font>");
            $("#kantor").focus();
            return false;
        }else if(!$("#jarak").val()){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Radius absensi belum diiisi</font>");
            $('#jarak').focus();
            return false;
        }
        loading.start();
        var param = 'kantor='+$("#kantor").val()+
                    '&cabang=<?= $id_cabang ?>'+
                    '&flag=1'+
                    '&lat='+$("#lat").val()+
                    '&lng='+$("#lng").val()+
                    '&jarak='+$("#jarak").val();

        $.ajax({
            type: 'POST',
            url: "<?= site_url('wizard/lokasi/insert') ?>",
            data: param,
            dataType:'JSON',
            success: function(result) {
                loading.stop();
                if(result.success == true){
                    if(result.type == 'save'){
                      $('#message').html("");
                      window.location.href = "<?= route('wizard.akun.kepala_departemen.home') ?>";
                    }
                } else {
                  $('#message').html(result.message);
                }
            },
            error:function(){
                loading.stop();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });
</script>
