<style>
/* Required Drawer CSS */
    .js-menu__context {
        /* background: rgba(0, 0, 0, 0.5); */
        left: 0;
        opacity: 0;
        position: absolute;
        top: 0;
        transition: opacity 0.5s, visibility 0.5s;
        visibility: hidden;
        width: 100%;
        height: 100%;
        border-radius: 0 15px 15px 0;
        z-index: 99;
    }

    .js-menu {
        color: #000;
        height: 100%;
        width: 100%;
        padding: 20px;
        margin: 0;
        background: #fff;
        /* overflow-y: auto; */
        border-radius: 0 15px 15px 0;

        -webkit-overflow-scrolling: touch;
        -ms-overflow-style: -ms-autohiding-scrollbar;
        transition: background 0.5s, transform 0.5s;
    }

    .js-menu--left {
        -webkit-transform: translateX(-100%);
        transform: translateX(-100%);
    }

    .js-menu--right {
        -webkit-transform: translateX(100%);
        transform: translateX(100%);
        position: absolute;
        right: 0;
    }

    .js-menu__open {
        cursor: pointer;
    }

    .js-menu__close {
        cursor: pointer;
    }

    .js-menu__expanded {
        -webkit-transform: translateX(0);
        transform: translateX(0);
        visibility: visible;
        opacity: 1;
    }
</style>

<?php
    $data_group  = $this->fungsi->get_data_group();
?>

<script type="text/javascript">
    $(function() {
        check_tambah_or_edit();

        // BTN FILTER
        $("#btn_cari").on("click", function() {
            var loading = Ladda.create(this);
            loading.start();
            check_tambah_or_edit()
            loading.stop();
        });

        // DROPDOWN TAHUN
        $(".kolom_filter #tahun").inputmask({
            'alias': 'datetime',
            'inputFormat': 'yyyy'
        });
        $(".kolom_filter #tahun").datepicker({
            format: "yyyy",
            viewMode: "years",
            orientation: 'bottom',
            minViewMode: "years",
            autoclose: true,
        });

        // START JS DRAWER
        $('.js-menu__context, .js-menu__close').on('touchend click', function(event) {
            if ($(event.target).hasClass('js-menu__context') || $(event.target).hasClass('js-menu__close')) {
                $('.js-menu__expanded').removeClass('js-menu__expanded');
                $(".div_pembungkus_js_menu_context").css('height', "0px");
            }
        });

        // DATATABLE
        list_data = $('#list_data').DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': false,
            'lengthChange': false,
            'ordering': false,
            'info': false,
            'scrollX': true,
            // 'scrollY': false,
            'fixedColumns': {
                leftColumns: 2
            },
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.master.target.kuartal.list.data') ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                    d.tahun  = $(".kolom_filter #tahun").val();
                },
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({'text-align': 'center', 'width': '10px'});

                var count_group = "<?= COUNT($data_group) ?>";

                if(count_group > 0){
                    for (let i = 2; i < count_group+2; i++) {
                        $('td:eq('+i+')', nRow).css({'text-align': 'right'});
                    }
                }else{
                    $('td:eq(2)', nRow).css({'text-align': 'center'});
                }
            }
        });
    });

    function test_slide(e){
        var menu = $(e).attr('data-menu');
        $(menu).toggleClass('js-menu__expanded');
        $(menu).parent().toggleClass('js-menu__expanded');

        var tahun       = $('.kolom_filter #tahun').val();
        var data_action = $(e).attr('data-action');
        if(data_action == "edit"){
            var nama_header = "Edit Target Kuartal";
        }else{
            var nama_header = "Tambah Target Kuartal";
        }

        load_url = "<?= route('sales_activity.master.target.kuartal.form.edit') ?>"+ "/" + tahun;
        return $.get(load_url, function(data) {
            $("#drawer-content").html(data);
            $("#header_form").html(nama_header);
        });
    }

    function check_tambah_or_edit(){
        var tahun = $('.kolom_filter #tahun').val();

        $.ajax({
            type: 'GET',
            url: '<?= route("sales_activity.master.target.kuartal.onchange.filter.tahun") ?>'+'?tahun='+tahun,
            dataType: 'json',
            success: function(result){
                if(result.success){
                    if(result.jumlah > 0){
                        $(".btn_tambah").removeClass("btn-success").addClass("btn-warning");
                        $(".btn_tambah").empty();
                        $(".btn_tambah").attr('data-action', 'edit');
                        $(".btn_tambah").append('<i class="fa fa-edit"></i>').append(' EDIT DATA');
                    }else{
                        $(".btn_tambah").removeClass("btn-warning").addClass("btn-success text-uppercase");
                        $(".btn_tambah").empty();
                        $(".btn_tambah").attr('data-action', 'tambah');
                        $(".btn_tambah").append('<i class="fa fa-plus"></i>').append(' <?= $this->lang->line('tambah_target') ?>');
                    }
                }else{
                    alert("<?= $this->lang->line('data_tidak_ditemukan') ?>")
                }
            }
        })
    }
</script>

<div class="div_pembungkus_js_menu_context">
    <div class="js-menu__context">
        <div id="drawer" class="js-menu js-menu--right">
            <div id="drawer-content"></div>
        </div>
    </div>
</div>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-12 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color"><?= $this->lang->line('target_kuartal') ?></h5>
    </div>
</div>

<div class="kolom_filter">
    <div class="form-group row mt-2" style="font-size: 13px !important;">
        <div class="col-md-1 font-weight-bold">
            <label class="align-self-center"><?= strtoupper($this->lang->line('tahun')) ?></label>
        </div>
        <div class="col-md-3">
            <input type="text" id="tahun" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('Y') ?>">
        </div>
        <div class="col-md-2">
            <button type="button" id="btn_cari" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">FILTER</button>
        </div>
    </div>
</div>

<hr>

<div class="row align-items-center mt-1">
    <div class="content-header-right col-md-12 col-12">
        <button type="button" class="btn btn_tambah js-menu__open pull-right" data-menu="#drawer" onclick="test_slide(this)">
        </button>
    </div>
</div> 

<div class="table-responsive mt-2">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <?php if(!empty($data_group)){ ?>
                <tr>
                    <th rowspan="2" class="text-center align-middle" width="20">NO</th>
                    <th rowspan="2" class="text-center align-middle text-uppercase"><?= $this->lang->line('bulan') ?></th>

                    <?php
                        foreach($data_group AS $rows){
                            $nama_group = $rows->kode_group. " - ". $rows->nama_group;
                    ?>
                            <th colspan="2" class="text-center align-middle"><?= $nama_group ?></th>
                    <?php
                        }
                    ?>
                </tr>
                
                <tr>
                    <?php
                        foreach($data_group AS $rows){
                    ?>
                            <th class="text-center align-middle">TARGET TAHUNAN</th>
                            <th class="text-center align-middle">TARGET KUARTAL</th>
                    <?php
                        }
                    ?>
                </tr>
            <?php }else{ ?>
                <tr>
                    <th rowspan="2" class="text-center align-middle" width="20">NO</th>
                    <th rowspan="2" class="text-center align-middle text-uppercase"><?= $this->lang->line('bulan') ?></th>
                    <th colspan="2" class="text-center align-middle text-uppercase">-</th>
                </tr>
                <tr>
                    <th class="text-center align-middle">TARGET TAHUNAN</th>
                    <th class="text-center align-middle">TARGET KUARTAL</th>
                </tr>
            <?php } ?>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>