<script type="text/javascript">
    $(function() {
        <?php if ($this->level_user === '1' || $this->is_sales_admin === true || $this->is_sales_atasan === true): ?>
            list_sales();
        <?php endif; ?>
        list_pelanggan();
        list_jenis_perusahaan();
        list_lead_source();
        dropdown_provinsi();
        dropdown_kota();
        dropdown_kecamatan();
        dropdown_kelurahan();
        set_masking();
        list_produk();

        $('input[type="tel"]').on('input', function(e) {
            e.preventDefault();
            $(this).val($(this).val().replace(/[^0-9]/g, ''));
        });

        $('#alamat_perusahaan textarea').on('input', function(e) {
            e.preventDefault();
            $(this).val($(this).val().replace(/[^a-zA-Z0-9\/\.,\- \n]/g, ''));
            limit_char(this, 255);
        });

        $('#keterangan textarea').on('input', function(e) {
            e.preventDefault();
            limit_char(this, 255);
        });

        $('input[name="flag_jenis"]').on('change', function() {
            $("#message").html("");
            $("#select_pelanggan select").html("");

            if (this.checked) {
                $('input[name="flag_jenis"]').not(this).prop('checked', false);
            } else {
                $(this).prop('checked', true);
            }

            if (this.value == "perusahaan") {
                $("#form_kanban h6:eq(2)").html("Data Perusahaan");
                $("#select_pelanggan label").html('Nama Perusahaan<i class="text-danger">*</i>');
                $("#jenis_perusahaan label").html('Jenis Perusahaan<i class="text-danger">*</i>');
                $("#jenis_perusahaan select").val(null).trigger("change");
                $("#form_kanban h6:eq(4)").html("Data PIC");
                $("#nama_pic").removeClass("hidden");
                $("#email_pic").removeClass("col-6");
                $("#telp_pic").removeClass("col-6");
            } else {
                $("#form_kanban h6:eq(2)").html("Data Personal");
                $("#select_pelanggan label").html('Nama<i class="text-danger">*</i>');
                // $("#select_pelanggan select").val(null).trigger("change");
                $("#jenis_perusahaan label").html('Jenis Perorangan<i class="text-danger">*</i>');
                $("#jenis_perusahaan select").val(null).trigger("change");
                $("#form_kanban h6:eq(4)").html("Kontak");
                $("#nama_pic").addClass("hidden");
                $("#email_pic").addClass("col-6");
                $("#telp_pic").addClass("col-6");
            }

            // remove alert error
            error_form("select", $("#select_pelanggan"), "", false);
            error_form("input", $("#nama_pic"), "", false);

            // reset
            list_pelanggan(this.value);
            list_jenis_perusahaan(this.value);
            list_lead_source();
            dropdown_provinsi();
            dropdown_kota();
            dropdown_kecamatan();
            dropdown_kelurahan();
        });

        // add new product
        $("#add_product").on("click", function() {
            const row = $("#prospek_layanan tfoot");
            const product_id = row.find("select option:selected").val();
            const product_name = row.find("select option:selected").text();
            let nominal = parseInt(row.find("input:eq(0)").val().replaceAll('.', ''));
            let jumlah = parseInt(row.find("input:eq(1)").val().replaceAll('.', ''));
            let diskon = parseFloat(row.find("input:eq(2)").val().replace(',', '.'));
            let total = 0;

            // validation
            row.find(".select2-selection").removeAttr('style');
            if (!product_id) {
                row.find(".select2-selection").css('border', '1px solid red');
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_layanan_kosong') ?></font>");
                $('#message').show();
                return false;
            }
            if (!nominal) {
                nominal = 0;
            }
            if (!jumlah) {
                jumlah = 0;
            }
            if (!diskon) {
                diskon = 0;
            }

            // calculate
            total = (nominal * jumlah) - ((nominal * jumlah) * diskon / 100);

            const html = `
                <tr style="font-size: 11px">
                    <td class="p-10.5px">
                        <span data-id="` + product_id + `">` + product_name + `</span>
                        <select class="select2 form-control" style="width: 100%;font-size: 11px">
                            <option value="` + product_id + `" selected>` + product_name + `</option>
                        </select>
                    </td>
                    <td class="produk-nominal p-10.5px" style="width:140px;">
                        <span class="float-right">
                            ` + nominal.toLocaleString('id-ID') + `
                        </span>
                        <input type="text" class="form-control" value="` + nominal + `" placeholder="0" style="font-size: 11px" oninput="total_price(this)">
                    </td>
                    <td class="produk-nominal text-center p-10.5px" style="width:80px;">
                        <span>` + jumlah.toLocaleString('id-ID') + `</span>
                        <input type="text" class="form-control" value="` + jumlah + `" placeholder="0" style="font-size: 11px" oninput="total_price(this)">
                    </td>
                    <td class="produk-diskon text-center p-10.5px" style="width:80px;">
                        <span>` + diskon.toLocaleString('id-ID') + `%</span>
                        <input type="text" class="form-control" value="` + diskon.toLocaleString('id-ID') + `" placeholder="0" style="font-size: 11px" oninput="total_price(this)">
                    </td>
                    <td class="align-middle">
                        <span class="float-right" data-total="` + total.toLocaleString('id-ID') + `">` + total.toLocaleString('id-ID') + `</span>
                    </td>
                    <td class="p-10.5px align-middle text-center" style="width: 60px;">
                        <div>
                            <button class="btn btn-sm btn-link text-primary" onclick="save_product(this)" style="padding: 1px;" title="` + "<?= $this->lang->line('button_form_simpan') ?>" + `"><i class="fa fa-check"></i></button>
                            <button class="btn btn-sm btn-link text-danger" onclick="cancel_product(this)" style="padding: 1px;" title="` + "<?= $this->lang->line('button_form_batal') ?>" + `"><i class="fa fa-times"></i></button>
                        </div>
                        <div>
                            <button class="btn btn-sm btn-link text-warning" onclick="edit_product(this)" style="padding: 1px;" title="EDIT"><i class="fa fa-edit"></i></button>
                            <button class="btn btn-sm btn-link text-danger" onclick="remove_product(this)" style="padding: 1px;" title="` + "<?= $this->lang->line('hapus') ?>" + `"><i class="fa fa-trash"></i></button>
                        </div>
                    </td>
                </tr>
            `;

            $("#prospek_layanan tbody").append(html);

            set_masking();
            list_produk();

            reset_product();
            hide_product_form();
            show_product_data();
        });

        // action
        $('#btn_new_input').on('click', function() {
            $("#btn_tambah").click();
        });
    });

    function limit_char(e, limit = 255) {
        var maxLength = limit;
        var text = $(e).val();
        if (text.length > maxLength) {
            $(e).val(text.substring(0, maxLength));
        }
    }

    function find_perusahaan(arr, searchId) {
        for (const item of arr) {
            if (item.id === searchId) {
                return item.perusahaan;
            }
        }
        return null;
    }

    function format_input(e, regex, max = null) {
        var value = e.value;
        if (!regex.test(value)) {
            e.value = value.slice(0, -1);
        }
        if (max != null) {
            if (value.length > max) {
                e.value = value.slice(0, -1);
            }
        }
    }

    function list_sales() {
        $("#select_sales").select2({
            placeholder: "Pilih sales",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("sales_activity.kanban.list_sales") ?>',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search: params.term,
                        topic: "kanban",
                        range: 0,
                        start: get_periode()
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_provinsi() {
        $('#provinsi_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_provinsi') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.provinsi")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            $('#kota_perusahaan select').val(null).trigger("change");
            $('#kecamatan_perusahaan select').val(null).trigger("change");
            $('#kelurahan_perusahaan select').val(null).trigger("change");
            dropdown_kota($("#provinsi_perusahaan select").val());
        });
    }

    function dropdown_kota(prov = '-') {
        $('#kota_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_kota') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.kota", ["id_prov" => "'+ prov +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            $('#kecamatan_perusahaan select').val(null).trigger("change");
            $('#kelurahan_perusahaan select').val(null).trigger("change");
            dropdown_kecamatan($("#kota_perusahaan select").val());
        });
    }

    function dropdown_kecamatan(kota = '-') {
        $('#kecamatan_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_kecamatan') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.kecamatan", ["id_kota" => "'+ kota +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            $('#kelurahan_perusahaan select').val(null).trigger("change");
            dropdown_kelurahan($("#kecamatan_perusahaan select").val());
        });
    }

    function dropdown_kelurahan(kecamatan = '-') {
        $('#kelurahan_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_kelurahan') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.kelurahan", ["id_kecamatan" => "'+ kecamatan +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            //
        });
    }

    function list_pelanggan(kategori = "perusahaan") {
        var list_pelanggan = [];
        $('#select_pelanggan select').select2({
            placeholder: (kategori == "perusahaan") ? "Pilih Perusahaan" : "Pilih",
            tags: true,
            dropdownParent: $("#form_kanban"),
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.kanban.list_pelanggan", ["kategori" => "'+ kategori +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    list_pelanggan = data;
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function(e) {
            const perusahaan = find_perusahaan(list_pelanggan, e.target.value);

            // assign value
            if (perusahaan) {
                var $option = "";

                var optionExists = $("#jenis_perusahaan select option[value='" + perusahaan.id_jenis_perusahaan + "']").length > 0;
                if (optionExists) {
                    $("#jenis_perusahaan select").val(perusahaan.id_jenis_perusahaan).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.jenis_perusahaan + "</option>").val(perusahaan.id_jenis_perusahaan);
                    $("#jenis_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#lead_source select option[value='" + perusahaan.id_lead_source + "']").length > 0;
                if (optionExists) {
                    $("#lead_source select").val(perusahaan.id_lead_source).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.lead_source + "</option>").val(perusahaan.id_lead_source);
                    $("#lead_source select").append($option).trigger("change");
                }

                $("#alamat_perusahaan textarea").val(perusahaan.alamat);

                var optionExists = $("#provinsi_perusahaan select option[value='" + perusahaan.id_provinsi + "']").length > 0;
                if (optionExists) {
                    $("#provinsi_perusahaan select").val(perusahaan.id_provinsi).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.provinsi + "</option>").val(perusahaan.id_provinsi);
                    $("#provinsi_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#kota_perusahaan select option[value='" + perusahaan.id_kota + "']").length > 0;
                if (optionExists) {
                    $("#kota_perusahaan select").val(perusahaan.id_kota).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.kota + "</option>").val(perusahaan.id_kota);
                    $("#kota_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#kecamatan_perusahaan select option[value='" + perusahaan.id_kecamatan + "']").length > 0;
                if (optionExists) {
                    $("#kecamatan_perusahaan select").val(perusahaan.id_kecamatan).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.kecamatan + "</option>").val(perusahaan.id_kecamatan);
                    $("#kecamatan_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#kelurahan_perusahaan select option[value='" + perusahaan.id_kelurahan + "']").length > 0;
                if (optionExists) {
                    $("#kelurahan_perusahaan select").val(perusahaan.id_kelurahan).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.kelurahan + "</option>").val(perusahaan.id_kelurahan);
                    $("#kelurahan_perusahaan select").append($option).trigger("change");
                }

                $("#nama_pic input").val(perusahaan.pic_nama);
                $("#email_pic input").val(perusahaan.pic_email);
                $("#telp_pic input").val(perusahaan.pic_telp);
            }
        })
    }

    function list_jenis_perusahaan(flag_jenis="perusahaan") {
        $('#jenis_perusahaan select').select2({
            placeholder: 'Pilih Jenis' + (flag_jenis == "perusahaan" ? " Perusahaan" : " Perorangan"),
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("sales_activity.kanban.list_jenis_perusahaan") ?>' + '?flag_jenis=' + flag_jenis,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('select2:select', function() {
            $('#lead_source select').val(null).trigger("change");
        });
    }

    function list_lead_source() {
        $('#lead_source select').select2({
            placeholder: 'Pilih Lead Source',
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("sales_activity.kanban.list_lead_source") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('select2:select', function() {
            $("#alamat_perusahaan input").focus();
        });
    }

    // prospek layanan
    function set_masking() {
        // nominal
        $(".produk-nominal input").inputmask('numeric', {
            rightAlign: true,
            min: 0,
            digits: 0,
            groupSeparator: '.',
            autoGroup: true,
            allowMinus: false
        });

        // diskon
        $(".produk-diskon input").inputmask('decimal', {
            rightAlign: true,
            min: 0,
            max: 100,
            digits: 2,
            radixPoint: ',',
            allowMinus: false
        });
    }

    function list_produk() {
        $('#prospek_layanan select').select2({
            placeholder: 'Pilih Produk/Layanan',
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("sales_activity.kanban.list_produk") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).change(function() {
            let row = $(this).closest("tr");
            if (!this.value) {
                row.find("select").empty();
            }
            if ($(this).find("option").length > 1) {
                row.find('option:not([value="' + $(this).val() + '"])').remove();
            }

            let parts = this.value.split('#');
            let value = parseInt(parts[1]);

            row.find("input:eq(0)").val(value);
            row.find("input:eq(1)").val((!value) ? "" : 1);
            row.find("input:eq(2)").val((!value) ? "" : 0);

            total_price(this);
        });
    }

    function save_product(e) {
        $('#message').html("");

        let target = $(e).closest("tr");
        const produk = target.find("select").val();
        const nominal = parseInt(target.find("input:eq(0)").val().replaceAll('.', ''));
        const jumlah = parseInt(target.find("input:eq(1)").val().replaceAll('.', ''));
        const diskon = parseFloat(target.find("input:eq(2)").val().replace(",", "."));

        // validation
        target.find(".select2-selection").removeAttr('style');
        if (!produk) {
            target.find(".select2-selection").css('border', '1px solid red');
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_layanan_kosong') ?></font>");
            $('#message').show();
            return false;
        }

        // assign last value
        target.find("td:eq(0) span:eq(0)").attr("data-id", produk);
        target.find("td:eq(0) span:eq(0)").text(target.find("td:eq(0) :selected").text());

        target.find("td:eq(1) span:eq(0)").html(nominal.toLocaleString("id-ID"));
        target.find("input:eq(0)").attr("value", nominal);

        target.find("td:eq(2) span:eq(0)").html(jumlah.toLocaleString("id-ID"));
        target.find("input:eq(1)").attr("value", jumlah);

        target.find("td:eq(3) span:eq(0)").html(diskon.toLocaleString("id-ID") + "%");
        target.find("input:eq(2)").attr("value", diskon.toLocaleString("id-ID"));

        let total = total_price(e);
        target.find("td:eq(4) span:eq(0)").attr("data-total", total.toLocaleString('id-ID'));

        hide_product_form(e);
        show_product_data(e);
    }

    function cancel_product(e) {
        $('#message').html("");

        let target = $(e).closest("tr");
        let produk = target.find("td:eq(0) span:eq(0)").data("id");
        let nama_produk = target.find("td:eq(0) span:eq(0)").text();

        target.find(".select2-selection").removeAttr('style');
        target.find("td:eq(0) select").html('<option value="' + produk + '">' + nama_produk + '</option>');
        target.find("td:eq(0) select").val(produk).trigger('change');

        hide_product_form(e);
        show_product_data(e);
    }

    function edit_product(e) {
        let target = $(e).closest("tr");
        target.find("td:not(:nth-last-child(-n+2)) > span").hide();
        target.find("td .select2").show();
        target.find("td input").show();
        target.find("td:last-child div:first-child").show();
        target.find("td:last-child div:last-child").hide();

        // assign last value
        // let produk = target.find("td:eq(0) span:eq(0)").data("id");
        let nominal = parseInt(target.find("td:eq(1) span:eq(0)").text().replaceAll(".", ""));
        let jumlah = parseInt(target.find("td:eq(2) span:eq(0)").text().replaceAll(".", ""));
        let diskon = target.find("td:eq(3) span:eq(0)").text().replace("%", "");

        target.find("input:eq(0)").val(nominal);
        target.find("input:eq(1)").val((!jumlah) ? "" : jumlah);
        target.find("input:eq(2)").val((!diskon) ? "" : diskon);

        total_price(e);
    }

    function hide_product_form(e = null) {
        if (e != null) {
            let target = $(e).closest("tr");
            target.find(".select2").hide();
            target.find("input").hide();
            target.find("td:last-child div:first-child").hide();
            target.find("td:last-child div:last-child").show();
            target.find("td:nth-last-child(2) span").html(target.find("td:nth-last-child(2) span").attr("data-total"));
        } else {
            $("tbody .select2").hide();
            $("tbody input").hide();
            $("tbody td:last-child div:first-child").hide();
            $("tbody td:last-child div:last-child").show();

            // assign total
            $("tbody td:nth-last-child(2) span").each(function() {
                $(this).html($(this).attr("data-total"));
            });
        }
    }

    function show_product_data(e = null) {
        if (e != null) {
            let target = $(e).closest("tr");
            target.find("td").each(function() {
                $(this).find("span:eq(0)").show();
            });
        } else {
            $("tbody td").each(function() {
                $(this).find("span:eq(0)").show();
            });
        }
    }

    function remove_product(e) {
        $(e).closest('tr').remove();
    }

    function reset_product() {
        $("#prospek_layanan tfoot select").val("").trigger("change");
        $("#prospek_layanan tfoot select").empty();
        $("#prospek_layanan tfoot input").val("");
        $("#message").hide();
    }

    function total_price(e) {
        const row = $(e).closest('tr');
        let nominal = parseInt(row.find("input:eq(0)").val().replaceAll('.', ''));
        let jumlah = parseInt(row.find("input:eq(1)").val().replaceAll('.', ''));
        let diskon = parseFloat(row.find("input:eq(2)").val().replace(',', '.'));
        let total = 0;

        if (!nominal) {
            nominal = 0;
        }
        if (!jumlah) {
            jumlah = 0;
        }
        if (!diskon) {
            diskon = 0;
        }

        total = (nominal * jumlah) - ((nominal * jumlah) * diskon / 100);

        row.find("td:eq(4) span:eq(0)").html(total.toLocaleString('id-ID'));

        return total;
    }
</script>
<style>
    #form_kanban.card-body {
        color: grey;
        font-size: 12px;
    }

    #form_kanban .text-biru {
        color: #1c77d4;
    }

    .select2-hidden-accessible {
        position: fixed !important;
    }
</style>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_kanban" class="card-body" disabled>
    <?php if ($this->level_user === '1' || $this->is_sales_admin === true || $this->is_sales_atasan === true): ?>
        <div class="form-group pb-1">
            <h6 class="font-weight-bold text-biru">Data Sales</h6>
            <hr>
            <label>Sales<i class="text-danger">*</i></label>
            <div>
                <select id="select_sales" class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
    <?php endif; ?>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Data Calon Customer</h6>
        <hr>
        <label>Jenis Pelanggan</label>
        <div class="row">
            <div class="form-check">
                <input id="kategori_perusahaan" class="form-check-input" type="checkbox" style="border-radius: 50%;" name="flag_jenis" value="perusahaan" checked>
                <label class="form-check-label text-secondary" for="kategori_perusahaan" style="font-size: 12px;">
                    Perusahaan
                </label>
            </div>
            <div class="form-check">
                <input id="kategori_perorangan" class="form-check-input" type="checkbox" style="border-radius: 50%;" name="flag_jenis" value="perorangan">
                <label class="form-check-label text-secondary" for="kategori_perorangan" style="font-size: 12px;">
                    Perorangan
                </label>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Data Perusahaan</h6>
        <hr>
        <div class="row">
            <div id="select_pelanggan" class="col-12 mb-1">
                <label for="select_pelanggan">Nama Perusahaan<i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="jenis_perusahaan" class="col-6">
                <label for="jenis_perusahaan">Jenis Perusahaan<i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="lead_source" class="col-6">
                <label for="lead_source">Lead Source<i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru"><?= $this->lang->line('alamat') ?></h6>
        <hr>
        <div class="row">
            <div id="alamat_perusahaan" class="col-12 mb-1">
                <label for="alamat_perusahaan"><?= $this->lang->line('alamat') ?><i class="text-danger">*</i></label>
                <textarea class="form-control" rows="3" placeholder="<?= $this->lang->line('alamat') ?>" autocomplete="off"></textarea>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="provinsi_perusahaan" class="col-6 mb-1">
                <label for="provinsi_perusahaan"><?= $this->lang->line('provinsi') ?><i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="kota_perusahaan" class="col-6 mb-1">
                <label for="kota_perusahaan"><?= $this->lang->line('kota') ?><i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="kecamatan_perusahaan" class="col-6">
                <label for="kecamatan_perusahaan"><?= $this->lang->line('kecamatan') ?></label>
                <select class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="kelurahan_perusahaan" class="col-6">
                <label for="kelurahan_perusahaan"><?= $this->lang->line('kelurahan') ?></label>
                <select class="select2 form-control" style="width: 100%"></select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Data PIC</h6>
        <hr>
        <div class="row">
            <div id="nama_pic" class="col-4">
                <label for="nama_pic"><?= $this->lang->line('nama') ?><i class="text-danger">*</i></label>
                <input type="text" oninput="format_input(this, /^[a-zA-Z0-9\.\,\-\' ]*$/)" class="form-control" placeholder="<?= $this->lang->line('nama') ?>" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="email_pic" class="col-4">
                <label for="email_pic"><?= $this->lang->line('email') ?></label>
                <input type="email" class="form-control" placeholder="<?= $this->lang->line('email') ?>" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="telp_pic" class="col-4">
                <label for="telp_pic"><?= $this->lang->line('no_telp') ?><i class="text-danger">*</i></label>
                <input type="tel" class="form-control" placeholder="<?= $this->lang->line('no_telp') ?>" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Deskripsi</h6>
        <hr>
        <div class="row mb-1">
            <div id="title" class="col-12">
                <label for="title">Judul<i class="text-danger">*</i></label>
                <input type="text" class="form-control" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
        <div class="row">
            <div id="keterangan" class="col-12">
                <label for="keterangan"><?= $this->lang->line('keterangan') ?></label>
                <textarea class="form-control" rows="5"></textarea>
            </div>
        </div>
    </div>

    <div class="form-group">
        <h6 class="font-weight-bold text-biru">Prospek Layanan</h6>
        <hr>
        <div id="prospek_layanan">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="bg-light">
                        <tr>
                            <th class="text-center align-middle">Produk/Layanan</th>
                            <th class="text-center align-middle" style="width: 140px;">Nominal</th>
                            <th class="text-center align-middle p-10.5px" style="width: 80px;">Jumlah<br>Produk</th>
                            <th class="text-center align-middle p-10.5px" style="width: 80px;">Diskon<br>(%)</th>
                            <th class="text-center align-middle" style="width: 150px;">Total</th>
                            <th class="text-center align-middle p-10.5px" style="width: 60px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                    <tfoot>
                        <tr class="text-center">
                            <td class="p-10.5px">
                                <select class="select2 form-control" style="width: 100%;font-size: 11px"></select>
                                <p class="alert-layanan mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
                            </td>
                            <td class="produk-nominal p-10.5px" style="width:140px;">
                                <input type="text" class="form-control" placeholder="0" style="font-size: 11px" oninput="total_price(this)">
                            </td>
                            <td class="produk-nominal p-10.5px" style="width: 80px;">
                                <input type="text" class="form-control" placeholder="0" style="font-size: 11px" oninput="total_price(this)">
                            </td>
                            <td class="produk-diskon p-10.5px" style="width: 80px;">
                                <input type="text" class="form-control" placeholder="0" style="font-size: 11px" oninput="total_price(this)">
                            </td>
                            <td class="align-middle">
                                <span class="float-right" style="font-size: 11px">0</span>
                            </td>
                            <td class="p-0 pt-1">
                                <button type="button" id="add_product" class="btn btn-link btn-sm" title="<?= strtoupper($this->lang->line('button_form_simpan')) ?>"><i class="fa fa-save"></i></button>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button id="btn_submit" class="ladda-button" data-style="expand-left"></button>
        </div>
    </div>
</div>
