<script type="text/javascript">

    $(function () {

        $(document).on('click', '.btn_detail', function () {
            var id = $(this).attr("id");
            $('#modal_detail_sos').modal('show');
            $('#foto').empty();
            $.get("<?= route("sos.laporan.detail") ?>" + "/" + id, function (data) {
                // SET DETAIL SOS
                $("#nama_karyawan").text(data.nama_karyawan);
                $("#jabatan").text(data.jabatan);
                $("#tanggal").text(data.tanggal);
                $("#keterangan").text(data.keterangan);
            }, "json");
            $.get('<?= route("sos.laporan.detail.foto") ?>/' + id, function (data) {
                if (data != null) {
                    for (const [key, value] of Object.entries(data)) {
                        $('#foto').append('<img src="' + value + '" alt="..." class="img-thumbnail">');
                    }
                }
            }, 'json');
        });
    });
</script>
<div class="row">
    <div class="col-md-12">
        <div class="float-md-right">
            <button type="button" id="btn_download" class="btn btn-info" tglmulai="<?= $tgl_mulai ?>" tglselesai="<?= $tgl_selesai ?>" idkaryawan="0" idcabang="0" iddepartemen="0">
                <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?></button>
        </div>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-12">
        <div class="table-responsive">
            <table id="list_data" class="table table-striped" style="width:100%">
                <thead>
                    <tr class="bg-tr">
                        <th class="text-center">NO</th>
                        <th class="text-left"><?= strtoupper($this->lang->line('tgl')); ?></th>
                        <th class="text-left"><?= strtoupper($this->lang->line('nama')); ?></th>
                        <th class="text-left"><?= strtoupper($this->lang->line('keterangan')); ?></th>
                        <?php
                        if (in_array($this->level_user, array("1"))) {
                            ?>
                            <th class="text-center"><?= strtoupper($this->lang->line('aksi')); ?></th>
                            <?php
                        }
                        ?>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>


<!-- START TAMPIL MODAL -->
<div id="modal_detail_sos" class="modal fade in" data-keyboard="false" data-backdrop="static" aria-hidden="true">
    <div class="modal-dialog" style="max-width: 80%;">
        <div id="tampil_form" class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"><?= $this->lang->line('detail_sos') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-md-6">
                        <label><?= $this->lang->line('nama'); ?></label>
                        <h5 id="nama_karyawan"></h5>
                    </div>
                    <div class="col-md-6">
                        <label><?= $this->lang->line('tgl'); ?></label>
                        <h5 id="tanggal"></h5>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-6">
                        <label><?= $this->lang->line('jabatan'); ?>, <?= $this->lang->line('cabang') ?>, <?= $this->lang->line('departemen') ?></label>
                        <h5 id="jabatan"></h5>
                    </div>
                    <div class="col-md-6">
                        <label><?= $this->lang->line('keterangan'); ?></label>
                        <h5 id="keterangan"></h5>
                    </div>
                </div>
                <hr>
                <div class="row mt-2">
                    <div class="col-md-12 text-center thumbnail">
                        <h5><?= strtoupper($this->lang->line('poto_sos')) ?></h5>
                        <div id="foto" style="overflow-y: scroll; height:400px;"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-close"></i> <?= $this->lang->line('button_form_tutup'); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            'scrollCollapse': true,
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Keterangan'
                                            <?php else: ?> 'searchPlaceholder': 'Description'
                                            <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('sos.laporan.listdata') . "/" . $tgl_mulai . "/" . $tgl_selesai . "/" . $id_karyawan . "/" . $id_cabang . "/" . $id_departemen ?>",
                "type": "GET",
                "complete": function (data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [
                { "aTargets": [0], "bSortable": false }<?php
                if (in_array($this->level_user, array("1"))) {
                    ?>
                    , { "aTargets": [-1], "bSortable": false }

                                            <?php } ?>
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({ 'text-align': 'center', 'width': '10px' });
                $('td:eq(1)', nRow).css({ 'text-align': 'left', 'width': '100px' });
                $('td:eq(2)', nRow).css({ 'text-align': 'left', 'width': '200px' });
                <?php
                if (in_array($this->level_user, array("1"))) {
                    ?>
                    $('td:eq(-1)', nRow).css({ 'text-align': 'center', 'width': '50px' });
                <?php } ?>
            }

        });
    })
</script>