<script type="text/javascript">
    $(document).ready(function () {
        table = $('#list_data').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "order": [], //Initial no order.
            "searching": true,
            'ordering': true,
            'paging': true,
            'lengthChange': true,
            'info': true,
            'stateSave': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('reimburse.list.data') ?>",
                "type": "POST",
                "data": {
                    tipe: function () {
                        if (sessionStorage.getItem('sel_tab')) {
                            return sessionStorage.getItem('sel_tab');
                        } else {
                            return $("#tipe_pengajuan").val();
                        }
                    },
                    saya: <?= ($saya) ? 1 : 2 ?>,
                },
                "complete": function (data) {
                    // reconfigure(data);
                }
            },

            "aoColumnDefs": [
                { "aTargets": [0], "bSortable": false },
                { "aTargets": [-1], "bSortable": false }
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({ 'text-align': 'center', 'width': '50px' });
                $('td:eq(1)', nRow).css({ 'text-align': 'center', 'width': '100px' });
                $('td:eq(2)', nRow).css({ 'text-align': 'center', 'width': '100px' });
                $('td:eq(6)', nRow).css({ 'text-align': 'right', 'width': '100px' });
                $('td:eq(8)', nRow).css({ 'text-align': 'center', 'width': '100px' });
            }

        });
        switch (sessionStorage.getItem('sel_tab')) {
            case '3':
                document.querySelectorAll("[role=tablist] .nav-item a")[2].className = "nav-link active";
                break;

            case '4':
                document.querySelectorAll("[role=tablist] .nav-item a")[1].className = "nav-link active";
                break;

            case '5':
                document.querySelectorAll("[role=tablist] .nav-item a")[3].className = "nav-link active";
                break;

            default:
                document.querySelectorAll("[role=tablist] .nav-item a")[0].className = "nav-link active";
                $("#tipe_pengajuan").val(1);
                break;
        }
    });

    function list_data(value) {
        sessionStorage.setItem('sel_tab', value);

        // munculkan tombol detail
        if (value != 1) {
            $('#detail_reimburse').text('DETAIL');
        } else {
            <?php if ($saya) { ?>
                $('#detail_reimburse').text('DETAIL');
            <?php } else { ?>
                $('#detail_reimburse').text(' ');
            <?php } ?>
        }
        $("#tipe_pengajuan").val(value);
        table.ajax.reload();
    }
</script>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Reimbursement</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="nav-tabs-boxed">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item"><a href="#" onclick="list_data(1)" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-file-text"></i> Pengajuan</h6>
                        </a></li>
                    <li class="nav-item"><a href="#" onclick="list_data(4)" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-file-text"></i> Revisi</h6>
                        </a></li>
                    <li class="nav-item"><a href="#" onclick="list_data(3)" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-file-text"></i> Ditolak</h6>
                        </a></li>
                    <li class="nav-item"><a href="#" onclick="list_data(5)" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-file-text"></i> Disetujui</h6>
                        </a></li>
                </ul>
            </div>


            <div class="row mt-3">
                <div class="col-md-12">
                    <input type="hidden" id="tipe_pengajuan" value="1">
                    <div class="table-responsive">
                        <table id="list_data" class="table table-striped table-hover" style="width:100%">
                            <thead>
                                <tr class="bg-tr">
                                    <th class="text-center" rowspan="2">NO</th>
                                    <th class="text-center" rowspan="2">TANGGAL</th>
                                    <th class="text-center" rowspan="2">NO PENGAJUAN</th>
                                    <th class="text-left" rowspan="2">KARYAWAN</th>
                                    <th class="text-left" rowspan="2">CABANG</th>
                                    <th class="text-left" rowspan="2">DEPARTEMEN</th>
                                    <th class="text-right" rowspan="2">NOMINAL</th>
                                    <th class="text-left" rowspan="2">KETERANGAN</th>
                                    <th class="text-center" colspan="5">APPROVAL</th>
                                    <th id="detail_reimburse" class="text-center" rowspan="2"><?= ($saya) ? "DETAIL" : "" ?></th>
                                </tr>
                                <tr class="bg-tr">
                                    <th>SUPERVISI</th>
                                    <th>KEP. DEP</th>
                                    <th>KEP. CAB</th>
                                    <th>DIREKSI</th>
                                    <th>ADMIN REIMBURSE</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->