<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Informasi_lembur_m extends CI_Model
{
    /**
     * get master pengaturan lembur
     *
     * @return array
     */
    public function get_master_lembur(): array
    {
        // get master aturan lembur
        $aturan_lembur = $this->db->select('id_lembur_p, kode, keterangan')
            ->from('payroll_lembur_p')
            ->where('id_company', $this->id_company)
            ->get()
            ->result();

        $master_lembur = [];
        foreach ($aturan_lembur as $value) {
            $master_lembur[$value->id_lembur_p] = [
                'kode'       => $value->kode,
                'keterangan' => $value->keterangan
            ];
        }

        return $master_lembur;
    }

    /**
     * get pengaturan lembur karyawan
     *
     * @param string $id_karyawan = md5 dari id_karyawan
     * @return array
     */
    public function get_aturan_lembur($id_karyawan): array
    {
        // get master aturan lembur
        $master_lembur = $this->get_master_lembur();

        // get lembur karyawan
        $lembur_karyawan = $this->db->select('
                id_lembur_m,
                id_karyawan,
                lembur_hari_kerja,
                lembur_libur_off,
                lembur_libur_nasional,
                lembur_libur_khusus
            ')
            ->from('payroll_lembur_m')
            ->where('id_company', $this->id_company)
            ->where('md5(id_karyawan)', $id_karyawan)
            ->get()
            ->result();

        // early return
        if (!$lembur_karyawan) {
            return [];
        }

        foreach ($lembur_karyawan as $value) {
            $data = [
                'lembur_hari_kerja'     => array_merge($master_lembur[$value->lembur_hari_kerja], ['id' => $value->id_lembur_m, 'lembur_hari_kerja' => $value->lembur_hari_kerja]),
                'lembur_libur_off'      => array_merge($master_lembur[$value->lembur_libur_off], ['id' => $value->id_lembur_m, 'lembur_libur_off' => $value->lembur_libur_off]),
                'lembur_libur_nasional' => array_merge($master_lembur[$value->lembur_libur_nasional], ['id' => $value->id_lembur_m, 'lembur_libur_nasional' => $value->lembur_libur_nasional]),
                'lembur_libur_khusus'   => array_merge($master_lembur[$value->lembur_libur_khusus], ['id' => $value->id_lembur_m, 'lembur_libur_khusus' => $value->lembur_libur_khusus]),
            ];
        }

        return $data;
    }

    public function save($column, $value, $id_karyawan)
    {
        // cek apakah data sudah ada
        $data_exist = $this->db->select('id_karyawan')
            ->where('id_company', $this->id_company)
            ->where('id_karyawan', $id_karyawan)
            ->get('payroll_lembur_m');

        $this->db->trans_begin();

        if ($data_exist->num_rows() > 0) {
            $this->db->update('payroll_lembur_m', [
                $column       => $value,
                'user_update' => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
                'tgl_update'  => date('Y-m-d H:i:s')
            ], [
                'id_company'  => $this->id_company,
                'id_karyawan' => $id_karyawan
            ]);
        } else {
            $id_lembur = $this->getNextId($this->table, 'id_lembur_m', $this->id_company, 4);
            $this->db->insert('payroll_lembur_m', [
                'id_lembur_m' => $id_lembur,
                'id_karyawan' => $id_karyawan,
                $column       => $id_lembur,
                'id_company'  => $this->id_company,
                'user_input'  => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            ]);
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            return __response_update(true);
        }
    }
}
