<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Db_model extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get($tbl_name, $select = '', $where = '', $order = '', $limit = '', $start = '0', $group = '', $join = '')
    {
        if (!empty($select))
            $this->db->select($select, false);
        if (!empty($where))
            $this->db->where($where);
        if (!empty($order))
            $this->db->order_by($order);
        if (!empty($limit))
            $this->db->limit($limit, $start);
        if (!empty($group))
            $this->db->group_by($group);
        if (!empty($join) && is_array($join)) {
            if (!empty($join['table']) && !empty($join['on'])) {
                $join = array($join);
            }

            foreach ($join as $item) {
                if (!empty($item['table']) && !empty($item['on'])) {
                    if (!empty($item['pos'])) {
                        $this->db->join($item['table'], $item['on'], $item['pos']);
                    } else {
                        $this->db->join($item['table'], $item['on']);
                    }
                }
            }
        }

        return $this->db->get($tbl_name);
    }

    function add($tbl_name, $data)
    {
        if (is_array($data)) {
            return $this->db->insert($tbl_name, $data);
        }

        return false;
    }

    public function update($tbl_name, $data, $where)
    {
        if (is_array($data)) {
            return $this->db->update($tbl_name, $data, $where);
        }

        return false;
    }

    public function delete($tbl_name, $where)
    {
        return $this->db->delete($tbl_name, $where);

        return false;
    }
    public function dd_level()
    {
        $result = $this->db->order_by('level ASC')->get('usergroup');
        $status[''] = 'Please Select';
        if ($result->num_rows() > 0) {
            foreach ($result->result() as $row) {
                $status[$row->id] = $row->level;
            }
        }
        return $status;
    }
    public function dd_jabatan()
    {
        $result = $this->db->order_by('nama ASC')->get_where('data_jabatan', array('id_company' => $this->session->userdata('id_company')));
        $status[''] = 'Please Select';
        if ($result->num_rows() > 0) {
            foreach ($result->result() as $row) {
                $status[$row->id_jabatan] = $row->nama;
            }
        }
        return $status;
    }

        public function GetJabatanByDivisiCompany($where)
    {
        $this->db->select('id_jabatan,nama');
        $this->db->from('data_jabatan');
        $this->db->where($where);
        return $this->db->get();
    }

    public function GetLevelUserByJabatanCompany($where)
    {
        $this->db->select('id,level');
        $this->db->from('data_jabatan');
        $this->db->join('usergroup', 'data_jabatan.id_level=usergroup.id');
        $this->db->where($where);
        return $this->db->get();
    }
}
