<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Data_komponen extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/data_komponen_kehadiran/Data_komponen_m', 'model');
    }

    public function index()
    {
        $data['judul']   = 'Data Komponen Kehadiran';
        $data['aktif']   = 'data_komponen_kehadiran';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['master']  = json_decode($this->model->master_komponen(), true);
        $data['content'] = $this->load->view('payroll/data_komponen_kehadiran/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data($id_karyawan, $id_cabang, $id_departemen)
    {
        $list                = $this->model->get_datatables($id_karyawan, $id_cabang, $id_departemen);
        $get_pend            = json_decode($this->model->tambah_pendapatan(), true);
        $get_master_komponen = json_decode($this->model->master_komponen(), true);
        $no                  = $_GET['start'];

        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";
            $row[] = $field->nama_cabang . "<br><b>" . $field->kode_cabang . "</b>";
            $row[] = $field->nama_departemen . "<br><b>" . $field->kode_departemen . "</b>";
            $row[] = $field->nama_jabatan . "<br><b>" . $field->kode_jabatan . "</b>";

            if ($field->nominal == 0) {
                $row[] = '-';
            } else {
                $row[] = number_format($field->nominal, 0, ',', '.');
            }
            $total_pendapatan = 0;
            if (count($get_pend[$field->id_karyawan]) > 0) {
                foreach ($get_pend[$field->id_karyawan] as $komponen) {
                    $nominalWithButton = 0;
                    $pendapatan        = 0;
                    // jika terdapat gapok
                    if ($field->nominal > 0) {
                        $pendapatan = $komponen['nominal_tunjangan'];
                        if ($komponen['flag_persentase_gapok'] == "1") {
                            if ($pendapatan > 0) {
                                $nominalWithButton = '
                                <div class = "nominal-with-button">
                                    <span>' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '</span>
                                    <button class = "btn-link border-0 text-danger" data-toggle = "modal" data-target = "#modal-nominal" data-item = "' . md5($field->id_karyawan . $komponen['id_item'] . $this->id_company) . '" data-komponen = "pendapatan" data-btn = "hapus" data-nominal = "' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '" data-nm_komponen = "' . $komponen['nm_tunjangan'] . '"><i class = "fa fa-trash (alias) "></i></button>
                                </div>';
                            } else {
                                $nominalWithButton = '
                                <div class = "nominal-with-button">
                                    <span>' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '</span>
                                    <button class = "btn-link border-0 text-primary" data-toggle = "modal" data-target = "#modal-nominal" data-item = "' . md5($field->id_karyawan . $komponen['id_item'] . $this->id_company) . '" data-komponen = "pendapatan" data-btn = "tambah" data-persen = "' . $komponen['gapok_persen'] . '" data-nominal = "' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '" data-nm_komponen = "' . $komponen['nm_tunjangan'] . '"><i class = "fa fa-plus (alias) "></i></button>
                                </div>';
                            }
                        } else {
                            $nominalWithButton = '
                            <div class = "nominal-with-button">
                                <span>' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '</span>
                                <button class = "btn-link border-0 text-warning" data-toggle = "modal" data-target = "#modal-nominal" data-item = "' . md5($field->id_karyawan . $komponen['id_item'] . $this->id_company) . '" data-komponen = "pendapatan" data-btn = "ubah" data-nominal = "' . number_format($komponen['nominal_tunjangan'], 0, ',', '.') . '" data-nm_komponen = "' . $komponen['nm_tunjangan'] . '"><i class = "fa fa-edit (alias) "></i></button>
                            </div>';
                        }
                    }
                    $row[]             = $nominalWithButton;
                    $total_pendapatan += $pendapatan;
                }
                $row[] = number_format($total_pendapatan, 0, ',', '.');
            } else {
                if (count($get_master_komponen['pendapatan']) > 0) {
                    for ($i = 0; $i < count($get_master_komponen['pendapatan']); $i++) {
                        $row[] = 0;
                    }
                }
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($id_karyawan, $id_cabang, $id_departemen),
            "recordsFiltered" => $this->model->count_filtered($id_karyawan, $id_cabang, $id_departemen),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form()
    {
        $this->load->view('payroll/data_komponen_kehadiran/form');
    }

    public function update()
    {
        $id_item = $this->input->post('item');
        $nominal = $this->input->post('nominal');

        // validasi id_item
        $cek_item = $this->db->where('md5(concat(id_karyawan,id_item,id_company))', $id_item)->get('payroll_tunj_kehadiran_m')->num_rows();
        if ($cek_item == 0) {
            return __response_update(false);
        }

        $data = array(
            'user_update'       => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            'tgl_update'        => date('Y-m-d H:i:s'),
            'nominal_tunjangan' => str_replace('.', '', $nominal)
        );

        $this->model->update($data, $id_item);
    }
}
