<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pengumuman extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Pengumuman_m');
        $this->load->library('Uploadfile');
    }

    public function index()
    {
        $data['judul']   = $this->lang->line('menu_pengumuman');
        $data['aktif']   = 'pengumuman';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengumuman/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data()
    {
        $list = $this->Pengumuman_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;

            $tgl_pengumuman = date_format(date_create($field->date_created), "Y-m-d");
            $jam_pengumuman = date_format(date_create($field->date_created), "H:i:s");

            $isi_berita = "<b class='font-size-large'>" . $field->judul . "</b><br>";
            $isi_berita .= $this->fungsi->tgl_indo($tgl_pengumuman) . " " . $jam_pengumuman . "<br><br>";
            if (strlen($field->content) >= 1000) {
                $isi_berita .= substr($field->content, 0, 1000) . "...... <br>";
                $isi_berita .= "<a href='" . route('informasi.pengumuman.detail') . "/" . md5($field->id_pengumuman) . "'>" . $this->lang->line('lihat_detail') . "</a>";
            } else {
                $isi_berita .= $field->content;
            }
            $row[] = $isi_berita;

            $row[] = $this->_target_pengumuman($field->target, $field->target_id, $field->id_cabang);

            if ($this->session->userdata('level_user') == '1') {
                $row[] = '<a href="' . route('informasi.pengumuman.detail') . '/' . md5($field->id_pengumuman) . '" class="text-primary" title="DETAIL">
                            <i class="btn_detail fa fa-info-circle (alias) "> </i></a>&nbsp;
                        <a href="' . route('informasi.pengumuman.form.edit') . '/' . md5($field->id_pengumuman) . '" class="text-warning" title="EDIT">
                            <i class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
                        <a href="#" class="text-danger" title="' . $this->lang->line('hapus') . '">
                            <i id="' . md5($field->id_pengumuman) . '" class="btn_delete fa fa-trash"></i>
                        </a>';
            } else {
                $row[] = '<a href="' . route('informasi.pengumuman.detail') . '/' . md5($field->id_pengumuman) . '" class="text-primary" title="DETAIL">
                            <i class="btn_detail fa fa-info-circle (alias) "> </i></a>&nbsp;';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Pengumuman_m->count_all(),
            "recordsFiltered" => $this->Pengumuman_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    private function _target_pengumuman($target_type = null, $target_id = null, $id_cabang = null)
    {
        if ($target_type == "1") { # Semua Karyawan
            $target = strtoupper($this->lang->line('semua'));
        } else if ($target_type == "2") { # Per Cabang
            $data_cabang = $this->db->query("SELECT master_cabang.kode,
                                                    master_cabang.nama
                                            FROM data_pengumuman
                                            JOIN master_cabang ON FIND_IN_SET(master_cabang.id_cabang,?)
                                            WHERE data_pengumuman.id_company = ?
                                            GROUP BY master_cabang.id_cabang
                                            ORDER BY master_cabang.kode ASC", [$target_id, $this->id_company])->result();
            $target = "";
            foreach ($data_cabang as $cabang) {
                $target .= '<span class="badge badge-secondary">' . $cabang->kode . ' - ' . $cabang->nama . '</span>';
            }
        } else if ($target_type == "3") { # Per Departemen
            $data_departemen = $this->db->query("SELECT master_departemen.kode, master_departemen.nama
                                                FROM data_pengumuman
                                                JOIN master_cabang ON master_cabang.id_cabang = data_pengumuman.id_cabang
                                                JOIN data_karyawan ON data_karyawan.id_cabang = master_cabang.id_cabang
                                                JOIN master_departemen ON data_karyawan.id_departemen = master_departemen.id_departemen
                                                WHERE data_pengumuman.id_cabang = ?
                                                AND FIND_IN_SET(master_departemen.id_departemen,?)
                                                AND data_pengumuman.id_company = ?
                                                GROUP BY master_departemen.id_departemen
                                                ORDER BY master_departemen.kode ASC", [$id_cabang, $target_id, $this->id_company])->result();
            $target = "";
            foreach ($data_departemen as $departemen) {
                $target .= '<span class="badge badge-warning" style="margin-top:3px">' . $departemen->kode . ' - ' . $departemen->nama . '</span> ';
            }
        } else { # Per Karyawan
            $data_karyawan = $this->db->query("SELECT data_karyawan.nik,
                                                        data_karyawan.nama_lengkap
                                            FROM data_pengumuman
                                            JOIN  data_karyawan ON FIND_IN_SET(data_karyawan.id_karyawan,?)
                                            WHERE data_pengumuman.id_company = ?
                                            GROUP BY data_karyawan.id_karyawan
                                            ORDER BY data_karyawan.nik ASC", [$target_id, $this->id_company])->result();
            $target = "";
            foreach ($data_karyawan as $karyawan) {
                $target .= '<span class="badge badge-primary" style="margin-top:3px">' . $karyawan->nik . ' - ' . $karyawan->nama_lengkap . '</span> ';
            }
        }

        return $target;
    }

    public function form($id = null)
    {
        $data['judul'] = $this->lang->line('title_form_pengumuman');
        $data['aktif'] = 'pengumuman';

        if ($id != null) {
            $data['form'] = 'edit';
            $data['data'] = $this->Pengumuman_m->getDataById($id);

            $target = $data['data']->target;
            $target_id = $data['data']->target_id;
            $id_cabang = $data['data']->id_cabang;

            if ($target == '2') {
                $data['cabang'] = $this->db->query("SELECT id_cabang, kode, nama
                                                    FROM master_cabang
                                                    WHERE FIND_IN_SET(id_cabang,?)", [$target_id])->result();
            } else if ($target == '3') {
                $data['cabang'] = $this->db->query("SELECT id_cabang, kode, nama
                                                    FROM master_cabang
                                                    WHERE id_cabang = ?", [$id_cabang])->result();
                $data['departemen'] = $this->db->query("SELECT id_departemen, kode, nama
                                                        FROM master_departemen
                                                        WHERE FIND_IN_SET(id_departemen,?)", [$target_id])->result();
            } else if ($target == '4') {
                $data['karyawan'] = $this->db->query("SELECT id_karyawan, nik, nama_lengkap
                                                        FROM data_karyawan
                                                        WHERE FIND_IN_SET(id_karyawan,?)", [$target_id])->result();
            }
        } else {
            $data['form'] = 'tambah';
        }
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengumuman/form', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function detail($id = null)
    {
        $data['judul'] = $this->lang->line('title_detail_pengumuman');
        $data['aktif'] = 'pengumuman';
        $data['menu']  = $this->load->view('main_menu', $data, true);

        $pengumuman               = $this->Pengumuman_m->getDataById($id);
        $data["id_pengumuman"]    = $pengumuman->id_pengumuman;
        $data["judul_pengumuman"] = $pengumuman->judul;
        $data["tgl_pembuatan"]    = date_format(date_create($pengumuman->date_created), 'd-m-Y');
        $data["target"]           = $this->_target_pengumuman($pengumuman->target, $pengumuman->target_id, $pengumuman->id_cabang);
        $data["keterangan"]       = $pengumuman->content;
        $data['content']          = $this->load->view('pengumuman/detail', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function save()
    {
        $id        = $this->input->post('id_pengumuman');
        $target    = $this->input->post('target');
        $id_cabang = $target_id = "";
        $judul     = $this->input->post('judul');
        $content   = urldecode($this->input->post('content'));

        if ($target == '2') {
            $target_id = $this->input->post('id_cabang');
        } else if ($target == '3') {
            $id_cabang = $this->input->post('id_cabang');
            $target_id = $this->input->post('id_departemen');
        } else if ($target == '4') {
            $target_id = $this->input->post('id_karyawan');
        }

        $data = array(
            'judul'      => $judul,
            'content'    => $content,
            'target'     => $target,
            'target_id'  => $target_id,
            'id_cabang'  => $id_cabang,
            'creator'    => $this->id_karyawan,
            'posting'    => "1",
            'id_company' => $this->id_company
        );

        $this->Pengumuman_m->save($data, $id);
    }

    public function delete()
    {
        $id = $this->input->post("id_pengumuman");
        $this->Pengumuman_m->delete($id);
    }
}
