<script type="text/javascript">
    $(document).ready(function () {

        $('.filter #id_cabang').select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });

        $(document).on('click', '#form_input input[name="libur"]', function () {
            var libur = $(this).val();
            if (libur == "1") {
                $('#form_input #div_jam_masuk').hide();
                $('#form_input #div_jam_pulang').hide();
                $('#form_input #div_batas_jam_pulang').hide();
            } else {
                $('#form_input #div_jam_masuk').show();
                $('#form_input #div_jam_pulang').show();
                $('#form_input #div_batas_jam_pulang').show();
            }
        });


        $(document).on('click', '.btn_tambah', function () {
            $('#tampil_form').load("<?= route('master.shift.form.tambah') ?>", function () {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_edit', function () {
            $('#tampil_form').load("<?= route('master.shift.form.edit') ?>" + "/" + $(this).attr('id') + "/ubah", function () {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_perbarui') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_delete', function () {
            $('#tampil_form').load("<?= route('master.shift.form.hapus') ?>" + "/" + $(this).attr('id') + "/hapus", function () {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                $("#form_input :input").prop("disabled", true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click', '#btn_new_input', function () {
            $("#form_input :input").prop("disabled", false);
            $("#form_input :input[type='text']").val('');

            $("#form_input #id_cabang").select2("val", "0");
            $('#form_input input[name="libur"][value="0"]').prop('checked', true);

            $('#form_input #div_jam_masuk').show();
            $('#form_input #div_jam_pulang').show();
            $('#form_input #div_batas_jam_pulang').show();

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click", ".btn_save", function (e) {
            e.preventDefault();
            $('#message').html("");

            var loading = Ladda.create(this);

            var level_user = "<?= $this->level_user ?>";
            var multi_cabang = "<?= $this->multi_cabang ?>";

            if (level_user == "1" || multi_cabang == 1) {
                var id_cabang = $("#form_input #id_cabang").val();
                if (id_cabang == "0") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#id_cabang').focus();
                    return false;
                }
            } else {
                var id_cabang = "<?= $this->id_cabang ?>";
            }


            if ($("#kd_shift").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_kode_shift') ?></font>");
                $("#kd_shift").focus();
                return false;
            } else if ($("#nm_shift").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_shift') ?></font>");
                $('#nm_shift').focus();
                return false;
            }

            if ($("#form_input input[name='libur']:checked").val() == "0") {
                if ($("#jam_masuk").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jam_masuk_shift') ?></font>");
                    $('#jam_masuk').focus();
                    return false;
                } else if ($("#jam_pulang").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jam_pulang_shift') ?></font>");
                    $('#jam_pulang').focus();
                    return false;
                } else if ($("#minimal_jam_masuk").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_min_jam_masuk') ?></font>");
                    $('#minimal_jam_masuk').focus();
                    return false;
                } else if ($("#maksimal_jam_pulang").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_max_jam_pulang') ?></font>");
                    $('#maksimal_jam_pulang').focus();
                    return false;
                }
            }

            loading.start();

            <?php
            if ($this->paket_arr['flexible_jam_kerja'] == true) {
                ?>
                let libur = '0';
                <?php
            } else {
                ?>
                let libur = $("input[name='libur']:checked").val();
                <?php
            }
            ?>

            var param = 'id_shift=' + $("#id_shift").val() +
                '&kd_shift=' + $("#kd_shift").val() +
                '&nm_shift=' + $("#nm_shift").val() +
                '&libur=' + libur +
                '&jam_masuk=' + $("#jam_masuk").val() +
                '&jam_pulang=' + $("#jam_pulang").val() +
                '&minimal_jam_masuk=' + $("#minimal_jam_masuk").val() +
                '&maksimal_jam_pulang=' + $("#maksimal_jam_pulang").val() +
                '&id_cabang=' + id_cabang;

            $.ajax({
                type: 'POST',
                url: "<?= route('master.shift.save') ?>",
                data: param,
                dataType: 'JSON',
                success: function (result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input :input").prop("disabled", true);
                            $("#form_input #id_cabang").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function () {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click', '.btn_hapus', function () {
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?= route('master.shift.delete') ?>",
                data: 'id_shift=' + $("#id_shift").val(),
                dataType: 'JSON',
                success: function (result) {
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("#009900", "#ffffff"));

                },
                error: function () {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        // PROSES HAPUS MASTER SHIFT YANG MASIH DIGUNAKAN
        $(document).on('click', '.btn_hapus_ya', function () {

            // alert('hapus shift aktif');
            // return false
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?= route('master.shift.hapus.jadwal') ?>",
                data: 'id_shift=' + $("#id_shift").val(),
                dataType: 'JSON',
                success: function (result) {
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("#009900", "#ffffff"));

                },
                error: function () {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_master_data') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
            if (in_array($this->level_user, array("1", "5")) || in_array($this->session->userdata('level_khusus'), array("1"))) {
                ?>
                <div class="float-md-right">
                    <button type="button" class="btn_tambah btn btn-biru">
                        <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
                    </button>
                </div>
                <?php
            }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row filter">
                <?php
                if (in_array($this->level_user, array("1", "4")) || in_array($this->khusus, array("1")) || $this->multi_cabang == true) {
                    ?>
                    <div class="col-md-4">
                        <select id="id_cabang" class="form-control select2"></select>
                    </div>
                    <div class="col-md-1">
                        <button type="button" id="btn_filter" class="btn btn-primary ladda-button" data-style="expand-left">FILTER</button>
                    </div>
                    <?php
                }
                ?>
            </div>
            <div class="row mt-2">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table id="list_data" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th class="text-center">NO</th>
                                    <?php
                                    if (in_array($this->level_user, ["1", "4"]) || $this->multi_cabang == true) {
                                        ?>
                                        <th class="text-left text-uppercase"><?= $this->lang->line('cabang') ?></th>
                                        <?php
                                    }
                                    ?>
                                    <th class="text-center"><?= $this->lang->line('kode_shift') ?></th>
                                    <th class="text-left text-uppercase"><?= $this->lang->line('nama_shift') ?></th>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('libur') ?></th>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('min_jam_masuk_shift') ?></th>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('jam_masuk_shift') ?></th>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('jam_pulang_shift') ?></th>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('max_jam_pulang_shift') ?></th>
                                    <?php
                                    if (in_array($this->level_user, array("1", "5")) || in_array($this->session->userdata('level_khusus'), array("1"))) {
                                        ?>
                                        <th class="text-center"><?= $this->lang->line('aksi') ?></th>
                                        <?php
                                    }
                                    ?>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else: ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('master.shift.listdata') ?>",
                "type": "GET",
                "data": {
                    id_cabang: function () {
                        return $(".filter #id_cabang").val()
                    },
                },
                "complete": function (data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                "aTargets": [0],
                "bSortable": false
            },
                <?php
                if (in_array($this->level_user, array("1", "5")) || in_array($this->session->userdata('level_khusus'), array("1"))) {
                    ?> {
                    "aTargets": [-1],
                    "bSortable": false
                }

                    <?php
                }
                ?>
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                var level_user = '<?= $this->level_user ?>';
                var multi_cabang = '<?= $this->multi_cabang ?>';

                if (level_user == "1" || level_user == "4" || multi_cabang == 1) {
                    $('td:eq(2)', nRow).css({
                        'text-align': 'center',
                        'width': '100px'
                    });
                    $('td:eq(9)', nRow).css({
                        'text-align': 'center',
                        'width': '50px'
                    });
                    var kolom_start = 4;
                    var kolom_end = 8;
                } else {
                    $('td:eq(1)', nRow).css({
                        'text-align': 'center',
                        'width': '100px'
                    });
                    $('td:eq(8)', nRow).css({
                        'text-align': 'center',
                        'width': '50px'
                    });
                    var kolom_start = 3;
                    var kolom_end = 7;
                }

                for (i = kolom_start; i <= kolom_end; i++) {
                    $('td:eq(' + i + ')', nRow).css({
                        'text-align': 'center',
                        'width': '80px'
                    });
                }

            }

        });

        $(document).on('click', '.filter #btn_filter', function () {
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function () {
                loading.stop();
            });
        });
    });
</script>