<div class="row">
    <div class="col-md-12 text-right">
        <input class="verifikasi_semua align-middle" type="checkbox" name="checkbox_all"> Cek Semua
        <button class="btn_verified_pkwt_all btn btn-light text-white ladda-button ml-2" disabled>VERIFIKASI SEMUA</button>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-12 table-responsive">
        <table id="list_data_verifikasi" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th rowspan="2" class="text-center">NO</th>
                    <th rowspan="2" class="text-center">NAMA KARYAWAN</th>
                    <th rowspan="2" class="text-center">JABATAN</th>
                    <th rowspan="2" class="text-center">CABANG<br>DEPARTEMEN</th>
                    <th colspan="2" class="text-center">APPROVAL</th>
                    <th rowspan="2" class="text-center">DETAIL</th>
                    <th rowspan="2" class="text-center">CEK</th>
                </tr>
                <tr>
                    <th>KARYAWAN</th>
                    <th>DIREKSI</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(function() {
        var id_cabang       = ($("#cabang").val() == null)?"all":$("#cabang").val();
        var id_departemen   = ($("#departemen").val() == null)?"all":$("#departemen").val();
        var id_karyawan     = ($("#karyawan").val() == null)?"all":$("#karyawan").val();
        var tanggal_mulai   = ($("#tanggal_mulai").val() == null)?"00-00-0000":$("#tanggal_mulai").val();
        var tanggal_selesai = ($("#tanggal_selesai").val() == null)?"00-00-0000":$("#tanggal_selesai").val();

        list_data_verifikasi = $('#list_data_verifikasi').DataTable({
                    'searching'   : false,
                    'searchDelay' : 250,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : false,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route('pkwt.baru.kayawan.tabs.content.verifikasi') ?>"+"/"+tanggal_mulai+"/"+tanggal_selesai+"/"+id_cabang+"/"+id_departemen+"/"+id_karyawan,
                                        "type": "GET",
                                        "data"  : function (d) {
                                            delete d.columns;
                                        },
                                        "complete" : function(data){
                                                reconfigure(data);
                                        }
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(4)', nRow).css({'text-align':'center'});
                            $('td:eq(5)', nRow).css({'text-align':'center'});
                            $('td:eq(6)', nRow).css({'text-align':'center'});
                            $('td:eq(7)', nRow).css({'text-align':'center'});
                    }
        });
    });
</script>