<script type="text/javascript">
    // Form Tambah
    function tambah(e){
        $('#tampil_form').load("<?= route("sales_activity.pengaturan.approval.atasan.form.tambah") ?>", function() {
            $('#modal_form').modal('show');
            $(".title").text("Form Tambah Data");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
            $("#btn_new_input").hide();
        });
    }

    // Form Edit
    function edit(e){
        $('#tampil_form').load("<?= route('sales_activity.pengaturan.approval.atasan.form.edit') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
            $(".btn_save").addClass("btn_save btn btn-warning");
            $(".btn_save").append('<i class="fa fa-update"></i> ');
            $(".btn_save").append("<?= $this->lang->line('button_form_perbarui') ?>");
            $("#btn_new_input").hide();
        });
    }

    // Form Delete
    function form_delete(e){
        $('#tampil_form').load("<?= route('sales_activity.pengaturan.approval.atasan.form.hapus') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
            $("#form_input select").prop("disabled", true);
            $("#form_input input[type=radio]").prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','action_hapus(this)');
        });
    }

    // Form New Input
    function new_input(e){
        $("#form_input :input").prop("disabled", false);
        $("#form_input #id_karyawan").select2("val", "0");    
        $("#form_input #id_atasan").select2("val", "0");
        $("#form_input #id_group_m").select2("val", "0");
        $("#form_input input[type=radio][value='0']").prop('checked', true);
        $("#form_input #div_dropdown_atasan").hide();
        $('.btn_save').show();
        $('#btn_new_input').hide();
        $('#message').html('');
    }

    // Action Save
    function save(e){
        $('#message').html("");
        var id_karyawan = $("#form_input #id_karyawan").val();
        var approval    = $("#form_input input[name='approval']:checked").val()

        if (id_karyawan == null || id_karyawan == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_karyawan') ?></font>");
            $("#form_input #id_karyawan").focus();
            return false;
        }

        if (approval == '') {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_approval') ?></font>");
            $("#form_input #approval").focus();
            return false;
        }

        if(approval == "1"){
            var id_atasan   = $("#form_input #id_atasan").val();
            if (id_atasan == null || id_atasan == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_atasan') ?></font>");
                $("#form_input #id_atasan").focus();
                return false;
            }
        }else{
            var id_atasan = "";
        }

        var param             = {};
            param.id          = $("#form_input #id").val();
            param.id_karyawan = id_karyawan;
            param.approval    = approval;
            param.id_atasan   = id_atasan;
            
            <?php if($this->fungsi->cek_adm_satu_grup() == true) : ?>
                param.id_group_m = "<?= $this->sales_admin_group ?>"
            <?php else: ?>
                param.id_group_m = $("#form_input #id_group_m").val();
            <?php endif; ?>

        var loading = Ladda.create(e);
        loading.start();

        $.ajax({
            type: 'POST',
            url: "<?= route('sales_activity.pengaturan.approval.atasan.save') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'save') {
                        $("#form_input :input").prop("disabled", true);
                        $('.btn_save').hide();

                        var form = true;
                        cek_maximal_data_sales(form);
                    }
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }

    // Action Hapus
    function action_hapus(e){
        var loading = Ladda.create(e);
        loading.start();

        var param = {};
        param.id = $("#id").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('sales_activity.pengaturan.approval.atasan.delete') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
                cek_maximal_data_sales();
            },
            error: function() {
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }

    // Function Cek Maksimal Sales
    function cek_maximal_data_sales(form = false){
        $.ajax({
            type: 'GET',
            url: '<?= route("sales_activity.pengaturan.approval.atasan.cek.maximal.sales") ?>',
            dataType: 'json',
            success: function(result){
                $("#data_sales_jumlah_sales_aktiv").html(result.active_sales + ' Orang');
                $("#data_sales_maximal_sales").html(result.max_sales + ' Orang');
                
                <?php 
                    if($this->is_sales_admin == true && !in_array($this->sales_admin_group, ["all", ""])){ 
                ?>
                        $("#data_sales_jumlah_sales_group_lain").html(result.sales_other_group + ' Orang');
                <?php 
                    }
                ?>
                
                if(result.tambah_sales == false){
                    $("#div_tambah").html('');
                }else{
                    if(form == true){
                        $('#btn_new_input').show();
                    }

                    var html = '<button type="button" class="btn btn_tambah btn-success pull-right" onclick="tambah(this)">' +
                            '<i class="fa fa-plus"></i> ' + 
                            '<?= $this->lang->line("button_tambah_data") ?>' +
                            '</button>';

                    $("#div_tambah").html(html);
                }
            }
        })
    }
</script>