<style media="screen">
.modal-header {
background-color: #3d77d4;
border-top-left-radius: 0rem;
border-top-right-radius: 0rem;
color: #fff;
}
</style>
<div id="form_save" class="row">
  <input type="hidden" id="id_cabang" value="">
  <input type="hidden" id="id_lokasi_kantor" value="">
  <input type="hidden" id="kode_temp" value="">
  <input type="hidden" id="cabang_temp" value="">
  <div class="form-group m-0 col-md-3 col-12 mb-1">
    <input type="text" class="form-control" placeholder="Kode Cabang" id="kode">
    <small class="text-muted">&nbsp;</small>
  </div>
  <div class="form-group m-0 col-md-3 col-12 mb-1">
    <input type="text" class="form-control" placeholder="Nama Cabang" id="cabang">
    <small class="text-muted">&nbsp;</small>
  </div>
  <div class="form-group m-0 col-md-3 col-12 mb-1">
    <input type="text" class="form-control" placeholder="Lokasi Longitute, Latitude" id="latlong" onclick="latlong()">
  </div>
  <div class="form-group m-0 col-md-3 col-12 mb-1">
    <input type="text" class="form-control" placeholder="Radius batas lokasi presensi (meter)" id="radius" onkeyup="this.value = this.value.replace(/[^0-9.]/g, '')">
    <small class="text-muted"><i>*Minimal 20 meter</i></small>
  </div>
  <div id="btn_tambah_baru" class="form-group m-0 col-md-3 col-12 mb-1 mt-1" style="display: none;">
    <button type="button" class="btn btn-primary mr-1 col-md-6 col-6" onclick="tambah_baru()"> Tambah Baru </button>
  </div>
  <div id="btn_save" class="form-group m-0 col-md-3 col-12 mb-1 mt-1">
    <button type="button" id="tambah" class="btn btn-biru mr-1 ladda-button col-md-4 col-6" data-style="expand-left" onclick="save()"> Simpan </button>
    <button type="button" class="btn btn-outline-biru col-md-4 col-5" onclick="cancel()"> Batal </button>
  </div>
  <div id="btn_update" class="form-group m-0 col-md-3 col-12 mb-1 mt-1" style="display: none;">
    <button type="button" id="update" class="btn btn-warning mr-1 ladda-button col-md-4 col-6" data-style="expand-left" onclick="update()"> Update </button>
    <button type="button" class="btn btn-outline-biru col-md-4 col-5" onclick="cancel_update()"> Batal </button>
  </div>
  <div id="btn_hapus" class="form-group m-0 col-md-3 col-12 mb-1 mt-1" style="display: none;">
    <button type="button" id="hapus" class="btn btn-danger mr-1 ladda-button col-md-4 col-6" data-style="expand-left" onclick="delete_data()"> Hapus </button>
    <button type="button" class="btn btn-outline-biru col-md-4 col-5" onclick="cancel_hapus()"> Batal </button>
  </div>
  <small class="text-muted">&nbsp;</small>
</div>
<div class="row">
  <div class="col-md-12">
    <div id="message" style="margin-top: -80px"></div>
  </div>
</div>
<div id="modal_latlong" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Lokasi Longitude Latitude</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="form-group col-md-10 col-12">
            <input type="text" id="cari" class="form-control col-12" value="">
          </div>
          <div class="col-md-2 col-12 mb-1">
            <button type="button" name="button" class="btn btn-success col-md-8 col-12" onclick="cari()">Cari</button>
          </div>
        </div>
        <div id="map_canvas" style="width:100%; height:350px;"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Pilih Lokasi</button>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=<?= $this->config->item('api_map_key') ?>&sensor=false"></script>
<script type="text/javascript">
var geocoder;

function latlong() {
  $('#modal_latlong').modal('show');
  var latlong = $('#latlong').val();
  if(latlong == '') {
    initialize(-0.4183772,117.4237542, 4.5);
  } else {
    temp = latlong.split(',');
    lat = temp[0];
    long = temp[1];
    initialize(lat,long, 15);
  }
}

$('#cari').on('keypress',function(e) {
    if(e.which == 13) {
        cari();
    }
});

$('input').on( 'keyup', function( e ) {
    if( e.which == 9 ) {
      var id = $(this).attr('id');
      if(id == 'latlong') {
        latlong();
      }
    }
} );

function cari() {
  var cari = $('#cari').val();
  geocoder.geocode({'address': cari}, function(result) {
    lat = result[0].geometry.location.lat();
    long = result[0].geometry.location.lng();
    $('#latlong').val(lat+','+long);
    initialize(lat, long, 15);
  });
}

function initialize(lat, long, zoom) {
    geocoder = new google.maps.Geocoder();
    var varcenter = new google.maps.LatLng(lat,long);
    var varZoom = zoom;
    var mapOptions = {
        zoom: varZoom,
        center: varcenter,
        streetViewControl: false,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    }
    map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);

    var marker = new google.maps.Marker({
        position: varcenter,
        map: map,
        draggable:true,
        title:"Drag me!"
    });

    marker.addListener('dragend', changeLatLong);
}

function changeLatLong(event) {
  $('#latlong').val(event.latLng.lat()+','+event.latLng.lng());
}

function save() {
  $('#message').html("");
  var loading = Ladda.create(document.querySelector('#tambah'));
  var kode = $('#kode').val();
  var cabang = $('#cabang').val();
  var radius = $('#radius').val();
  var latlong = $('#latlong').val();

  if(kode == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Kode cabang belum diisi</font>");
    $("#kode").focus();
    return false;
  } else if(cabang == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama cabang belum diisi</font>");
    $("#cabang").focus();
    return false;
  } else if(latlong == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Lokasi belum diisi</font>");
    $("#latlong").focus();
    return false;
  } else if(radius == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Radius belum diisi</font>");
    $("#radius").focus();
    return false;
  } else if(radius < 20) {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Radius minimal 20 meter</font>");
    $("#radius").focus();
    return false;
  }

  loading.start();

  var param = {};
  param.kode    = kode;
  param.cabang = cabang;
  param.radius = radius;
  param.latlong = latlong;

  $.ajax({
      type: 'POST',
      url: "<?= route('quick-setup.cabang.save') ?>",
      data: param,
      dataType:'JSON',
      success: function(result) {
          if(result.success == true){
              if(result.type == 'save'){
                  $("#form_save input").prop("disabled", true);
                  $('#btn_save').hide();
                  $('#btn_tambah_baru').show();
              }

          }
          loading.stop();
          $('#message').show();
          $('#message').html(result.message);
      },
      error:function(){
          loading.stop();
          $('#message').show();
          $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
      }
  });
}

function update() {
  $('#message').html("");
  var loading           = Ladda.create(document.querySelector('#update'));
  var kode              = $('#kode').val();
  var cabang            = $('#cabang').val();
  var radius            = $('#radius').val();
  var latlong           = $('#latlong').val();
  var id_cabang         = $('#id_cabang').val();
  var id_lokasi_kantor  = $('#id_lokasi_kantor').val();
  var kode_temp         = $('#kode_temp').val();
  var cabang_temp       = $('#cabang_temp').val();

  if(kode == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Kode cabang belum diisi</font>");
    $("#kode").focus();
    return false;
  } else if(cabang == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum diisi</font>");
    $("#cabang").focus();
    return false;
  } else if(radius == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Radius belum diisi</font>");
    $("#radius").focus();
    return false;
  } else if(latlong == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Lokasi belum diisi</font>");
    $("#radius").focus();
    return false;
  }

  loading.start();

  var param               = {};
  param.kode              = kode;
  param.cabang            = cabang;
  param.radius            = radius;
  param.latlong           = latlong;
  param.id_cabang         = id_cabang;
  param.id_lokasi_kantor  = id_lokasi_kantor;
  param.kode_temp         = kode_temp;
  param.cabang_temp       = cabang_temp;

  $.ajax({
      type: 'POST',
      url: "<?= route('quick-setup.cabang.update') ?>",
      data: param,
      dataType:'JSON',
      success: function(result) {
          if(result.success == true){
              if(result.type == 'update'){
                  $("#form_save input").val('');
                  $('#btn_update').hide();
                  $('#btn_save').show();
                  $('#cari').val("");
              }

          }
          loading.stop();
          $('#message').show();
          $('#message').html(result.message);
      },
      error:function(){
          loading.stop();
          $('#message').show();
          $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
      }
  });
}

function delete_data() {
  $('#message').html("");
  var loading           = Ladda.create(document.querySelector('#hapus'));
  var id_cabang         = $('#id_cabang').val();
  var id_lokasi_kantor  = $('#id_lokasi_kantor').val();

  loading.start();

  var param               = {};
  param.id_cabang         = id_cabang;
  param.id_lokasi_kantor  = id_lokasi_kantor;

  $.ajax({
      type: 'POST',
      url: "<?= route('quick-setup.cabang.delete') ?>",
      data: param,
      dataType:'JSON',
      success: function(result) {
          if(result.success == true){
            $('#form_save input').prop('disabled', false);
            $('#btn_hapus').hide();
            $('#btn_save').show();
            $('#cari').val("");
            cancel();
          }
          loading.stop();
          $('#message').show();
          $('#message').html(result.message);
      },
      error:function(){
          loading.stop();
          $('#message').show();
          $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
      }
  });
}

function edit(id_cabang, id_lokasi_kantor) {
  detail(id_cabang, id_lokasi_kantor);
$('#form_save input').prop('disabled', false);
  $('#btn_save, #btn_tambah_baru, #btn_hapus').hide();
  $('#btn_update').show();
  $('#form_save').focus();
}

function hapus(id_cabang, id_lokasi_kantor) {
  detail(id_cabang, id_lokasi_kantor);
  $('#form_save').focus();
  $('#form_save input').prop('disabled', true);
  $('#btn_save, #btn_update, #btn_tambah_baru').hide();
  $('#btn_hapus').show();
}

function detail(id_cabang, id_lokasi_kantor) {
  $('#message').html("");
  $('#id_cabang').val(id_cabang);
  $('#id_lokasi_kantor').val(id_lokasi_kantor);

  $.get('<?= route("quick-setup.cabang.detail") ?>/'+id_cabang+'/'+id_lokasi_kantor, function(result) {
    $('#kode').val(result.kode);
    $('#kode_temp').val(result.kode);
    $('#cabang').val(result.nama);
    $('#cabang_temp').val(result.nama);
    $('#radius').val(result.jarak);
    $('#latlong').val(result.latlong);
    $('#cari').val(result.nama_kantor);
  }, 'json');
}

function tambah_baru() {
  $('#cari').val("");
  $("#form_save input").prop("disabled", false);
  cancel();
  $('#btn_tambah_baru').hide();
  $('#btn_save').show();
}

function cancel_update() {
  cancel();
  $('#btn_update').hide();
  $('#btn_save').show();
}

function cancel_hapus() {
  cancel();
  $('#form_save input').prop('disabled', false);
  $('#btn_hapus').hide();
  $('#btn_save').show();
}

function cancel() {
  $('#form_save input').val('');
}
</script>
