<script type="text/javascript">
    $(function() {
        load_cuti_p();

        $(".numberbox").keydown(function(e) {
            // Allow: backspace, delete, tab, escape, enter and
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                // let it happen, don't do anything
                return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
                $("#jumlah_barang").focus();
                return false();
            }
        });

        $(document).on('click', '.btn_edit', function() {
            var form_name = "#" + $(this).attr("form-data");

            $(form_name + " input:radio").attr('disabled', false);
            $(form_name + " #label").removeClass('disabled');
            $(form_name + " .btn_batal").show();
            $(form_name + " .btn_save").show();
            $(form_name + " .btn_edit").hide();
            $(form_name + " #message").html("");
        });

        $(document).on('click', '.btn_batal', function() {
            var form_name = "#" + $(this).attr("form-data");
            value = $(form_name + " #value_lama").val();
            if (form_name == "#form_locklokasi") {
                if (value == "0") {
                    $('input[name="lock_lokasi"][value="0"]').prop('checked', true);
                } else {
                    $('input[name="lock_lokasi"][value="1"]').prop('checked', true);
                }
            } else if (form_name == "#form_lockdevice") {
                if (value == "0") {
                    $('input[name="lock_device"][value="0"]').prop('checked', true);
                } else {
                    $('input[name="lock_device"][value="1"]').prop('checked', true);
                }
            } else {
                if (value == "0") {
                    $('input[name="lock_facerecognition"][value="0"]').prop('checked', true);
                } else {
                    $('input[name="lock_facerecognition"][value="1"]').prop('checked', true);
                }
            }

            $(form_name + " #message").html("");
            $(form_name + " input:radio").attr('disabled', true);
            $(form_name + " #label").addClass('disabled');
            $(form_name + " .btn_batal").hide();
            $(form_name + " .btn_save").hide();
            $(form_name + " .btn_edit").show();
        });

        $(document).on("click", ".btn_save", function(e) {
            e.preventDefault();

            var form_name = "#" + $(this).attr("form-data");
            var status = $(form_name + " input[type='radio']:checked").val();
            $(form_name + " #message").html("");

            var loading = Ladda.create(this);
            loading.start();

            var params = "jenis_form=" + form_name +
                "&status=" + status;

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.umum.save') ?>",
                data: params,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        $(form_name + " input:radio").attr('disabled', true);
                        $(form_name + " #label").addClass('disabled');
                        $(form_name + " .btn_batal").hide();
                        $(form_name + " .btn_save").hide();
                        $(form_name + " .btn_edit").show();
                        $(form_name + " #value_lama").val(status);
                    }

                    loading.stop();

                    $(form_name + " #message").show();
                    $(form_name + " #message").html(result.message);

                    setTimeout(function() {
                        $(form_name + " #message").html("");
                    }, 2000);
                },
                error: function() {
                    loading.stop();
                    $(form_name + " #message").show();
                    $(form_name + " #message").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line("error"); ?></strong></font>');
                }
            });
        });

        // CUTI
        $(document).on("click", ".btn_save_cuti", function(e) {
            e.preventDefault();
            const loading = Ladda.create(this);
            let forData = $(this).attr("for-data");
            let msg = $("#form_pengaturan_cuti #message");
            msg.text("");

            if (!$("input[name=reset_cuti]:checked").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("error_pilihan_belum_dipilih"); ?></font>");
                return false;
            }
            if (!$("#periode_cuti").val()) {
                if ($("input[name=reset_cuti]:checked").val() == 'bulan') {
                    msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("error_bulan_belum_dipilih"); ?></font>");
                    $("#periode_cuti").focus();
                    return false;
                }
            }
            if (!$("#reset_saldo").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("error_jumlah_reset_diisi"); ?></font>");
                $("#reset_saldo").focus();
                return false;
            }
            if (!$("input[name=jenis_karyawan]:checked").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("error_status_mendapatkan_cuti"); ?></font>");
                return false;
            }
            if (!$("#join_date_bulan").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("pengaturan_cuti_pertanyaan_4"); ?></font>");
                $("#join_date_bulan").focus();
                return false;
            }
            if (!$("#carry_forward_maks_saldo").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("pengaturan_cuti_pertanyaan_5"); ?></font>");
                $("#carry_forward_maks_saldo").focus();
                return false;
            }
            if (!$("#carry_forward_maks_bulan").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("pengaturan_cuti_pertanyaan_6"); ?></font>");
                $("#carry_forward_maks_bulan").focus();
                return false;
            }

            loading.start();

            var params = {};
            params.cuti_p = $("#cuti_p").val();
            params.for_data = forData;
            params.reset_cuti = $("input[name=reset_cuti]:checked").val();
            params.periode_cuti = $("#periode_cuti").val();
            params.reset_saldo = $("#reset_saldo").val();
            params.jenis_karyawan_tetap = ($("input[name=jenis_karyawan]:checked")[0]) ? $("input[name=jenis_karyawan]:checked")[0].value : '';
            params.jenis_karyawan_kontrak = ($("input[name=jenis_karyawan]:checked")[1]) ? $("input[name=jenis_karyawan]:checked")[1].value : '';
            params.join_date_bulan = $("#join_date_bulan").val();
            params.carry_forward_maks_saldo = $("#carry_forward_maks_saldo").val();
            params.carry_forward_maks_bulan = $("#carry_forward_maks_bulan").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.umum.save.cuti') ?>",
                data: params,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        load_cuti_p();
                    }
                    loading.stop();
                    msg.show();
                    msg.html(result.message);
                },
                error: function() {
                    loading.stop();
                    msg.show();
                    msg.html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line("error"); ?></strong></font>');
                }
            });
        });

        $(document).on("click", ".btn_edit_cuti", function() {
            // show & hide button
            $(this).hide();
            $(".btn_batal_cuti").show();
            $(".btn_save_cuti").show();
            // unset disable input
            $("#content-form input, #content-form select").prop("disabled", false);
        });

        $(document).on("click", ".btn_batal_cuti", function() {
            // show & hide button
            $(".btn_edit_cuti").show();
            $(this).hide();
            $(".btn_save_cuti").hide();
            // set disable input
            $("#content-form input, #content-form select").prop("disabled", true);
            // set default data
            load_cuti_p();
        });
        
        // START NOTIF ABSENSI
        $(document).on("click", ".btn_edit_notif_absensi", function() {
            $(this).hide();
            $(".btn_batal_notif_absensi").show();
            $(".btn_save_notif_absensi").show();
            $("#form_p_notif_absensi input, #form_p_notif_absensi select").prop("disabled", false);
        });

        $(document).on("click", ".btn_batal_notif_absensi", function() {
            $(this).hide();
            $(".btn_edit_notif_absensi").show();
            $(".btn_save_notif_absensi").hide();
            $('#form_p_notif_absensi #div_body_notif_absensi').load(window.location.href + ' #form_p_notif_absensi #div_body_notif_absensi');
        });

        $(document).on("change", "input[name=absensi_masuk_sebelum_flag]", function() {
            var absensi_masuk_sebelum_flag = $(this).val();
            if (absensi_masuk_sebelum_flag == "1") {
                $("#div_absensi_masuk_sebelum_menit").slideDown(250);
            }else{
                $("#div_absensi_masuk_sebelum_menit").slideUp(250);
            }
        });

        $(document).on("change", "input[name=absensi_masuk_setelah_flag]", function() {
            var absensi_masuk_setelah_flag = $(this).val();
            if (absensi_masuk_setelah_flag == "1") {
                $("#div_absensi_masuk_setelah_menit").slideDown(250);
            }else{
                $("#div_absensi_masuk_setelah_menit").slideUp(250);
            }
        });

        $(document).on("change", "input[name=absensi_pulang_setelah_flag]", function() {
            var absensi_pulang_setelah_flag = $(this).val();
            if (absensi_pulang_setelah_flag == "1") {
                $("#div_absensi_pulang_setelah_menit").slideDown(250);
            }else{
                $("#div_absensi_pulang_setelah_menit").slideUp(250);
            }
        });
        
        $(document).on("click", ".btn_save_notif_absensi", function(e) {
            e.preventDefault();
            const loading = Ladda.create(this);
            let   msg     = $("#form_p_notif_absensi #message");
            
            if (!$("input[name=absensi_masuk_sebelum_flag]:checked").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_notif_absensi_masuk_sebelum_flag') ?></font>");
                return false;
            }

            if ( $("input[name=absensi_masuk_sebelum_flag]:checked").val() == "1") {
                if (!$("#absensi_masuk_sebelum_menit").val() || $("#absensi_masuk_sebelum_menit").val() === "0") {
                    msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("error_notif_absensi_masuk_sebelum_menit"); ?></font>");
                    $("#absensi_masuk_sebelum_menit").focus();
                    return false;
                }
            }

            if (!$("input[name=absensi_masuk_setelah_flag]:checked").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_notif_absensi_masuk_setelah_flag') ?></font>");
                return false;
            }

            if ( $("input[name=absensi_masuk_setelah_flag]:checked").val() == "1") {
                if (!$("#absensi_masuk_setelah_menit").val() || $("#absensi_masuk_setelah_menit").val() === "0") {
                    msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("error_notif_absensi_masuk_setelah_menit"); ?></font>");
                    $("#absensi_masuk_setelah_menit").focus();
                    return false;
                }
            }

            if (!$("input[name=absensi_pulang_setelah_flag]:checked").val()) {
                msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_notif_absensi_pulang_setelah_flag') ?></font>");
                return false;
            }

            if ( $("input[name=absensi_pulang_setelah_flag]:checked").val() == "1") {
                if (!$("#absensi_pulang_setelah_menit").val() || $("#absensi_pulang_setelah_menit").val() === "0") {
                    msg.html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line("error_notif_absensi_pulang_setelah_menit"); ?></font>");
                    $("#absensi_pulang_setelah_menit").focus();
                    return false;
                }
            }

            loading.start();

            var params = {};
            params.absensi_masuk_sebelum_flag   = $("input[name=absensi_masuk_sebelum_flag]:checked").val();
            params.absensi_masuk_setelah_flag   = $("input[name=absensi_masuk_setelah_flag]:checked").val();
            params.absensi_pulang_setelah_flag  = $("input[name=absensi_pulang_setelah_flag]:checked").val();
            params.absensi_masuk_sebelum_menit  = $("#absensi_masuk_sebelum_menit").val();
            params.absensi_masuk_setelah_menit  = $("#absensi_masuk_setelah_menit").val();
            params.absensi_pulang_setelah_menit = $("#absensi_pulang_setelah_menit").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.umum.notif.absensi.save') ?>",
                data: params,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        $(".btn_batal_notif_absensi").hide();
                        $(".btn_save_notif_absensi").hide();
                        $(".btn_edit_notif_absensi").show();
                        $('#form_p_notif_absensi #div_body_notif_absensi').load(window.location.href + ' #form_p_notif_absensi #div_body_notif_absensi');
                    }
                    loading.stop();
                    msg.show();
                    msg.html(result.message);
                    
                    setTimeout(function() {
                        msg.html("");
                    }, 2000);
                },
                error: function() {
                    loading.stop();
                    msg.show();
                    msg.html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line("error"); ?></strong></font>');
                }
            });
        });
        // END NOTIF ABSENSI
    });

    function enforceMinMax(el) {
        if (el.value != "") {
            if (parseInt(el.value) < parseInt(el.min)) {
                el.value = el.min;
            }
            if (parseInt(el.value) > parseInt(el.max)) {
                el.value = el.max;
            }
        }
    }

    function load_cuti_p() {
        const id = "<?= $pengaturan_cuti->id_cuti_p ?: '' ?>";
        $("#content-form").load("<?= route('pengaturan.umum.form.cuti', ['id_cuti_p' => '"+id+"']) ?>");
    }
</script>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_pengaturan') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Kolom 1 -->
    <div class="col-md-3">
        <div id="form_pengaturan_cuti">
            <div class="card card-rounded">
                <div class="card-content">
                    <div class="card-header">
                        <h5>
                            <?= $this->lang->line('pengaturan_cuti') ?>
                        </h5>
                    </div>
                    <div id="content-form">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden" id="cuti_p" value="<?= ($pengaturan_cuti->id_cuti_p) ?: '' ?>" disabled>
                                    <label for="reset_cuti"><?= $this->lang->line('pengaturan_cuti_pertanyaan_1') ?></label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input type="radio" name="reset_cuti" value="join_date" id="reset_cuti_join_date" <?= ($pengaturan_cuti->reset_jenis == 'join_date') ? 'checked=true' : '' ?> <?= ($pengaturan_cuti->reset_jenis) ? 'disabled' : '' ?>>
                                            <label for="reset_cuti_join_date">Join Date</label>
                                        </div>
                                        <div class="col-md-6">
                                            <input type="radio" name="reset_cuti" value="bulan" id="reset_cuti_bulan" <?= ($pengaturan_cuti->reset_jenis == 'bulan') ? 'checked=true' : '' ?> <?= ($pengaturan_cuti->reset_jenis) ? 'disabled' : '' ?>>
                                            <label for="reset_cuti_bulan"><?= $this->lang->line('pengaturan_cuti_bulan') ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-2" id="form_periode_cuti" <?= ($pengaturan_cuti->reset_jenis == 'bulan') ? '' : 'style="display: none;"' ?>>
                                <div class="col-md-12">
                                    <label for="periode_cuti"><?= $this->lang->line('pengaturan_cuti_pertanyaan_2') ?> <span class="text-danger">*</span></label>
                                    <select name="periode_cuti" id="periode_cuti" class="form-control" <?= ($pengaturan_cuti->periode_cuti) ? 'disabled' : '' ?>>
                                        <option value="" selected disabled><?= $this->lang->line('pengaturan_cuti_pilih_bulan') ?></option>
                                        <option value="1" <?= ($pengaturan_cuti->periode_cuti == '1') ? 'selected' : '' ?>><?= $this->lang->line('januari') ?></option>
                                        <option value="2" <?= ($pengaturan_cuti->periode_cuti == '2') ? 'selected' : '' ?>><?= $this->lang->line('februari') ?></option>
                                        <option value="3" <?= ($pengaturan_cuti->periode_cuti == '3') ? 'selected' : '' ?>><?= $this->lang->line('maret') ?></option>
                                        <option value="4" <?= ($pengaturan_cuti->periode_cuti == '4') ? 'selected' : '' ?>><?= $this->lang->line('april') ?></option>
                                        <option value="5" <?= ($pengaturan_cuti->periode_cuti == '5') ? 'selected' : '' ?>><?= $this->lang->line('mei') ?></option>
                                        <option value="6" <?= ($pengaturan_cuti->periode_cuti == '6') ? 'selected' : '' ?>><?= $this->lang->line('juni') ?></option>
                                        <option value="7" <?= ($pengaturan_cuti->periode_cuti == '7') ? 'selected' : '' ?>><?= $this->lang->line('juli') ?></option>
                                        <option value="8" <?= ($pengaturan_cuti->periode_cuti == '8') ? 'selected' : '' ?>><?= $this->lang->line('agustus') ?></option>
                                        <option value="9" <?= ($pengaturan_cuti->periode_cuti == '9') ? 'selected' : '' ?>><?= $this->lang->line('september') ?></option>
                                        <option value="10" <?= ($pengaturan_cuti->periode_cuti == '10') ? 'selected' : '' ?>><?= $this->lang->line('oktober') ?></option>
                                        <option value="11" <?= ($pengaturan_cuti->periode_cuti == '11') ? 'selected' : '' ?>><?= $this->lang->line('november') ?></option>
                                        <option value="12" <?= ($pengaturan_cuti->periode_cuti == '12') ? 'selected' : '' ?>><?= $this->lang->line('desember') ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label for="reset_saldo"><?= $this->lang->line('pengaturan_cuti_reset') ?> <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="reset_saldo" min="0" value="<?= ($pengaturan_cuti->reset_saldo) ?: '' ?>" <?= ($pengaturan_cuti->reset_saldo) ? 'disabled' : '' ?>>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('pengaturan_cuti_pertanyaan_3') ?> <span class="text-danger">*</span></label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input type="checkbox" name="jenis_karyawan" value="tetap" id="jenis_karyawan_tetap" <?= ($pengaturan_cuti->jenis_karyawan == 'tetap') ? 'checked=true' : '' ?> <?= ($pengaturan_cuti->jenis_karyawan) ? 'disabled' : '' ?>>
                                            <label for="jenis_karyawan_tetap"><?= $this->lang->line('tetap') ?></label>
                                        </div>
                                        <div class="col-md-6">
                                            <input type="checkbox" name="jenis_karyawan" value="kontrak" id="jenis_karyawan_kontrak" <?= ($pengaturan_cuti->jenis_karyawan == 'kontrak') ? 'checked=true' : '' ?> <?= ($pengaturan_cuti->jenis_karyawan) ? 'disabled' : '' ?>>
                                            <label for="jenis_karyawan_kontrak"><?= $this->lang->line('kontrak') ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label for="join_date_bulan"><?= $this->lang->line('pengaturan_cuti_pertanyaan_4') ?> <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="join_date_bulan" value="<?= ($pengaturan_cuti->join_date_bulan) ?: '' ?>" <?= ($pengaturan_cuti->join_date_bulan) ? 'disabled' : '' ?>>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label for="carry_forward_maks_saldo"><?= $this->lang->line('pengaturan_cuti_pertanyaan_5') ?> <span class="text-danger">*</span></label>
                                    <input type="text" name="carry_forward_maks_saldo" id="carry_forward_maks_saldo" class="form-control" value="<?= ($pengaturan_cuti->carry_forward_maks_saldo) ?: '0' ?>" <?= ($pengaturan_cuti->carry_forward_maks_saldo != '') ? 'disabled' : '' ?>>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label for="carry_forward_maks_bulan"><?= $this->lang->line('pengaturan_cuti_pertanyaan_6') ?> <span class="text-danger">*</span></label>
                                    <input type="number" name="carry_forward_maks_bulan" id="carry_forward_maks_bulan" class="form-control" min="0" max="12" oninput="enforceMinMax(this)" value="<?= ($pengaturan_cuti->carry_forward_maks_bulan) ?: '0' ?>" <?= ($pengaturan_cuti->carry_forward_maks_bulan != '') ? 'disabled' : '' ?>>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer card-footer-rounded">
                            <button class="btn_batal_cuti btn btn-secondary" style="display:none"><i class="fa fa-close"> </i> <?= $this->lang->line('button_form_batal') ?></button>
                            <button class="btn_save_cuti btn btn-primary ladda-button" <?= (isset($pengaturan_cuti)) ? 'style="display:none"' : '' ?> data-style="expand-left" for-data="<?= (isset($pengaturan_cuti)) ? 'update' : 'store' ?>"><i class="fa fa-save "> </i> <?= $this->lang->line('button_form_simpan') ?></button>
                            <button class="btn_edit_cuti btn btn-warning" <?= (!isset($pengaturan_cuti)) ? 'style="display:none"' : '' ?>><i class="fa fa-edit (alias) "> </i> EDIT</button>
                            <label id="message"></label>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Kolom 2 -->
    <div class="col-md-3">
        <div id="form_p_notif_absensi">
            <div class="card card-rounded">
                <div class="card-content">
                    <div class="card-header">
                        <h5><?= $this->lang->line('p_notifikasi_absensi') ?></h5>
                        <p><span class="text-danger">*</span> <?= $this->lang->line('p_notifikasi_absensi_note') ?></p>
                    </div>

                    <div class="card-body">
                        <div id="div_body_notif_absensi">
                            <?php
                                $absensi_masuk_sebelum_flag   = ($pengaturan_notif_absensi->absensi_masuk_sebelum_flag) ? ($pengaturan_notif_absensi->absensi_masuk_sebelum_flag) : '0';
                                $absensi_masuk_sebelum_menit  = ($pengaturan_notif_absensi->absensi_masuk_sebelum_menit) ?: '';
                                $absensi_masuk_setelah_flag   = ($pengaturan_notif_absensi->absensi_masuk_setelah_flag) ?: '0';
                                $absensi_masuk_setelah_menit  = ($pengaturan_notif_absensi->absensi_masuk_setelah_menit) ?: '';
                                $absensi_pulang_setelah_flag  = ($pengaturan_notif_absensi->absensi_pulang_setelah_flag) ?: '0';
                                $absensi_pulang_setelah_menit = ($pengaturan_notif_absensi->absensi_pulang_setelah_menit) ?: '';

                                $hidden_absensi_masuk_sebelum  = empty($absensi_masuk_sebelum_flag) ? 'style="display:none"' : '';
                                $hidden_absensi_masuk_setelah  = empty($absensi_masuk_setelah_flag) ? 'style="display:none"' : '';
                                $hidden_absensi_pulang_setelah = empty($absensi_pulang_setelah_flag) ? 'style="display:none"' : '';
                            ?>

                            <div class="row">
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('notif_absensi_masuk_sebelum') ?></label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input 
                                                type="radio" 
                                                id="absensi_masuk_sebelum_flag" 
                                                name="absensi_masuk_sebelum_flag" 
                                                value="0" 
                                                <?= ($absensi_masuk_sebelum_flag== '0') ? 'checked=true' : '' ?> 
                                                disabled
                                            >
                                            <label><?= $this->lang->line('tidak') ?></label>
                                        </div>
                                        <div class="col-md-6">
                                            <input 
                                                type="radio" 
                                                id="absensi_masuk_sebelum_flag" 
                                                name="absensi_masuk_sebelum_flag" 
                                                value="1" 
                                                <?= ($absensi_masuk_sebelum_flag== '1') ? 'checked=true' : '' ?> 
                                                disabled
                                            >
                                            <label><?= $this->lang->line('ya') ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div id="div_absensi_masuk_sebelum_menit" class="row mt-2" <?= $hidden_absensi_masuk_sebelum ?>>
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('notif_absensi_masuk_sebelum_menit') ?> <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="absensi_masuk_sebelum_menit" min="0" value="<?= $absensi_masuk_sebelum_menit ?>" disabled>
                                </div>
                            </div>

                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('notif_absensi_masuk_setelah') ?></label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input 
                                                type="radio" 
                                                id="absensi_masuk_setelah_flag" 
                                                name="absensi_masuk_setelah_flag" 
                                                value="0" 
                                                <?= ($absensi_masuk_setelah_flag== '0') ? 'checked=true' : '' ?> 
                                                disabled
                                            >
                                            <label><?= $this->lang->line('tidak') ?></label>
                                        </div>
                                        <div class="col-md-6">
                                            <input 
                                                type="radio" 
                                                id="absensi_masuk_setelah_flag" 
                                                name="absensi_masuk_setelah_flag" 
                                                value="1" 
                                                <?= ($absensi_masuk_setelah_flag== '1') ? 'checked=true' : '' ?> 
                                                disabled
                                            >
                                            <label><?= $this->lang->line('ya') ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div id="div_absensi_masuk_setelah_menit" class="row mt-2" <?= $hidden_absensi_masuk_setelah ?>>
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('notif_absensi_masuk_setelah_menit') ?> <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="absensi_masuk_setelah_menit" min="0" value="<?= $absensi_masuk_setelah_menit ?>" disabled>
                                </div>
                            </div>

                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('notif_absensi_pulang_setelah') ?></label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input 
                                                type="radio" 
                                                id="absensi_pulang_setelah_flag" 
                                                name="absensi_pulang_setelah_flag" 
                                                value="0" 
                                                <?= ($absensi_pulang_setelah_flag== '0') ? 'checked=true' : '' ?> 
                                                disabled
                                            >
                                            <label><?= $this->lang->line('tidak') ?></label>
                                        </div>
                                        <div class="col-md-6">
                                            <input 
                                                type="radio" 
                                                id="absensi_pulang_setelah_flag" 
                                                name="absensi_pulang_setelah_flag" 
                                                value="1" 
                                                <?= ($absensi_pulang_setelah_flag== '1') ? 'checked=true' : '' ?> 
                                                disabled
                                            >
                                            <label><?= $this->lang->line('ya') ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div id="div_absensi_pulang_setelah_menit" class="row mt-2" <?= $hidden_absensi_pulang_setelah ?>>
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('notif_absensi_pulang_setelah_menit') ?> <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="absensi_pulang_setelah_menit" min="0" value="<?= $absensi_pulang_setelah_menit ?>" disabled>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer card-footer-rounded">
                        <button class="btn_batal_notif_absensi btn btn-secondary" form-data="form_locklokasi" style="display:none"><i class="fa fa-close"> </i> <?= $this->lang->line('button_form_batal') ?></button>
                        <button class="btn_save_notif_absensi btn btn-primary ladda-button" data-style="expand-left" form-data="form_locklokasi" style="display:none"><i class="fa fa-save "> </i> <?= $this->lang->line('button_form_simpan') ?></button>
                        <button class="btn_edit_notif_absensi btn btn-warning" form-data="form_locklokasi"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                        <label id="message"></label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Kolom 3 -->
    <div class="col-md-6">
        <!-- Lock Lokasi -->
        <div class="row">
            <div id="form_locklokasi" class="col-md-6">
                <div class="card card-rounded">
                    <div class="card-content">
                        <div class="card-header" style="height:90px">
                            <h5>
                                <?= $this->lang->line('pengaturan_lock_lokasi'); ?>
                                <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_lock_lokasi ?>"></i>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden" id="value_lama" value="<?= $data->lock_lokasi ?>">
                                    <div class="custom-radio-blue">
                                        <section class="light">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="lock_lokasi" value="0" <?= ((isset($data) && $data->lock_lokasi == "0") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('tidak'); ?></span>
                                                    </label>
                                                </div>
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="lock_lokasi" value="1" <?= ((isset($data) && $data->lock_lokasi == "1") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('ya'); ?></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </section>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer card-footer-rounded">
                            <button class="btn_batal btn btn-secondary" form-data="form_locklokasi" style="display:none"><i class="fa fa-close"> </i> <?= $this->lang->line('button_form_batal') ?></button>
                            <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_locklokasi" style="display:none"><i class="fa fa-save "> </i> <?= $this->lang->line('button_form_simpan') ?></button>
                            <button class="btn_edit btn btn-warning" form-data="form_locklokasi"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                            <label id="message"></label>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Lock Device -->
            <div id="form_lockdevice" class="col-md-6">
                <div class="card card-rounded">
                    <div class="card-content">
                        <div class="card-header" style="height:90px">
                            <h5>
                                <?= $this->lang->line('pengaturan_lock_device') ?>
                                <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_lock_device ?>"></i>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden" id="value_lama" value="<?= $data->lock_device ?>">
                                    <div class="custom-radio-blue">
                                        <section class="light">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="lock_device" value="0" <?= ((isset($data) && $data->lock_device == "0") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('tidak'); ?></span>
                                                    </label>
                                                </div>
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="lock_device" value="1" <?= ((isset($data) && $data->lock_device == "1") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('ya'); ?></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </section>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer card-footer-rounded">
                            <button class="btn_batal btn btn-secondary" form-data="form_lockdevice" style="display:none"><i class="fa fa-batal "> </i> <?= $this->lang->line('button_form_batal') ?></button>
                            <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_lockdevice" style="display:none"><i class="fa fa-save "> </i> <?= $this->lang->line('button_form_simpan') ?></button>
                            <button class="btn_edit btn btn-warning" form-data="form_lockdevice"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                            <label id="message"></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Lock Face -->
            <div id="form_facerecognition" class="col-md-6">
                <div class="card card-rounded">
                    <div class="card-content">
                        <div class="card-header" style="height:90px">
                            <h5>
                                <?= $this->lang->line('pengaturan_lock_face') ?>
                                <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_lock_facerecognition ?>"></i>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden" id="value_lama" value="<?= $data->lock_facerecognition ?>">
                                    <div class="custom-radio-blue">
                                        <section class="light">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="lock_facerecognition" value="0" <?= ((isset($data) && $data->lock_facerecognition == "0") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('tidak'); ?></span>
                                                    </label>
                                                </div>
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="lock_facerecognition" value="1" <?= ((isset($data) && $data->lock_facerecognition == "1") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('ya'); ?></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </section>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer card-footer-rounded">
                            <button class="btn_batal btn btn-secondary" form-data="form_facerecognition" style="display:none"><i class="fa fa-close"> </i> <?= $this->lang->line('button_form_batal') ?></button>
                            <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_facerecognition" style="display:none"><i class="fa fa-save "> </i> <?= $this->lang->line('button_form_simpan') ?></button>
                            <button class="btn_edit btn btn-warning" form-data="form_facerecognition"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                            <label id="message"></label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tukar Shift -->
            <div id="form_tukarshift" class="col-md-6 <?= ((isset($pengaturan_shift)) ? "" : "hidden") ?>">
                <div class="card card-rounded">
                    <div class="card-content">
                        <div class="card-header" style="height:90px">
                            <h5>
                                <?= $this->lang->line('pengaturan_izinkan_tukar_shift') ?>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="hidden" id="value_lama" value="<?= $pengaturan_shift->aktif ?>">
                                    <div class="custom-radio-blue">
                                        <section class="light">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="pengaturan_shift" value="0" <?= ((isset($pengaturan_shift) && $pengaturan_shift->aktif == "0") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('tidak'); ?></span>
                                                    </label>
                                                </div>
                                                <div class="col-md-6">
                                                    <label id="label" class="disabled">
                                                        <input type="radio" name="pengaturan_shift" value="1" <?= ((isset($pengaturan_shift) && $pengaturan_shift->aktif == "1") ? "checked" : "") ?> disabled>
                                                        <span class="design"></span>
                                                        <span class="text"><?= $this->lang->line('ya'); ?></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </section>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer card-footer-rounded">
                            <button class="btn_batal btn btn-secondary" form-data="form_tukarshift" style="display:none"><i class="fa fa-close"> </i> <?= $this->lang->line('button_form_batal') ?></button>
                            <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_tukarshift" style="display:none"><i class="fa fa-save "> </i> <?= $this->lang->line('button_form_simpan') ?></button>
                            <button class="btn_edit btn btn-warning" form-data="form_tukarshift"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                            <label id="message"></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- START TAMPIL MODAL CUTI-->
<div id="modal_cuti" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <input type="hidden" id="status">
            <input type="hidden" id="option">
            <input type="hidden" id="jml_cuti">
            <div class="card-header">
                <button type="button" id="modal_close" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div id="message" class="col-md-7 text-left"></div>
                    <div class="col-md-5 text-right">
                        <button class="btn btn-secondary" data-dismiss="modal">BATAL</button>
                        <button id="btn_confrim_cuti" class="btn btn-success ladda-button" data-style="expand-left">YA</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL CUTI-->
