<!-- BAGIN DATATABLE -->
<script type="text/javascript">
    $(document).ready(function() {
        var id = location.pathname.match(/detail\/(\w+)/)[1];
        var bln = location.pathname.match(/detail\/\w+\/(\w+\-\w+)/)[1];
        $.fn.dataTable.ext.errMode = 'throw';
        list_data = $('#list_data').DataTable({
                    'searching'   : false,
                    'searchDelay' : 1000,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    'stateSave'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'NIK/Nama Karyawan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route('payroll.tunjangan.tidak.tetap.datatable.detail') ?>"+"/"+id+"/"+bln,
                                        "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0,1,2,3,4,5,6,7], "bSortable": false },
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(1)', nRow).css({'text-align':'left'});
                            $('td:eq(2),td:eq(3)', nRow).css({'text-align':'center'});
                            $('td:eq(4)', nRow).css({'text-align':'right'});
                            $('td:eq(5),td:eq(6)', nRow).css({'text-align':'center'});
                            $('td:eq(7)', nRow).css({'text-align':'center','width':'50px'});
                    }
        });
    });
</script>
<!-- END DATATABLE -->


<!-- BEGIN FORM INPUT -->
<script type="text/javascript">
    $(function() {
        // $('.btn_tambah').click(function(){
        $(document).on("click",".btn_tambah",function(){
            $('#tampil_form').load("<?= route('payroll.tunjangan.tidak.tetap.form.tambah.item') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Tambah Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('SIMPAN');
                $("#btn_new_input").hide();
                $("#form_input #periode").val("<?= $periode ?>");
            });
        });

        // $('.btn_edit').click(function(){
        $(document).on("click",".btn_edit",function(){
            $('#tampil_form').load("<?= route('payroll.tunjangan.tidak.tetap.form.edit') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Edit Data");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('PERBARUI');
                $("#btn_new_input").hide();
            });
        });

        // $('.btn_delete').click(function(){
        $(document).on("click",".btn_delete",function(){
            $('#tampil_form').load("<?= route('payroll.tunjangan.tidak.tetap.form.delete') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $('#form_input input[type=text]').prop("disabled",true);
                $('#form_input input[type=radio]').prop("disabled",true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('HAPUS');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        // $('#btn_new_input',).click(function(){
        $(document).on("click","#btn_new_input",function(){
            $('#form_input input[type=text]').prop("disabled",false);
            $('#form_input input[type=radio]').prop("disabled",false);
            $("#form_input #nm_tunjangan").val('');
            $("#form_input #persentase").val('');
            $("#form_input #nominal").val('');

            let val = $("#form_persentase_gapok input[type='radio']:checked").val();
            if (val == "1") {
                $("#form_persentase").attr("class","form-group");
                $("#nominal").attr("disabled","true");
            }else{
                $("#form_persentase").attr("class","form-group hidden");
                $("#nominal").removeAttr("disabled");
            }
            $("#nm_tunjangan").focus();

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            $('#message').show();
            var loading = Ladda.create(this);

            if($("#form_input #key").val() == ""){
                if(!$("#form_input #id_karyawan").val()){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Karyawan tidak ditemukan</font>");
                    return false;
                }else if (!$("#form_input #periode").val()) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Karyawan tidak ditemukan</font>");
                    return false;
                }
            }

            if($("#form_input #nm_tunjangan").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama tunjangan harus diisi</font>");
                $('#form_input #nm_tunjangan').focus();
                return false;
            }

            if($("#form_persentase_gapok input[type='radio']:checked").val() == "1"){
                if ($("#form_input #persentase").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Persentase harus diisi</font>");
                    $('#form_input #persentase').focus();
                    return false;
                }
            }else{
                if ($("#form_input #nominal").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nominal tunjangan harus diisi</font>");
                    $('#form_input #nominal').focus();
                    return false;
                }
            }

            loading.start();

            var param = {};
            param.key           = $("#form_input #key").val();
            param.periode       = $("#form_input #periode").val();
            param.id_karyawan   = $("#form_input #id_karyawan").val();
            param.nm_tunjangan  = $("#form_input #nm_tunjangan").val();
            param.nominal       = $("#form_input #nominal").val();
            param.gapok_rp      = $("#form_input #gapok_rp").val();
            param.flag_persentase   = $("#form_persentase_gapok input[type='radio']:checked").val();
            param.persentase        = $("#form_input #persentase").val();
            param.flag_bpjs         = $("#form_bpjs input[type='radio']:checked").val();
            // param.flag_pph21        = $("#form_pph21 input[type='radio']:checked").val();
            param.flag_pot_absensi  = $("#form_pot_absensi input[type='radio']:checked").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.tunjangan.tidak.tetap.save') ?>",
                data: param,
                dataType:'JSON',
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // PROSES DELETE
        // $('.btn_hapus').click(function(){
        $(document).on("click",".btn_hapus",function(){
            var loading = Ladda.create(this);
            loading.start();

            var param = {};
            param.key = $("#form_input #key").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.tunjangan.tidak.tetap.delete') ?>",
                data: param,
                dataType:'JSON',
                success: function(result){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html((result.message).replace("009900","FFFFFF"));
                },
                error:function(){
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

    });
</script>
<!-- END FORM INPUT -->

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?> Tunjangan Tidak Tetap</h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item"><a href="#">Tunjangan Tidak Tetap</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
                if ($this->adm_payroll == true){
            ?>
                    <div class="float-md-right">
                        <a href="<?= route('payroll.tunjangan.tidak.tetap.home') ?>" class="btn btn-secondary btn-min-width">
                            <i class="fa fa-arrow-left"></i> KEMBALI
                        </a>
                    </div>
            <?php
                }
            ?>
        </div>
    </div>
    <hr>
    <div id="detail_karyawan" class="row">
        <div class="col-md-6">
            <div class="row">
                <div class="col-md-4" style="color: black; font-weight: bold;">Nama Karyawan</div>
                <div class="col-md-8" style="color: black; font-weight: bold;">: <?= ((isset($detail_karyawan[0]->nm_karyawan))?$detail_karyawan[0]->nik." - ".$detail_karyawan[0]->nm_karyawan:"") ?></div>
            </div>
            <div class="row">
                <div class="col-md-4" style="color: black; font-weight: bold;">Jabatan</div>
                <div class="col-md-8" style="color: black; font-weight: bold;">: <?= ((isset($detail_karyawan[0]->nm_jabatan))?$detail_karyawan[0]->kd_jabatan." - ".$detail_karyawan[0]->nm_jabatan:"") ?></div>
            </div>
            <div class="row">
                <div class="col-md-4" style="color: black; font-weight: bold;">Bulan - Tahun</div>
                <div class="col-md-8" style="color: black; font-weight: bold;">: <?= (isset($periode)?date("m - Y",strtotime($periode)):"") ?></div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="row">
                <div class="col-md-4" style="color: black; font-weight: bold;">Cabang</div>
                <div class="col-md-8" style="color: black; font-weight: bold;">: <?= ((isset($detail_karyawan[0]->nm_cabang))?$detail_karyawan[0]->kd_cabang." - ".$detail_karyawan[0]->nm_cabang:"") ?></div>
            </div>
            <div class="row">
                <div class="col-md-4" style="color: black; font-weight: bold;">Departemen</div>
                <div class="col-md-8" style="color: black; font-weight: bold;">: <?= ((isset($detail_karyawan[0]->nm_departemen))?$detail_karyawan[0]->kd_departemen." - ".$detail_karyawan[0]->nm_departemen:"") ?></div>
            </div>
            <div class="row">
                <input type="hidden" id="gapok" value="<?= ((isset($detail_karyawan[0]->nominal_gapok))?number_format($detail_karyawan[0]->nominal_gapok,0,",","."):"-") ?>" disabled>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button type="button" class="btn_tambah btn btn-biru">
                        <i class="fa fa-plus"></i> Tambah Data
                    </button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 table-responsive">
                    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th rowspan="2" class="align-middle text-center">NO</th>
                                <th rowspan="2" class="align-middle text-center">NAMA TUNJANGAN</th>
                                <th rowspan="2" class="align-middle text-center">PERSENTASE<br>DARI GAPOK</th>
                                <th rowspan="2" class="align-middle text-center">PERSENTASE</th>
                                <th rowspan="2" class="align-middle text-center">NOMINAL TUNJANGAN</th>
                                <th colspan="2" class="align-middle text-center">DIIKUTSERTAKAN HITUNGAN</th>
                                <th rowspan="2" class="align-middle text-center">AKSI</th>
                            </tr>
                            <tr>
                                <th class="text-center">BPJS</th>
                                <th class="text-center">POT. ABSENSI</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
