<script>
    $(function() {
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function(e, settings, techNote, message) {
            if (confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': false,
            'stateSave': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route("payroll.master.lembur.karyawan.import.data") ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                    $('[data-toggle="tooltip"]').tooltip();
                }
            },
            "initComplete": function() {
                $("#excel").show();
            },
            "aoColumnDefs": [{
                "className": "text-left",
                "aTargets": [1, 2]
            }, {
                "className": "text-center",
                "targets": "_all"
            }],

            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                let nik = $("td:eq(1) span", nRow);
                if (nik.text().substr(0, 1) == "#") {
                    nik.html(nik.text().substr(1));
                    nik.removeClass("text-light");
                    $("td", nRow).css("background-color", "#ff7588");
                } else {
                    let kode = [$("td:eq(3)", nRow), $("td:eq(4)", nRow), $("td:eq(5)", nRow), $("td:eq(6)", nRow)];
                    for (let index = 0; index < kode.length; index++) {
                        if (kode[index].text().substr(0, 1) == "#") {
                            kode[index].html(kode[index].text().substr(1));
                            kode[index].css("background-color", "#ffbc34");
                        }
                    }
                }
                $("td:eq(3), td:eq(4), td:eq(5), td:eq(6)", nRow).css("width", "170px");
                $("td:eq(-1)", nRow).css("width", "20px");
            }
        });

        $('#btn_form_template').on('click', function() {
            $('#tampil_form').load("<?= route('payroll.master.lembur.karyawan.import.template') ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("Unduh Template Master Lembur Karyawan");
                $("#btn_submit").addClass("btn btn-success");
                $("#btn_submit").html('<i class="fa fa-download"></i> UNDUH');
            });
        });

        $('#btn_import').on('click', function() {
            var loading = Ladda.create(this);
            $('.form_import #message').html("");

            if (document.getElementById("file").files.length == "0") {
                $('.form_import #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> File belum diupload</font>");
                $('#file').focus();
                return false;
            }

            loading.start();

            var data = new FormData();
            data.append('file', $('#file').prop('files')[0]);

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.master.lembur.karyawan.import.template.upload') ?>",
                data: data,
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(result) {
                    loading.stop();
                    $('.form_import #message').show();
                    $('.form_import #message').html(result.message);
                    list_data.ajax.reload();
                },
                error: function() {
                    loading.stop();
                    $('.form_import #message').show();
                    $('.form_import #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });

        });

        $('#hapus_all').on('click', function() {
            $('#modal_form').modal('show');
            $(".title").text("Apakah anda ingin menghapus semua data ini?");
            $("#modal_form .card-body").hide();
            $("#modal_form .card-footer").show();
            $("#modal_form .action").empty();
            $("#modal_form .action").append('<button class="btn_delete_semua btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');

            //btn_delete
            $('.btn_delete_semua').on('click', function() {
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'DELETE',
                    url: "<?= route('payroll.master.lembur.karyawan.import.delete') ?>",
                    dataType: 'JSON',
                    success: function(result) {
                        loading.stop();
                        if (result.success == true) {
                            showMsg(result.message);
                            list_data.ajax.reload();
                        } else {
                            showMsg(result.message.replace("#eb3a28", "#FFFFFF"), false);
                        }
                    },
                    error: function() {
                        loading.stop();
                        showMsg('error', false);
                    }
                });
            });
        });

        $('#simpan_all').on('click', function() {
            $("#modal_form").modal("show");
            $(".title").text("Apakah anda ingin menyimpan semua data ini?");
            $("#modal_form .card-body").hide();
            $("#modal_form .card-footer").show();
            $("#modal_form .action").empty();
            $("#modal_form .action").empty();
            $("#modal_form .action").append('<button class="btn_save_semua btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>');

            $('.btn_save_semua').on('click', function() {
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'POST',
                    url: "<?= route('payroll.master.lembur.karyawan.import.publish') ?>",
                    dataType: 'JSON',
                    success: function(result) {
                        loading.stop();
                        if (result.success == true) {
                            showMsg(result.message);
                            list_data.ajax.reload();
                        } else {
                            showMsg(result.message.replace("#eb3a28", "#FFFFFF"), false);
                        }
                    },
                    error: function() {
                        loading.stop();
                        showMsg('error', false);
                    }
                });
            });
        });
    });
</script>
<div class="content-header mt-4">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('payroll.master.lembur.home') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body form_import">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group mb-0">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input type="file" name="file" id="file" class="form-control">
                        <label id="message"></label>
                    </div>
                </div>
                <div class="col-md-7 align-self-center">
                    <div class="form-group mb-0">
                        <button type="button" id="btn_import" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-upload"></i> IMPORT DATA KOMPONEN</button>
                        <button type="button" id="btn_form_template" class="btn btn-primary"><i class="fa fa-download"></i> UNDUH TEMPLATE</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <button class="btn btn-success" id="simpan_all"><i class="fa fa-save"></i> Simpan Semua Data</button>
                    <button class="btn btn-danger" id="hapus_all"><i class="fa fa-trash"></i> Hapus Semua Draft</button>
                </div>
            </div>
            <div class="table-responsive mt-1">
                <div class="float-right pr-1">
                    <span class="mr-1">
                        <button class="btn btn-warning btn-sm"></button>
                        <span class="font-weight-bold">Kode tidak sesuai</span>
                    </span>
                    <span>
                        <button class="btn btn-danger btn-sm"></button>
                        <span class="font-weight-bold">Nik tidak ditemukan</span>
                    </span>
                </div>
                <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                    <thead>
                        <tr>
                            <th rowspan="2" class="text-center align-middle" width="20">NO</th>
                            <th rowspan="2" class="text-center align-middle">NAMA</th>
                            <th rowspan="2" class="text-center align-middle">CABANG<br>DEPARTEMEN</th>
                            <th colspan="4" class="text-center align-middle">LEMBUR</th>
                        </tr>
                        <tr>
                            <th class="text-center align-middle">HARI KERJA <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Reguler / Shift"></i></th>
                            <th class="text-center align-middle">LIBUR <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Libur Reguler / Shift off"></i></th>
                            <th class="text-center align-middle">LIBUR NASIONAL <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Contoh: Libur Hari Pancasila, Kemerdekaan"></i></th>
                            <th class="text-center align-middle">LIBUR KHUSUS <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Contoh: Libur Hari Raya Idul Fitri"></i></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
