<style>
    #modal-detail-upah-lembur.table-responsive {
        max-height: 450px;
        overflow-y: auto;
    }

    #modal-detail-upah-lembur.table-responsive table {
        font-size: 12px;
    }

    #modal-detail-upah-lembur.table th,
    #modal-detail-upah-lembur.table td {
        padding: 0;
    }

    .sticky-table {
        background-color: #babfc7;
        position: sticky;
    }

    .sticky-table-head {
        inset-block-start: 0;
    }

    .sticky-table-foot {
        inset-block-end: 0;
    }

    .bg-biru {
        background-color: #3d77d4;
        color: white;
    }
</style>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div class="card-body" disabled>
    <div id="modal-detail-upah-lembur" class="table-responsive">
        <table class="table table-striped table-bordered mb-0" style="width:100%">
            <thead class="text-black text-center sticky-table sticky-table-head">
                <th class="align-top text-uppercase">Tanggal</th>
                <th class="align-top text-uppercase">Total Lembur</th>
                <th class="align-top text-uppercase">Nominal Lembur<br>Per Jam</th>
                <th class="align-top text-uppercase">Kompensasi Rate</th>
                <th class="align-top text-uppercase">Total Upah</th>
            </thead>
            <tbody>
                <?php foreach ($data as $value) : ?>
                    <tr>
                        <td style="white-space: nowrap"><?= date("d-m-Y", strtotime($value->tgl_lembur)) ?></td>
                        <td style="white-space: nowrap">
                            <?php
                            $ttl_lembur = explode('.', $value->ttl_lembur_rounded);
                            echo $ttl_lembur[0] . ' jam<br>' . $ttl_lembur[1] . ' menit';
                            ?>
                        </td>
                        <td>
                            <span class="text-left">Rp </span>
                            <span class="float-right">
                                <?= number_format($value->nominal_lembur_per_jam, 0, ',', '.') ?>
                            </span>
                        </td>
                        <td style="white-space: nowrap">
                            <?php
                            foreach (json_decode($value->ttl_lembur_dikali, true) as $aturan) {
                                $jam_menit = explode('.', $aturan['jam']);
                                $jam       = $jam_menit[0] . ' jam';
                                $menit     = ($jam_menit[1]) ? $jam_menit[1] . ' menit' : '';
                                echo $aturan['kali'] . ' <b>x</b> ' . $jam . ' ' . $menit  .  '<br>';
                            }
                            ?>
                        </td>
                        <td>
                            <span class="text-left">Rp </span>
                            <span class="float-right">
                                <?= number_format($value->ttl_lembur_rp, 0, ',', '.') ?>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot class="sticky-table-foot sticky-table text-black">
                <tr>
                    <td colspan="4" class="text-center align-middle font-weight-bold text-uppercase">Total Upah Lembur</td>
                    <td style="white-space: nowrap;font-weight: bolder;font-size: 14px">
                        <span class="text-left">Rp </span>
                        <span class="float-right">
                            <?= number_format(array_sum(array_column((array)$data, 'ttl_lembur_rp')), 0, ',', '.') ?>
                        </span>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
