<style>
    html body .content .content-wrapper {
        padding-top: 20px;
    }

    .card-header {
        border-top-left-radius: 0px !important;
        border-top-right-radius: 0px !important;
    }
    .dark-blue-color {
        color: #1c77d4 !important;
        font-weight: bold !important;
    }

    .badge-primary-periode {
        background-color: #CDE8F5;
        color           : #3C7AAB;
        font-family     : 'Poppins SemiBold';
        font-size       : 14px;
        border-color    : #9FD0E8;
        border-style    : solid;
        border-radius   : 10px;
    }
</style>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">Key Performance Indicator</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row match-height">
    <div class="col-xl-12 col-lg-12">
        <div class="card card-rounded card-detail-karyawan">
            <div class="card-content">
                <div class="card-body p-custom">
                    <div class="nav-vertical row">
                        <div class="col-md-2 border-kanan">
                            <ul class="tab_menu nav nav-tabs nav-left flex-column">
                                <?php if($this->level_user == '1') : ?>
                                <li class="nav-item">
                                    <a id="tab_pengaturan" class="nav-link" onclick="load_tab_content('pengaturan')" aria-expanded="false">
                                        <?= $this->lang->line('menu_pengaturan') ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a id="tab_master" class="nav-link" onclick="unset_detail('master');load_tab_content('master');" aria-expanded="false">
                                        Master
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a id="tab_periode" class="nav-link" onclick="load_tab_content('periode')"  aria-expanded="false">
                                        <?= $this->lang->line('periode') ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a id="tab_laporan" class="nav-link" onclick="unset_detail('laporan');load_tab_content('laporan');"  aria-expanded="false">
                                        <?= $this->lang->line('laporan') ?>
                                    </a>
                                </li>
                                <?php else : ?>
                                    <?php if($sebagaiApprover) : ?>
                                <li class="nav-item">
                                    <a id="tab_kpi_team" class="nav-link" onclick="unset_detail('kpi_team');load_tab_content('kpi_team');" aria-expanded="false">
                                        KPI Team
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a id="tab_approval" class="nav-link" onclick="unset_detail('approval');load_tab_content('approval');" aria-expanded="false">
                                        Approval
                                    </a>
                                </li>
                                    <?php endif; ?>
                                <li class="nav-item">
                                    <a id="tab_kpi_saya" class="nav-link" onclick="load_tab_content('kpi_saya')" aria-expanded="false">
                                        <?= $this->lang->line('kpi_saya') ?>
                                    </a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="col-md-10" style="padding: 20px;">
                            <div class="modal-body" id="loading_tab_content" style="display: none;"><div class="text-center"><div class="custom-lds-ring"><div></div><div></div><div></div></div></div></div>
                            <div id="myTabContent" class="tab-content"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(function() {
    <?php if (!$sebagaiApprover && $this->level_user != '1') : ?>
        $('.border-kanan').hide();
        $('#myTabContent').parent().removeClass('col-md-10').addClass('col-md-12');
    <?php endif; ?>
    tab_content_init();
});

function tab_content_init() {
    if(localStorage.getItem("menu_kpi") == null) {
        <?php if($this->level_user == '1') : ?>
        $("#tab_pengaturan").addClass("active");
        load_tab_content("pengaturan");
        <?php else : ?>
            <?php if($sebagaiApprover) : ?>
            $("#tab_kpi_team").addClass("active");
            load_tab_content("kpi_team");
            <?php else : ?>
            $("#tab_kpi_saya").addClass("active");
            load_tab_content("kpi_saya");
            <?php endif; ?>
        <?php endif; ?>
    } else {
        const menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
        <?php if($this->level_user != '1') : ?>
            <?php if($sebagaiApprover) : ?>
            if(['kpi_saya', 'kpi_team', 'approval'].includes(menu_kpi.active) == false) {
                load_tab_content('kpi_team');
            } else {
                load_tab_content(menu_kpi.active);
            }
            <?php else : ?>
            if(menu_kpi.active != 'kpi_saya') {
                load_tab_content('kpi_saya');
            } else {
                load_tab_content(menu_kpi.active);
            }
            <?php endif; ?>
        <?php else : ?>
            if(['pengaturan', 'master', 'periode', 'laporan'].includes(menu_kpi.active)) {
                load_tab_content(menu_kpi.active);
            } else {
                load_tab_content('pengaturan');
            }
        <?php endif; ?>
    }
}

function load_tab_content(tab) {
    let menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
    set_tab_active(menu_kpi, tab);
    menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
    $('#myTabContentDetail').hide();
    $('#myTabContent').html('');
    $('#message_kpi').html('');
    $('#loading_tab_content').show();

    <?php if($this->level_user == '1') : ?>
    if(tab == "pengaturan") {
        $('#myTabContent').load("<?= route('kpi.pengaturan') ?>", function() {
            $('#loading_tab_content').hide();
            $('#myTabContent').show();
            load_tab_sub_content_init(menu_kpi, tab);
        });
    } else if(tab == "master") {
        $('#myTabContent').load("<?= route('kpi.master') ?>", function() {
            $('#loading_tab_content').hide();
            $('#myTabContent').show();
            load_tab_sub_content_init(menu_kpi, tab);
        });
    } else if(tab == "periode") {
        $('#myTabContent').load("<?= route('kpi.periode') ?>", function() {
            $('#loading_tab_content').hide();
            $('#myTabContent').show();
            load_tab_sub_content_init(menu_kpi, tab);
        });
    } else if(tab == "laporan") {
        $('#myTabContent').load("<?= route('kpi.laporan') ?>", function() {
            $('#loading_tab_content').hide();
            $('#myTabContent').show();
        });
    }
    <?php else : ?>
        <?php if($sebagaiApprover) : ?>
        if(tab == "kpi_saya") {
            restore_tab_detail("kpi_saya", function() { $("#myTabContent").load("<?= route('kpi.saya') ?>", function() {
                    $('#loading_tab_content').hide();
                    $('#myTabContent').show();
                });
            });
        } else if(tab == "kpi_team") {
            restore_tab_detail("kpi_team", function() {$("#myTabContent").load("<?= route('kpi.team') ?>", function() {
                    $('#loading_tab_content').hide();
                    $('#myTabContent').show();
                });
            });
        } else if(tab == "approval") {
            restore_tab_detail("approval", function() { $("#myTabContent").load("<?= route('kpi.approval') ?>", function() {
                    $('#loading_tab_content').hide();
                    $('#myTabContent').show();
                    load_tab_sub_content_init(menu_kpi, tab);
                });
            });
        }
        <?php else : ?>
        if(tab == "kpi_saya") {
            restore_tab_detail("kpi_saya", function() { $("#myTabContent").load("<?= route('kpi.saya') ?>", function() {
                    $('#loading_tab_content').hide();
                    $('#myTabContent').show();
                });
            });
        }
        <?php endif; ?>
    <?php endif; ?>
}

function restore_tab_detail(menu, callback) {
    const menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
    if(menu_kpi.active == menu && menu_kpi.detail !== undefined) {
        const menuSession = menu_kpi.detail.map(function(item) { return item.menu; });
        if(menuSession.includes(menu)) {
            const id = menu_kpi.detail[menuSession.indexOf(menu)].id;
            <?php if($sebagaiApprover) : ?>
            if(menu == "kpi_team") {
                $('#myTabContent').load('<?= route("kpi.team.detail", ["id" => "'+id+'"]) ?>', function() {
                    $('#loading_tab_content').hide();
                });
            } else if(menu == "approval") {
                $('#myTabContent').load('<?= route("kpi.approval.detail", ["id" => "'+id+'"]) ?>', function() {
                    $('#loading_tab_content').hide();
                });
            } else if(menu == "kpi_saya") {
                $('#myTabContent').load('<?= route("kpi.saya.detail", ["id" => "'+id+'"]) ?>', function() {
                    $('#loading_tab_content').hide();
                });
            }
            <?php else : ?>
            if(menu == "kpi_saya") {
                $('#myTabContent').load('<?= route("kpi.saya.detail", ["id" => "'+id+'"]) ?>', function() {
                    $('#loading_tab_content').hide();
                });
            }
            <?php endif; ?>
        } else {
            callback();
        }
    } else {
        callback();
    }
}

function load_tab_sub_content_init(storage, tab) {
    if(storage.tab === undefined) {
        if(tab == "pengaturan") {
            load_tab_sub_content("bobot");
        } else if(tab == "master") {
            load_tab_sub_content("kinerja");
        } else if(tab == "periode") {
            load_tab_sub_content("target");
        } else if(tab == "approval") {
            load_tab_sub_content("apv_pengajuan");
        }
    } else {
        if(storage.tab['tab_' + tab] === undefined) {
            if(tab == "pengaturan") {
                load_tab_sub_content("bobot");
            } else if(tab == "master") {
                load_tab_sub_content("kinerja");
            } else if(tab == "periode") {
                load_tab_sub_content("target");
            } else if(tab == "approval") {
                load_tab_sub_content("apv_pengajuan");
            }
        } else {
            load_tab_sub_content(storage.tab['tab_' + tab]);
        }
    }
}

function load_tab_sub_content(tab) {
    $('#message_kpi').html('');
    const menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
    $(".sub_tab").removeClass("active text-primary").addClass("text-dark");
    $("#btn_tabs_" + tab).removeClass("text-dark").addClass("active text-primary");
    set_tab_sub_active(menu_kpi, menu_kpi.active, tab);

    $("#tab_content_" + menu_kpi.active).html('');
    $('#loading_tab_sub_content').show();

    // Tab Pengaturan
    if(tab == "bobot") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.pengaturan.bobot') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } else if(tab == "predikat") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.pengaturan.predikat') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } else if(tab == "approver") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.pengaturan.approver') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } 
    
    // Tab Master
    else if(tab == "kinerja") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.master.kinerja') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } else if(tab == "kepribadian") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.master.kepribadian') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } else if(tab == "kedisiplinan") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.master.kedisiplinan') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    }

    // Tab Periode
    else if(tab == "target") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.periode.target') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } else if(tab == "aktual") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.periode.aktual') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } else if(tab == "approval") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.periode.approval') ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    }

    // Tab Approval
    else if(tab == "apv_pengajuan") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.approval.view_data', ['jenis' => 'pengajuan']) ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    } else if(tab == "apv_approved") {
        $("#tab_content_" + menu_kpi.active).load("<?= route('kpi.approval.view_data', ['jenis' => 'approved']) ?>", function() {
            $('#loading_tab_sub_content').hide();
        });
    }


}

function restore_detail(menu, callback) {
    const menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
    if(menu_kpi.active == menu) {
        if(menu_kpi.detail === undefined) {
            callback("home");
        } else {
            const menuSession = menu_kpi.detail.map(function(item) { return item.menu; } );
            if(menuSession.includes(menu)) {
                callback("detail", menu_kpi.detail[menuSession.indexOf(menu)].id);
            } else {
                callback("home");
            }
        }
    } else {
        callback("home");
    }
}

function set_tab_sub_active(storage, tab, active) {
    if(storage.tab === undefined) {
        storage.tab = {['tab_' + tab]: active};
    } else {
        storage.tab['tab_' + tab] = active;
    }
    localStorage.setItem("menu_kpi", JSON.stringify(storage));
}

function set_tab_active(storage, active) {
    $('.nav-link').removeClass("active");
    $("#tab_" + active).addClass("active");
    if(storage == null) {
        localStorage.setItem("menu_kpi", JSON.stringify({ active: "pengaturan" }));
    } else {
        storage.active = active;
        localStorage.setItem("menu_kpi", JSON.stringify(storage));
    }
}

function set_detail_active(menu, id) {
    const menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
    if(menu_kpi.detail === undefined) {
        menu_kpi.detail = [{ menu : menu, id : id}];
        localStorage.setItem("menu_kpi", JSON.stringify(menu_kpi));
    } else {
        const detail      = menu_kpi.detail;
        const menuSession = detail.map(function(item) { return item.menu; });
        if(menuSession.includes(menu)) {
            menu_kpi.detail[menuSession.indexOf(menu)].id = id;
            localStorage.setItem("menu_kpi", JSON.stringify(menu_kpi));
        } else {
            menu_kpi.detail.push({ menu : menu, id : id});
            localStorage.setItem("menu_kpi", JSON.stringify(menu_kpi));
        }
    }

    if(['approval', 'kpi_team'].includes(menu)) {
        menu_kpi.filter = {periode: $('#periode').datepicker('getDate'), page: list_data.page(), length: list_data.page.len()};
        if($('#karyawan').val() !== null) {
            menu_kpi.filter.karyawan = {value: $('#karyawan').val(), selected: $('#karyawan').select2()[0].textContent};
        }
        localStorage.setItem("menu_kpi", JSON.stringify(menu_kpi));
    }
}

function unset_detail(menu) {
    const menu_kpi = JSON.parse(localStorage.getItem("menu_kpi"));
    if(menu_kpi.detail !== undefined) {
        const detail      = menu_kpi.detail;
        const menuSession = detail.map(function(item) { return item.menu; });
        if(menuSession.includes(menu)) {
            menu_kpi.detail.splice(menuSession.indexOf(menu), 1);
            localStorage.setItem("menu_kpi", JSON.stringify(menu_kpi));
        }
    }
}
</script>
<?php include('user/team/js.php') ?>
<?php include('user/approval/js.php') ?>
<?php include('user/saya/js.php') ?>