<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Group_area_m extends CI_Model
{
    var $table = 'sales_group_m';

    function get_datatables(){
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("
            id_group_m,
            kode,
            nama
        ")
            ->from($this->table)
            ->where("id_company", $this->id_company);

        $column_search = array('nama');
        $i = 0;
        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        // $column_order = array('', 'kode', 'nama', 'flag');
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("no_urut" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id = null){
        $query = $this->db->select("
                id_group_m,
                kode,
                nama
            ")
            ->from($this->table)
            ->where("id_company", $this->id_company)
            ->where('MD5(id_group_m)', $id)
            ->get()
            ->row();

        return $query;
    }

    public function save($data = [], $id = ''){
        $cek_kode_group = $this->_cek_kode_group($data['kode'], $id);

        if(!empty($cek_kode_group)){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_group_area_duplicate') . '</font>');
            return __response_save(false, $message);
        }else{
            if(!empty($id)){
                // PROSES UPDATE
                $user_update    = array('tgl_update'     => date("Y-m-d H:i:s"),
                                        'user_update'	=> $this->nik_karyawan. " - ". $this->nm_karyawan);
                $this->db->where("md5(id_group_m)",$id);
                $this->db->where('id_company', $this->id_company);
                $update = $this->db->update($this->table, array_merge($data,$user_update));
                return  __response_update($update);
            }else{
                // PROSES SAVE
                $id         = $this->fungsi->getNextId($this->table, 'id_group_m', $this->id_company, 4);
                $no_urut    = $this->db->select_max('no_urut')
                                    ->where('id_company', $this->id_company)
                                    ->get($this->table)
                                    ->row()
                                    ->no_urut;
    
                $user_input = array(
                        'id_group_m' => $id,
                        'no_urut'    => $no_urut+1,
                        'tgl_input'  => date("Y-m-d H:i:s"),
                        'user_input' => $this->nik_karyawan. " - ". $this->nm_karyawan
                    );
    
                $save = $this->db->insert($this->table, array_merge($data,$user_input));
                return  __response_save($save);
            }
        }
    }

    public function delete($id = null){
        $cek_group_product = $this->_cek_delete($id, 'sales_product_group_m');
        if(!empty($cek_group_product)){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, terdapat goup product yang menggunakan group/area ini</font>');
            return __response_save(false, $message);
        }

        $cek_admin_sales   = $this->_cek_delete($id, 'sales_admin_m');
        if(!empty($cek_admin_sales)){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, terdapat admin sales yang menggunakan group/area ini</font>');
            return __response_save(false, $message);
        }

        $cek_data_sales    = $this->_cek_delete($id, 'sales_approver');
        if(!empty($cek_data_sales)){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, terdapat data sales yang menggunakan group/area ini</font>');
            return __response_save(false, $message);
        }

        $this->db->where('MD5(id_group_m)', $id);
        $this->db->where('id_company', $this->id_company);
        $delete = $this->db->delete($this->table);
        return  __response_delete($delete);
    }

    public function update_order($data){
        $this->db->trans_start();
        $this->db->where('id_company', $this->id_company);
        $this->db->update_batch($this->table, $data, 'concat(id_group_m,id_company)');
        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            return __response_update(true);
        }
    }

    private function _cek_kode_group($kode='', $id=''){
        if(!empty($id)){
            $this->db->where('MD5(id_group_m) !=', $id);
        }

        $query = $this->db->select("kode")
                        ->from($this->table)
                        ->where('id_company', $this->id_company)
                        ->where('kode', $kode)
                        ->get()
                        ->row()
                        ->kode;

        return $query;
    }

    private function _cek_delete($id_group_m="", $nama_tabel=""){
        return $this->db->select('id_group_m')
                        ->from($nama_tabel)
                        ->where("id_company", $this->id_company)
                        ->where("MD5(id_group_m)", $id_group_m)
                        ->get()
                        ->row()
                        ->id_group_m;
    }
}