<?php

if (!function_exists('language_init')) {
    function language_init($lang = '')
    {
        $ci = &get_instance();
        $ci->load->helper('language');
        $siteLang = $lang ?: $ci->session->userdata('site_lang');
        if ($siteLang) {
            $ci->lang->load(array('error_message'), $siteLang);
        } else {
            $ci->lang->load(array('error_message'), 'indonesia');
        }
        return $ci;
    }
}

if (!function_exists('keterangan_action')) {
    function keterangan_action($jenis, $action)
    {
        $init = language_init();
        if ($action == '1') {
            return $init->lang->line('ket_action_pengajuan_tambah') . $jenis;
        } elseif ($action == '2') {
            return $init->lang->line('ket_action_pengajuan_update') . $jenis;
        } elseif ($action == '3') {
            return $init->lang->line('ket_action_pengajuan_hapus') . $jenis;
        }
    }
}

if (!function_exists('data_diri_action')) {
    function data_diri_action()
    {
        $init = language_init();
        return $init->lang->line('data_diri_action_pengajuan_update');
    }
}

if (!function_exists('notif_approval')) {
    function notif_approval($route, $id_karyawan, $judul, $content, $id_ref)
    {
        $CI =& get_instance();
        $init = language_init();
        $ch = curl_init();
        $token_fcm = $init->db->get_where('users', ['id_karyawan' => $id_karyawan])->row()->token_fcm;
        $params_fcm = [
            'token_fcm' => $token_fcm,
            'route'     => '/' . $route,
            'title'     => $judul,
            'body'      => strip_tags($content),
            'id_ref' => $id_ref
        ];

        $params = [
            'params_fcm'   => json_encode($params_fcm),
            'url_consumer' => $init->config->item('url_api') . "/notifikasi/fcm/send",
            'nm_aplikasi' => 'fcm'
        ];
        curl_setopt($ch, CURLOPT_URL, "https://mb-producer.absenku.com/fcm?" . http_build_query($params));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'authentication: absenku123**'
        ]);
        curl_setopt($ch, CURLOPT_USERAGENT, $CI->config->item('user_agent'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec($ch);


        curl_close($ch);
    }
}

if (!function_exists('data_sebelumnya')) {
    function data_sebelumnya($sebelum, $pengajuan, $format = '')
    {
        if ($sebelum != $pengajuan) {
            if ($format != '') {
                $CI = &get_instance();
                $CI->load->library('fungsi');
                if ($format == 'tgl_indo') {
                    if ($sebelum == '0000-00-00') {
                        $sebelum = '-';
                    } else {
                        $sebelum = $CI->fungsi->tgl_indo($sebelum);
                    }
                } elseif ($format == 'd_m_Y') {
                    if ($sebelum == '0000-00-00') {
                        $sebelum = '-';
                    } else {
                        $sebelum = date('d-m-Y', strtotime($sebelum));
                    }
                } elseif ($format == 'jkel') {
                    $sebelum = $CI->fungsi->jkel($sebelum);
                }
            } else {
                if ($sebelum == '') {
                    $sebelum = '-';
                }
            }
            echo '<p class="text-danger"><i>Sebelumnya : ' . $sebelum . '</i></p>';
        }
    }
}

if (!function_exists('data_sebelumnya_update')) {
    function data_sebelumnya_update($sebelum, $pengajuan, $action, $format = '')
    {
        if ($action == '2') {
            $CI = &get_instance();
            $CI->load->helper('approval');
            data_sebelumnya($sebelum, $pengajuan, $format);
        }
    }
}
