<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Download_all extends MY_Controller
{   
    public function __construct()
    {
        parent::__construct();
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel'));
        $this->load->model('sales_activity/report/Data_sales_m');
        $this->load->model('sales_activity/report/Realisasi_nominal_m');
        $this->load->model('sales_activity/report/Realisasi_won_m');
        $this->load->model('sales_activity/report/Aktivitas_m');
        $this->load->model('sales_activity/report/realisasi_poin/Poin_harian_m');
    }

    public function download_semua_modal(){
		$this->load->view('sales_activity/report/form_download_all');
    }

    public function download_semua_action(){
        $filename    = "REPORT SEMUA KATEGORI";
        $periode     = $this->input->get('periode');
        $id_group    = $this->input->get('id_group');
        $nama_group  = $this->input->get('nama_group');
        $id_karyawan = $this->input->get('id_karyawan');

		// Load plugin PHPExcel nya
        include APPPATH . 'third_party/PHPExcel/PHPExcel.php';

        // Panggil class PHPExcel nya
        $excel = new PHPExcel();

        // Settingan awal fil excel
        $excel->getProperties()
            ->setCreator('Absenku')
            ->setLastModifiedBy('Absenku')
            ->setTitle("Report Sales Monitoring")
            ->setSubject("Report Sales Monitoring")
            ->setDescription("Report Sales Monitoring");

        $this->_excel_tab_pipeline($excel, $periode, $id_group, $nama_group, $id_karyawan);
        $this->_excel_tab_nominal($excel, $periode, $id_group, $nama_group, $id_karyawan);
        $this->_excel_tab_po($excel, $periode, $id_group, $nama_group, $id_karyawan);
        $this->_excel_tab_poin($excel, $periode, $id_group, $nama_group, $id_karyawan);
        $this->_excel_tab_aktivitas($excel, $periode, $id_group, $nama_group, $id_karyawan);
        $excel->setActiveSheetIndex(0);

        // Proses file excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename=' . $filename . '.xlsx'); // Set nama file excel nya
        header('Cache-Control: max-age=0');
        $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $write->save('php://output');
    }

    // 1. TAB PIPELINE
    private function _excel_tab_pipeline($excel, $periode, $id_group, $nama_group, $id_karyawan){        
        $tahapan_trx = $this->Data_sales_m->get_tahapan_trx($periode);
        $list        = $this->Data_sales_m->get_datatables($periode, $id_karyawan, $nama_group);

        $excel->setActiveSheetIndex(0);
        $sheet = $excel->getActiveSheet();

        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle("Pipeline");

        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );

        // set width
        $sheet->getColumnDimension('A')->setWidth(5);
        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(30);
        
        // start header title
        $merge_header_title = 2 + (COUNT($tahapan_trx) * 2 );
        $columnName_header = $this->getColumnName($merge_header_title);

        $sheet->setCellValue('A1', "REPORT PIPELINE"); 
        $sheet->mergeCells('A1:'. $columnName_header. '1');
        $sheet->getStyle('A1')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
        
        $bulan    = $this->fungsi->get_bulan($periode);
        $tahun    = $this->fungsi->get_tahun($periode);
        $sheet->setCellValue('A2', strtoupper($bulan) . " " . $tahun);
        $sheet->mergeCells('A2:'. $columnName_header. '2');
        $sheet->getStyle('A2')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        // start header table
        $sheet->setCellValue('A4', "NO");
        $sheet->setCellValue('B4', "NIK");
        $sheet->setCellValue('C4', "NAMA KARYAWAN");
        $sheet->mergeCells('A4:A5');
        $sheet->mergeCells('B4:B5');
        $sheet->mergeCells('C4:C5');

        if(COUNT($tahapan_trx) > 0){
            $i = 3;
            foreach ($tahapan_trx as $tahapan) {
                $columnName_i1 = $this->getColumnName($i);
                $columnName_i2 = $this->getColumnName($i+1);
                
                $sheet->getColumnDimension($columnName_i1)->setWidth(10);
                $sheet->getColumnDimension($columnName_i2)->setWidth(15);

                $sheet->mergeCells($columnName_i1. '4:'. $columnName_i2. '4');

                $sheet->setCellValue($columnName_i1 .'4', strtoupper($tahapan->nama));
                $sheet->setCellValue($columnName_i1. '5', "JUMLAH");
                $sheet->setCellValue($columnName_i2. '5', "NOMINAL");

                $i++;
                $i++;
            }
        }else{
            $sheet->getColumnDimension('D')->setWidth(10);
            $sheet->getColumnDimension('E')->setWidth(15);

            $sheet->setCellValue('D4', "-");
            $sheet->setCellValue('D5', "JUMLAH");
            $sheet->setCellValue('E5', "NOMINAL");
            
            $sheet->mergeCells('D4:E4');
        }

        // fill the data
        $no     = 1;
        $numrow = 6;
        $total  = array();
        foreach($list as $field){
            $sheet->setCellValue('A'.$numrow, $no);
            $sheet->setCellValue('B'.$numrow, $field->nik);
            $sheet->setCellValue('C'.$numrow, $field->nama_lengkap);

            if (COUNT($tahapan_trx) > 0) {
                $i = 3;
                foreach ($tahapan_trx as $tahapan) {
                    $columnName_i1       = $this->getColumnName($i);
                    $columnName_i2       = $this->getColumnName($i+1);
                    $var_nominal_layanan = "nominal___" . $tahapan->id_tahapan_m;
                    $var_jumlah_po       = "jumlah_po___" . $tahapan->id_tahapan_m;
    
                    $sheet->setCellValue($columnName_i1 .''.$numrow, $field->$var_jumlah_po);
                    $sheet->setCellValue($columnName_i2 .''.$numrow, $field->$var_nominal_layanan);
    
                    $sheet->getStyle($columnName_i2. $numrow)->getNumberFormat()->setFormatCode('#,##0');
                    $sheet->getStyle($columnName_i2. $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                    
                    $total[$tahapan->id_tahapan_m]['jumlah'] += (int)$field->$var_jumlah_po;
                    $total[$tahapan->id_tahapan_m]['nominal'] += (int)$field->$var_nominal_layanan;

                    $i++;
                    $i++;
                }

            }else{
                $sheet->setCellValue('D'.$numrow, "-");
                $sheet->setCellValue('E'.$numrow, "-");
            }

            $no++; 
            $numrow++;
        }

        // bold kolom
        $columnName_i2 = !empty($columnName_i2) ? $columnName_i2 : "E";

        $sheet->getStyle("A4:". $columnName_i2. "5")
            ->applyFromArray($style_header);
        $sheet->getStyle('A'. $numrow. ':'.$columnName_i2. $numrow)
            ->applyFromArray($style_header);

        // border kolom
        $sheet->getStyle("A4:". $columnName_i2. $numrow)
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );
        
        // footer total
        $sheet->mergeCells('A'. $numrow. ':C'. $numrow);
        $sheet->setCellValue('A'. $numrow, "TOTAL");
        if (COUNT($tahapan_trx) > 0) {
            $i = 3;
            foreach ($tahapan_trx as $tahapan) {
                $columnName_i1       = $this->getColumnName($i);
                $columnName_i2       = $this->getColumnName($i+1);

                $sheet->setCellValue($columnName_i1.$numrow, $total[$tahapan->id_tahapan_m]['jumlah']);
                $sheet->setCellValue($columnName_i2.$numrow, $total[$tahapan->id_tahapan_m]['nominal']);

                $sheet->getStyle($columnName_i2. $numrow)->getNumberFormat()->setFormatCode('#,##0');
                $sheet->getStyle($columnName_i2. $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);


                $i++;
                $i++;
            }
        }else{
            $sheet->setCellValue('D'.$numrow, "-");
            $sheet->setCellValue('E'.$numrow, "-");
        }

        // set align column
        $sheet->getStyle('B4'. ':C'.($numrow-1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        // freeze column
        $sheet->freezePane('D6');
        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $sheet->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
    }

    // 2. TAB NOMINAL
    private function _excel_tab_nominal($excel, $periode, $id_group, $nama_group, $id_karyawan){
        $tahun                = explode('-', $periode)[1];
        $list                 = $this->Realisasi_nominal_m->get_datatables($tahun, $id_group, $id_karyawan);
        $target_personil      = $this->Realisasi_nominal_m->get_target_personil($tahun, $id_group, $id_karyawan);
        $targ_tahunan_bulanan = $this->Realisasi_nominal_m->get_target_tahunan_bulanan($tahun, $id_group);

        $excel->createSheet();
        $excel->setActiveSheetIndex(1);
        $sheet = $excel->getActiveSheet();

        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle("Nominal");

        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );

        // set width
        $sheet->getColumnDimension('A')->setWidth(5);
        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(30);

        // start header title
        $merge_header_title = 2 + (12 * 2 );
        $columnName_header = $this->getColumnName($merge_header_title);

        $sheet->setCellValue('A1', "REPORT NOMINAL"); 
        $sheet->mergeCells('A1:'. $columnName_header. '1');
        $sheet->getStyle('A1')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
        
        $tahun    = $this->fungsi->get_tahun($periode);
        $sheet->setCellValue('A2',"TAHUN " . $tahun);
        $sheet->mergeCells('A2:'. $columnName_header. '2');
        $sheet->getStyle('A2')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        // start header table
        $sheet->setCellValue('A4', "NO");
        $sheet->setCellValue('B4', "NIK");
        $sheet->setCellValue('C4', "NAMA KARYAWAN");
        $sheet->mergeCells('A4:A5');
        $sheet->mergeCells('B4:B5');
        $sheet->mergeCells('C4:C5');

        $array_bulan_short = $this->lang->line('array_bulan');
        $months            = str_replace(["[", "]", "'"], "", $array_bulan_short);
        $months_array      = explode(", ", $months);

        $i = 3;
        foreach ($months_array as $value) {
            $columnName_i1 = $this->getColumnName($i);
            $columnName_i2 = $this->getColumnName($i+1);

            $sheet->getColumnDimension($columnName_i1)->setWidth(15);
            $sheet->getColumnDimension($columnName_i2)->setWidth(15);

            $sheet->setCellValue($columnName_i1 .'4', strtoupper($value));
            $sheet->setCellValue($columnName_i1. '5', "TARGET");
            $sheet->setCellValue($columnName_i2. '5', "REALISASI");

            $sheet->mergeCells($columnName_i1. '4:'. $columnName_i2. '4');

            $i++;
            $i++;
        }

        // fill the data
        $no     = 1;
        $numrow = 6;
        $total  = array();
        foreach($list as $field){
            $sheet->setCellValue('A'.$numrow, $no);
            $sheet->setCellValue('B'.$numrow, $field->nik);
            $sheet->setCellValue('C'.$numrow, $field->nama_lengkap);

            $j = 3;
            for ($i = 1; $i <= 12; $i++) {
                $columnName_j1       = $this->getColumnName($j);
                $columnName_j2       = $this->getColumnName($j+1);

                $key_target = $field->id_karyawan . $tahun . sprintf("%02d", $i) . $this->id_company;
                $res        = array_search($key_target, array_column($target_personil, 'key_target'));
                $res        = ($res !== false) ? $target_personil[$res] : null;
    
                $nominal_target  = !empty($res['nominal_target']) ? $res['nominal_target'] : '0';
                $sheet->setCellValue($columnName_j1 .''.$numrow, $nominal_target);
                
                $nominal_realisasi  = !empty($res['nominal_realisasi']) ? $res['nominal_realisasi'] : '0';
                $sheet->setCellValue($columnName_j2 .''.$numrow, $nominal_realisasi);

                $sheet->getStyle($columnName_j1. $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                $sheet->getStyle($columnName_j2. $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                $sheet->getStyle($columnName_j1. $numrow)->getNumberFormat()->setFormatCode('#,##0');
                $sheet->getStyle($columnName_j2. $numrow)->getNumberFormat()->setFormatCode('#,##0');

                $total[sprintf("%02d", $i)]['target']    += $nominal_target;
                $total[sprintf("%02d", $i)]['realisasi'] += $nominal_realisasi;
                
                $j++;
                $j++;
            }
            
            $no++; 
            $numrow++;
        }

        // footer total target personil
        $sheet->mergeCells('A'. $numrow. ':C'. $numrow);
        $sheet->mergeCells('A'. ($numrow+1). ':C'. ($numrow+1));
        $sheet->mergeCells('A'. ($numrow+2). ':C'. ($numrow+2));
        $sheet->mergeCells('A'. ($numrow+3). ':C'. ($numrow+3));

        $sheet->setCellValue('A'. $numrow, "TOTAL TARGET PERSONIL");
        $sheet->setCellValue('A'. ($numrow+1), "TARGET BULANAN");
        $sheet->setCellValue('A'. ($numrow+2), "TARGET KUARTAL");
        $sheet->setCellValue('A'. ($numrow+3), "TARGET TAHUNAN");

        $j = 3;
        for ($i = 1; $i <= 12; $i++) {
            $columnName_j1       = $this->getColumnName($j);
            $columnName_j2       = $this->getColumnName($j+1);

            $t_target    = $total[sprintf("%02d", $i)]['target'];
            $t_realisasi = $total[sprintf("%02d", $i)]['realisasi'];
            $sheet->setCellValue($columnName_j1 .''.$numrow, $t_target);
            $sheet->setCellValue($columnName_j2 .''.$numrow, $t_realisasi);

            $t_bulanan = $targ_tahunan_bulanan[sprintf("%02d", $i)]['bulanan'];
            $t_kuartal = $targ_tahunan_bulanan[sprintf("%02d", $i)]['kuartal'];
            $t_tahunan = $targ_tahunan_bulanan[sprintf("%02d", $i)]['tahunan'];
            $sheet->setCellValue($columnName_j1 .''.($numrow+1), $t_bulanan);
            $sheet->setCellValue($columnName_j1 .''.($numrow+2), $t_kuartal);
            $sheet->setCellValue($columnName_j1 .''.($numrow+3), $t_tahunan);

            $sheet->mergeCells($columnName_j1.($numrow+1). ':'. $columnName_j2.($numrow+1));
            $sheet->mergeCells($columnName_j1.($numrow+2). ':'. $columnName_j2.($numrow+2));
            $sheet->mergeCells($columnName_j1.($numrow+3). ':'. $columnName_j2.($numrow+3));

            $j++;
            $j++;
        }

        // bold kolom
        $sheet->getStyle("A4:". $columnName_j2. "5")
            ->applyFromArray($style_header);
        $sheet->getStyle('A'. $numrow. ':'.$columnName_j2.($numrow+3))
            ->applyFromArray($style_header);

        // border kolom
        $sheet->getStyle("A4:". $columnName_j2.($numrow+3))
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );

        // set align column
        $sheet->getStyle('B4'. ':C'.($numrow-1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('D6:'. $columnName_j2.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        
        // format number column
        $sheet->getStyle('D6:'. $columnName_j2.($numrow+3))->getNumberFormat()->setFormatCode('#,##0');
        
        // freeze column
        $sheet->freezePane('D6');

        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $sheet->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
    }

    // 3. TAB PO
    private function _excel_tab_po($excel, $periode, $id_group, $nama_group, $id_karyawan){
        list($bulan, $tahun) = explode("-", $periode);
        $tanggal_mulai   = $tahun . "-" . $bulan . "-01";
        $tanggal_selesai = date("Y-m-t", strtotime($tanggal_mulai));
        $list            = $this->Realisasi_won_m->get_datatables($tanggal_mulai, $tanggal_selesai, $id_group, $id_karyawan);

        $excel->createSheet();
        $excel->setActiveSheetIndex(2);
        $sheet = $excel->getActiveSheet();

        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle("PO");

        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );

        // set width
        $sheet->getColumnDimension('A')->setWidth(5);
        $sheet->getColumnDimension('B')->setWidth(12);
        $sheet->getColumnDimension('C')->setWidth(16);
        $sheet->getColumnDimension('D')->setWidth(25);
        $sheet->getColumnDimension('E')->setWidth(15);
        $sheet->getColumnDimension('F')->setWidth(30);
        $sheet->getColumnDimension('G')->setWidth(30);
        $sheet->getColumnDimension('H')->setWidth(30);
        $sheet->getColumnDimension('I')->setWidth(20);
        $sheet->getColumnDimension('J')->setWidth(20);
        $sheet->getColumnDimension('K')->setWidth(16);
        $sheet->getColumnDimension('L')->setWidth(18);

        // start header title
        $sheet->setCellValue('A1', "REPORT PO"); 
        $sheet->mergeCells('A1:L1');
        $sheet->getStyle('A1')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
        
        // start header table
        $bulan    = $this->fungsi->get_bulan($periode);
        $tahun    = $this->fungsi->get_tahun($periode);
        $sheet->setCellValue('A2', strtoupper($bulan) . " " . $tahun);
        $sheet->mergeCells('A2:L2');
        $sheet->getStyle('A2')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $sheet->setCellValue('A4', "NO");
        $sheet->setCellValue('B4', "TANGGAL");
        $sheet->setCellValue('C4', "NIK");
        $sheet->setCellValue('D4', "SALES");
        $sheet->setCellValue('E4', "NOMINAL");
        $sheet->setCellValue('F4', "PRODUK");
        $sheet->setCellValue('G4', "PELANGGAN");
        $sheet->setCellValue('H4', "TITLE");
        $sheet->setCellValue('I4', "KATEGORI");
        $sheet->setCellValue('J4', "JENIS");
        $sheet->setCellValue('K4', "LEAD SOURCE");
        $sheet->setCellValue('L4', "LAMA CLOSING");

        // fill the data
        $no          = 1;
        $numrow      = 5;
        foreach($list as $field){
            $sheet->setCellValue('A'.$numrow, $no);
            $sheet->setCellValue('B'.$numrow, date_format(date_create($field->tgl_approve), "d-m-Y"));
            $sheet->setCellValue('C'.$numrow, $field->nik);
            $sheet->setCellValue('D'.$numrow, $field->nama_karyawan);
            $sheet->setCellValue('E'.$numrow, $field->nominal_layanan);
            $sheet->setCellValue('F'.$numrow, $field->nama_product);
            $sheet->setCellValue('G'.$numrow, $field->nama_perusahaan);
            $sheet->setCellValue('H'.$numrow, $field->title);
            $sheet->setCellValue('I'.$numrow, ucwords($field->kategori_pelanggan));
            $sheet->setCellValue('J'.$numrow, $field->jenis_perusahaan);
            $sheet->setCellValue('K'.$numrow, ucwords($field->nama_lead));
            
            $lama_closing = timespan(strtotime($field->tgl_input_main), strtotime($field->tgl_approve), 2);
            $sheet->setCellValue('L'.$numrow, $lama_closing);

            $no++; 
            $numrow++;
        }

        // bold kolom
        $sheet->getStyle("A4:L4")->applyFromArray($style_header);

        // set align column
        $sheet->getStyle('C4'. ':D'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('E5'. ':E'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $sheet->getStyle('F5'. ':H'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('I5'. ':I'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle('J5'. ':J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $sheet->getStyle('K5'. ':K'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        // format number column
        $sheet->getStyle('E5:E'. $numrow)->getNumberFormat()->setFormatCode('#,##0');

        // border kolom
        $sheet->getStyle("A4:L".($numrow-1))
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );
        
    }

    // 4. TAB POIN
    private function _excel_tab_poin($excel, $periode, $id_group, $nama_group, $id_karyawan){
        list($bulan, $tahun) = explode("-", $periode);
        $tanggal_mulai       = $tahun . "-" . $bulan . "-01";
        $tanggal_selesai     = date("Y-m-t", strtotime($tanggal_mulai));
        $id_karyawan         = !empty($id_karyawan) ? $id_karyawan : "all";

        $header        = $this->_buat_tabel_header($tanggal_mulai, $tanggal_selesai);
        $get_absensi   = $this->Poin_harian_m->get_absensi($tanggal_mulai, $tanggal_selesai, $id_karyawan);
        $get_target    = $this->Poin_harian_m->get_poin_target($tanggal_mulai, $tanggal_selesai, $id_group ,$id_karyawan);
        $get_realisasi = $this->Poin_harian_m->get_poin_realisasi($tanggal_mulai, $tanggal_selesai, $id_group ,$id_karyawan);
        $list          = $this->Poin_harian_m->get_datatables($tanggal_mulai, $tanggal_selesai, $id_group ,$id_karyawan);

        $excel->createSheet();
        $excel->setActiveSheetIndex(3);
        $sheet = $excel->getActiveSheet();
        
        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle("Poin");

        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );

        // set width
        $sheet->getColumnDimension('A')->setWidth(5);
        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(30);
        
        // start header title
        $merge_header_title = 4 + (COUNT($header) * 2 );
        $columnName_header = $this->getColumnName($merge_header_title);

        $sheet->setCellValue('A1', "REPORT POIN"); 
        $sheet->mergeCells('A1:'. $columnName_header. '1');
        $sheet->getStyle('A1')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
        
        $bulan    = $this->fungsi->get_bulan($periode);
        $tahun    = $this->fungsi->get_tahun($periode);
        $sheet->setCellValue('A2', strtoupper($bulan) . " " . $tahun);
        $sheet->mergeCells('A2:'. $columnName_header. '2');
        $sheet->getStyle('A2')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        // start header table
        $sheet->setCellValue('A4', "NO");
        $sheet->setCellValue('B4', "NIK");
        $sheet->setCellValue('C4', "NAMA KARYAWAN");
        $sheet->mergeCells('A4:A5');
        $sheet->mergeCells('B4:B5');
        $sheet->mergeCells('C4:C5');

        $i = 3;
        foreach ($header as $row) {
            $columnName_i1 = $this->getColumnName($i);
            $columnName_i2 = $this->getColumnName($i+1);

            $sheet->mergeCells($columnName_i1. '4:'. $columnName_i2. '4');

            $sheet->setCellValue($columnName_i1 .'4', strtoupper($row));
            $sheet->setCellValue($columnName_i1. '5', "TARGET");
            $sheet->setCellValue($columnName_i2. '5', "REALISASI");

            // set width
            $sheet->getColumnDimension($columnName_i1)->setWidth(12);
            $sheet->getColumnDimension($columnName_i2)->setWidth(12);
            
            $i++;
            $i++;
        }

        $columnName_i1 = $this->getColumnName($i);
        $columnName_i2 = $this->getColumnName($i+1);
        $sheet->setCellValue($columnName_i1 .'4', "TOTAL");
        $sheet->setCellValue($columnName_i1. '5', "TARGET");
        $sheet->setCellValue($columnName_i2. '5', "REALISASI");
        $sheet->mergeCells($columnName_i1. '4:'. $columnName_i2. '4');

        // set width
        $sheet->getColumnDimension($columnName_i1)->setWidth(12);
        $sheet->getColumnDimension($columnName_i2)->setWidth(12);
        
        // fill the data
        $awal     = date_create($tanggal_mulai);
        $akhir    = date_create(date('Y-m-d', strtotime('+1 days ' . $tanggal_selesai)));
        $interval = DateInterval::createFromDateString('1 day');
        $period   = new DatePeriod($awal, $interval, $akhir);

        $no     = 1;
        $numrow = 6;
        foreach($list as $field){
            $sheet->setCellValue('A'.$numrow, $no);
            $sheet->setCellValue('B'.$numrow, $field->nik);
            $sheet->setCellValue('C'.$numrow, $field->nama_karyawan);

            $i               = 3;
            $total_target    = 0;
            $total_realisasi = 0;
            foreach ($period as $dt) {
                $columnName_i1 = $this->getColumnName($i);
                $columnName_i2 = $this->getColumnName($i+1);

                $jenis_absen = $get_absensi[$field->id_karyawan][$dt->format('Y-m-d')]['jenis_absen'];

                if (empty($jenis_absen)) {
                    $target_poin   = $get_target[$field->id_karyawan][$dt->format('Y-m-d')]['target_poin'];
                    $target_poin   = !empty($target_poin) ? $target_poin : 0;
                    $total_target += $target_poin;

                    $total_poin       = 0;
                    $total_realisasi += 0;
                } else if (in_array($jenis_absen, ['reguler', 'shift', 'alpha'])) {
                    $target_poin   = $get_target[$field->id_karyawan][$dt->format('Y-m-d')]['target_poin'];
                    $target_poin   = !empty($target_poin) ? $target_poin : 0;
                    $total_target += $target_poin;

                    $total_poin       = $get_realisasi[$field->id_karyawan][$dt->format('Y-m-d')]['total_poin'];
                    $total_poin       = !empty($total_poin) ? $total_poin : 0;
                    $total_realisasi += $total_poin;
                } else {
                    $kode_absen  = $get_absensi[$field->id_karyawan][$dt->format('Y-m-d')]['kode_absen'];
                    $target_poin = $kode_absen;
                    $total_poin  = $kode_absen;

                    // kasih warna merah
                    $style_color = $sheet->getStyle($columnName_i1.$numrow. ':'. $columnName_i2.$numrow);
                    $style_color->getFill()
                        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                        ->getStartColor()->setRGB('FF7588');

                    $total_target    += 0;
                    $total_realisasi += 0;
                }

                // kolom total di paling kanan
                $sheet->setCellValue($columnName_i1 .''.$numrow, $target_poin);
                $sheet->setCellValue($columnName_i2 .''.$numrow, $total_poin);

                $i++;
                $i++;
            }

            $columnName_i1 = $this->getColumnName($i);
            $columnName_i2 = $this->getColumnName($i+1);
            $sheet->setCellValue($columnName_i1.$numrow, $total_target);
            $sheet->setCellValue($columnName_i2.$numrow, $total_realisasi);

            $numrow++;
        }

        // bold kolom
        $sheet->getStyle("A4:". $columnName_i2. "5")->applyFromArray($style_header);
        $sheet->getStyle($columnName_i1. '4:'.$columnName_i2.$numrow)->applyFromArray($style_header);

        // border kolom
        $sheet->getStyle("A4:". $columnName_i2. ($numrow-1))
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );

        // set align column
        $sheet->getStyle('B4'. ':C'.($numrow-1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        // freeze column
        $sheet->freezePane('D6');
        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $sheet->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
    }

    // 5. TAB AKTIVITAS
    private function _excel_tab_aktivitas($excel, $periode, $id_group, $nama_group, $id_karyawan){
        list($bulan, $tahun) = explode("-", $periode);
        $tanggal_mulai       = $tahun . "-" . $bulan . "-01";
        $tanggal_selesai     = date("Y-m-t", strtotime($tanggal_mulai));
        $id_karyawan         = !empty($id_karyawan) ? $id_karyawan : "all";

        $list          = $this->Aktivitas_m->get_datatables($tanggal_mulai, $tanggal_selesai, $id_group, $id_karyawan);
        $table_header  = $this->Aktivitas_m->table_header($tanggal_mulai, $tanggal_selesai, $id_group);
        $get_aktivitas = $this->Aktivitas_m->get_total_activity($tanggal_mulai, $tanggal_selesai, $id_group, $id_karyawan);

        $excel->createSheet();
        $excel->setActiveSheetIndex(4);
        $sheet = $excel->getActiveSheet();

        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );

        // setup sheet
        $sheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        $sheet->setTitle("Aktivitas");

        // set width
        $sheet->getColumnDimension('A')->setWidth(5);
        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(30);

        // start header title
        $merge_header_title = 2 + COUNT($table_header);
        $columnName_header = $this->getColumnName($merge_header_title);

        $sheet->setCellValue('A1', "REPORT AKTIVITAS"); 
        $sheet->mergeCells('A1:'. $columnName_header. '1');
        $sheet->getStyle('A1')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
        
        $bulan    = $this->fungsi->get_bulan($periode);
        $tahun    = $this->fungsi->get_tahun($periode);
        $sheet->setCellValue('A2', strtoupper($bulan) . " " . $tahun);
        $sheet->mergeCells('A2:'. $columnName_header. '2');
        $sheet->getStyle('A2')->getFont()->setBold(TRUE)->setSize(11); 
        $sheet->getStyle('A2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        // start header table
        $sheet->setCellValue('A4', "NO");
        $sheet->setCellValue('B4', "NIK");
        $sheet->setCellValue('C4', "NAMA KARYAWAN");
        $sheet->setCellValue('D4', "NAMA AKTIVITAS");
        $sheet->mergeCells('A4:A5');
        $sheet->mergeCells('B4:B5');
        $sheet->mergeCells('C4:C5');

        $i = 3;
        foreach ($table_header as $header) {
            $columnName = $this->getColumnName($i);

            $sheet->getColumnDimension($columnName)->setWidth(18);
            $sheet->setCellValue($columnName .'5', strtoupper($header->nama_aktivitas));
            
            $i++;
        }

        $sheet->mergeCells('D4:'. $columnName. '4');

        // fill the data
        $no     = 1;
        $numrow = 6;
        foreach($list as $field){
            $sheet->setCellValue('A'.$numrow, $no);
            $sheet->setCellValue('B'.$numrow, $field->nik);
            $sheet->setCellValue('C'.$numrow, $field->nama_lengkap);

            $i = 3;
            foreach($table_header AS $header){
                $columnName      = $this->getColumnName($i);
                $total_aktivitas = $get_aktivitas[$field->id_karyawan][$header->nama_aktivitas]['total'];
                $t_aktivitas     = !empty($total_aktivitas) ? $total_aktivitas : 0;

                $sheet->setCellValue($columnName.$numrow, $t_aktivitas);
                $i++;
            }

            $numrow++;
        }
        
        // footer total
        $sheet->mergeCells('A'. $numrow. ':C'. $numrow);
        $sheet->setCellValue('A'. $numrow, "TOTAL AKTIVITAS");
        $i = 3;
        foreach($table_header AS $header){
            $columnName      = $this->getColumnName($i);
            $total_aktivitas = $get_aktivitas['total_aktivitas_all'][$header->nama_aktivitas];
            $t_aktivitas     = !empty($total_aktivitas) ? $total_aktivitas : 0;

            $sheet->setCellValue($columnName.$numrow, $t_aktivitas);
            $i++;
        }

        // bold kolom
        $columnName = !empty($columnName) ? $columnName : "C";
        $sheet->getStyle("A4:". $columnName. "5")->applyFromArray($style_header);
        $sheet->getStyle('A'. $numrow. ':'.$columnName. $numrow)->applyFromArray($style_header);

        // border kolom
        $sheet->getStyle("A4:". $columnName. $numrow)
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );

        // set align column
        $sheet->getStyle('B4'. ':C'.($numrow-1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        // freeze column
        $sheet->freezePane('D6');
        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $sheet->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $sheet->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
    }

    public function dropdown_group(){
        $search      = $this->input->get("q");
        $periode     = $this->input->get("periode");
        $periode_arr = explode('-', $periode);
        $bulan       = $periode_arr[0];
        $tahun       = $periode_arr[1];

        // Binding Tahun
        $binding[] = $bulan;
        $binding[] = $tahun;

        // Binding Search
        if(!empty($search)){
            $binding[]    = "%".$search."%";
            $where_search = "WHERE combined.nama_group LIKE ?";
        }else{
            $where_search = "";
        }
        
        // Query jika admin sales
        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                if(!empty($where_search)){
                    $where_adm = "AND combined.id_group_m IN ('" . str_replace(',', "', '", $this->sales_admin_group) . "')";
                }else{
                    $where_adm = "WHERE combined.id_group_m IN ('" . str_replace(',', "', '", $this->sales_admin_group) . "')";
                }
            }
        }else{
            $where_adm = "";
        }

        $sql = "
            SELECT * FROM (
                SELECT
                    id_group_m,
                    CONCAT(kode, ' - ', nama) AS nama_group
                FROM sales_group_m 
                WHERE id_company = '" . $this->id_company . "'

                UNION ALL

                SELECT 
                    id_group_m,
                    nama_group 
                FROM sales_pipeline_trx
                WHERE id_company = '" . $this->id_company . "'
                AND bulan = ?
                AND tahun = ?
                AND id_group_m != ''
                GROUP BY id_group_m
            ) AS combined
            ".$where_search."
            ".$where_adm."
            GROUP BY combined.id_group_m
            ORDER BY combined.nama_group ASC
        ";

        $result = $this->db->query($sql, $binding)->result();

        $json = [];
        foreach ($result as $rows) {
            $json[] = [
                'id'         => $rows->id_group_m,
                'text'       => $rows->nama_group,
                'nama_group' => $rows->nama_group,
            ];
        }
        echo json_encode($json);
    }

    public function dropdown_karyawan(){
        $search      = $this->input->get("q");
        $periode     = $this->input->get("periode");
        $periode_arr = explode('-', $periode);
        $bulan       = $periode_arr[0];
        $tahun       = $periode_arr[1];
        $id_group    = $this->input->get("id_group");

        # 1. Binding Filter Id Group
        if($id_group != "all"){
            $where = " AND id_group_m  = ?";
            $binding[] = $id_group;
            $binding[] = $id_group;
        }else{
            $where = "";
        }

        # 2. Filter Jika Admin Sales
        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $where .= "AND id_group_m IN ('" . str_replace(',', "', '", $this->sales_admin_group) . "')";
            }
        }

        # 3. Binding Tahun & Bulan
        $binding[] = $bulan;
        $binding[] = $tahun;

        // 4. Binding Search
        if(!empty($search)){
            $binding[]    = "%".$search."%";
            $where_search = "WHERE combined.nama_karyawan LIKE ?";
        }else{
            $where_search = "";
        }
        
        $sql = "SELECT
                    id_karyawan,
                    nama_karyawan,
                    id_group_m
                FROM(
                    SELECT 	
                        dk.id_karyawan,
                        CONCAT(dk.nik, ' - ', dk.nama_lengkap) AS nama_karyawan,
                        sa.id_group_m
                    FROM sales_approver AS sa
                    JOIN data_karyawan AS dk
                        ON sa.id_karyawan = dk.id_karyawan
                    WHERE dk.id_company = ".$this->id_company."
                    AND sa.status = '1'
                    ".$where."

                    UNION ALL
                    
                    SELECT
                        id_karyawan,
                        CONCAT(nik, ' - ', nama_karyawan) AS nama_karyawan,
                        id_group_m                    
                    FROM sales_pipeline_trx
                    WHERE id_company = ".$this->id_company."
                    AND bulan = ?
                    AND tahun = ?
                    ".$where."
                    GROUP BY id_karyawan
                ) AS combined
                ".$where_search."
                GROUP BY combined.id_karyawan
            ";

        $result = $this->db->query($sql, $binding)->result();
        
        $json = [];
        foreach ($result as $rows) {
            $json[] = [
                'id'            => $rows->id_karyawan,
                'text'          => $rows->nama_karyawan,
                'nama_karyawan' => $rows->nama_karyawan,
            ];
        }
        echo json_encode($json);
    }

    private function getColumnName($index)
    {
        $letters = '';
        while ($index >= 0) {
            $letters = chr($index % 26 + 65) . $letters;
            $index = intdiv($index, 26) - 1;
        }
        return $letters;
    }

    private function _buat_tabel_header($mulai, $selesai)
    {
        $akhir   = date_create($selesai);
        $awal    = date_create($mulai);
        $selisih = date_diff($akhir, $awal)->format("%a");
        $hasil   = array();
        $d       = "d M";

        $akhir    = date_create(date('Y-m-d', strtotime('+1 days ' . $selesai)));
        $interval = DateInterval::createFromDateString('1 day');
        $period   = new DatePeriod($awal, $interval, $akhir);
        foreach ($period as $dt) {
            $hasil[] = indo_date($dt->format("Y-m-d"), $d);
        }
        return $hasil;
    }
}