<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Jenis_pelanggan extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('sales_activity/demografi_pelanggan/Jenis_pelanggan_m', 'model');
    }

    public function list_data(){
        $tahun           = $this->input->get('tahun');
        $bulan           = $this->input->get('bulan');
        $id_group_m      = $this->input->get('id_group_m');
        $jenis_pelanggan = $this->input->get('jenis_pelanggan');
        $list            = $this->model->get_datatables($tahun, $bulan, $id_group_m, $jenis_pelanggan);
        $total           = $this->model->get_total_jumlah_dan_nominal($tahun, $bulan, $id_group_m, $jenis_pelanggan);

        $data        = array();
        $no          = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = ucfirst($field->kategori_pelanggan);
            $row[] = $field->jumlah;
            $row[] = number_format($field->nominal, 0,",",".");

            $data[] = $row;
        }
        
        if(!empty($data)){
            $row_total[] = "";
            $row_total[] = "<b>GRAND TOTAL</b>";
            $row_total[] = "<b>". $total->jumlah. "</b>";
            $row_total[] = "<b>". number_format($total->nominal, 0,",","."). "</b>";
            $row_total[] = "_colspan";
            $data[]      = $row_total;
        }
        
        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($tahun, $bulan, $id_group_m, $jenis_pelanggan),
            "recordsFiltered" => $this->model->count_filtered($tahun, $bulan, $id_group_m, $jenis_pelanggan),
            "data"            => $data
        );
    
        $output = __response($this->MY_response, $output);
    
        echo json_encode($output);
    }

    public function download(){
        $tahun           = $this->input->get('tahun');
        $bulan           = $this->input->get('bulan');
        $id_group_m      = $this->input->get('id_group_m');
        $jenis_pelanggan = $this->input->get('jenis_pelanggan');
        $data['tahun']   = $tahun;
        $data['list']    = $this->model->get_datatables($tahun, $bulan, $id_group_m, $jenis_pelanggan);

        if($bulan == "all"){
            $filename      = "DEMOGRAFI PELANGGAN BERDASARKAN JENIS PELANGGAN, Tahun ". $tahun;
            $data['bulan'] = "";
        }else{
            $nama_bulan    = $this->fungsi->konversi_bulan($bulan);
            $filename      = "DEMOGRAFI PELANGGAN BERDASARKAN JENIS PELANGGAN, Tahun ". $tahun. " Bulan ". $nama_bulan;
            $data['bulan'] = "BULAN ". $nama_bulan;
        }

        if($id_group_m == "all"){
            $filename           .= ", SEMUA GROUP";
            $data['nama_group'] = "SEMUA GROUP";
        }else{
            $nama_group          = $this->input->get('nama_group');
            $filename           .= ", ". $nama_group;
            $data['nama_group'] = $nama_group;
        }

        $output  = true;
		$sb_view = $this->load->view('sales_activity/demografi_pelanggan/jenis_pelanggan/download', $data, $output);

        // Format Column
        $format_columns = [
			'A'  => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
			'B'  => ['width' => 70, 'align' => 'left', 'valign' => 'middle'],
			'C'  => ['width' => 12, 'align' => 'center', 'valign' => 'middle'],
			'D'  => ['width' => 20, 'align' => 'right', 'valign' => 'middle', 'format'=>'text', 'rupiah'=>true],
		];

        // Bold Header & Footer Table
        $bold_footer = COUNT($data['list']) + 6;
        $thead       = ['5', strval($bold_footer)];

        $param = [
			'download'    => true,
			'cLength'     => 3,
			'file_name'   => strtoupper($filename),
			'paper_size'  => 'LEGAL',
			'font-size'   => 11,
			'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
			'orientation' => 'landscape',
			'header'      => [
				'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'4' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
			],
			'thead'        => $thead,
			'tbody'        => [
				'start'  => '5',
				'height' => 15,
				'wrap'   => ['B','C','D','E'],
				'column' => $format_columns,
			],
            'align_column_unit' => [
                [   'align' => 'center', 'column' => ['D4'] ]
            ]
        ];
        
        $this->load->library('PHPExcel/Excel');

		if ($output) {
			$this->excel->generateExcel($sb_view, $param);
		} 
		exit;
    }

    public function tabs($tabs = null)
    {   
        switch ($tabs) {
            case "j_pelanggan" :
                $this->load->view('sales_activity/demografi_pelanggan/jenis_pelanggan/home');
                break;
            case "jenis_perusahaan" :
                $this->load->view('sales_activity/demografi_pelanggan/jenis_perusahaan/home');
                break;
            case "jenis_perorangan" :
                $this->load->view('sales_activity/demografi_pelanggan/jenis_perorangan/home');
                break;
            default:
                echo $this->lang->line('data_tidak_ditemukan');
        }
    }
}