<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Riwayat_pendidikan_pengajuan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan/Riwayat_pendidikan_pengajuan_m', 'model');
        $this->load->model('notif_kepegawaian_m', 'notif');
        $this->load->model('riwayat_pendidikan_m');
        $this->load->helper('approval');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'pendidikan_pengajuan';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan_md5 = null)
    {
        $data['id']        = $id_karyawan_md5;
        $data['tab_aktif'] = 'pengajuan';
        $data['tab']       = $this->load->view('karyawan/riwayat_pendidikan/tab', $data, true);
        $this->load->view('karyawan/riwayat_pendidikan/pengajuan/home', $data);
    }

    function form($jenis, $id)
    {
        $data['id'] = md5($id);
        if ($jenis == 'approve') {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_approve', $data);
        } elseif ($jenis == 'hapus') {
            $this->load->view('karyawan/riwayat_pendidikan/pengajuan/form_hapus', $data);
        } else {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_revisi', $data);
        }
    }

    public function list_data($id_karyawan = null)
    {
        $data['pendidikan'] = $this->model->list_data($id_karyawan);
        $get_data           = $this->model->get_data($id_karyawan)->num_rows();
        if ($get_data > 0) {
            $this->load->view('karyawan/riwayat_pendidikan/pengajuan/list_data', $data);
        } else {
            echo $this->lang->line('data_tidak_ditemukan');
        }
    }

    function approve()
    {
        $id = $this->input->get('id');
        $approve = $this->model->approve($id, '2');
        if ($approve) {
            $this->logger->create_log('pendidikan_pengajuan', 'approve', $this->db->last_query());
            $cek_id         = $this->model->cek_id($id);
            $data_pengajuan = $this->model->getDataById($id);
            //mengecek apakah id pendidikan tersebut sudah ada atau belum
            if ($cek_id == 0) {
                //belum memiliki id pendidikan
                $folder_master_transkip = $this->move_file_to_master('transkrip', $id);
                $folder_master_ijazah   = $this->move_file_to_master('ijazah', $id);
                $insert_master          = $this->model->insert_master($id, $folder_master_transkip, $folder_master_ijazah);
                if ($insert_master) {
                    $this->model->insert_history($id, $folder_master_transkip, $folder_master_ijazah);
                    $id_history = $this->db->insert_id();
                    notif_approval('detail_data_pendidikan', $data_pengajuan->row()->id_karyawan, ucwords(keterangan_action($this->lang->line('data_pendidikan'), $data_pengajuan->row()->action)), $this->lang->line('disetujui'), $id_history);
                    notif_kepegawaian($data_pengajuan->row()->id_karyawan, 'data_pendidikan', $id_history, 'tambah', 'setuju');
                    $this->logger->create_log('pendidikan_pengajuan', 'approve insert pendidikan', $this->db->last_query());
                }
            } else {
                //sudah memiliki id pendidikan
                $folder_history_transkip = $this->move_file_to_history('transkrip', $id);
                $folder_history_ijazah   = $this->move_file_to_history('ijazah', $id);
                $insert_history          = $this->model->insert_history($id, $folder_history_transkip, $folder_history_ijazah);
                $id_history              = $this->db->insert_id();
                if ($insert_history) {
                    $this->logger->create_log('pendidikan_pengajuan', 'approve insert histori', $this->db->last_query());
                    $this->model->update_path_foto_history($id, $folder_history_transkip, $folder_history_ijazah);
                    $folder_master_transkip = $this->move_file_to_master('transkrip', $id);
                    $folder_master_ijazah   = $this->move_file_to_master('ijazah', $id);
                    $update_data            = $this->model->update_data($id, $folder_master_transkip, $folder_master_ijazah);
                    if ($update_data) {
                        notif_approval('detail_data_pendidikan', $data_pengajuan->row()->id_karyawan, ucwords(keterangan_action($this->lang->line('data_pendidikan'), $data_pengajuan->row()->action)), $this->lang->line('disetujui'), $id_history);
                        notif_kepegawaian($data_pengajuan->row()->id_karyawan, 'data_pendidikan', $id_history, 'update', 'setuju');
                        $this->logger->create_log('pendidikan_pengajuan', 'approve update data pendidikan', $this->db->last_query());
                    }
                }
            }
            $this->notif->update_flag_baca('data_pendidikan', $data_pengajuan->row()->id_karyawan, $data_pengajuan->row()->id_riwayat_pendidikan);
            $this->model->delete($id);
        }

        __response_approve($approve);
    }

    function hapus()
    {
        $id             = $this->input->get('id');
        $approve        = $this->model->approve($id, '2');
        $data_pengajuan = $this->model->getDataById($id);
        if ($approve) {
            $this->logger->create_log('pendidikan_pengajuan', 'hapus', $this->db->last_query());
            $folder_history_transkip = $this->move_file_to_history_hapus('transkrip', $id);
            $folder_history_ijazah   = $this->move_file_to_history_hapus('ijazah', $id);
            $this->model->insert_history($id, $folder_history_transkip, $folder_history_ijazah);
            $id_history = $this->db->insert_id();
            notif_approval('detail_data_pendidikan', $data_pengajuan->row()->id_karyawan, ucwords(keterangan_action($this->lang->line('data_pendidikan'), $data_pengajuan->row()->action)), $this->lang->line('disetujui'), $id_history);
            notif_kepegawaian($data_pengajuan->row()->id_karyawan, 'data_pendidikan', $id_history, 'hapus', 'setuju');
            $this->model->update_path_foto_history($id, $folder_history_transkip, $folder_history_ijazah);
            $hapus_data = $this->model->hapus_data($id);
            if ($hapus_data) {
                $this->logger->create_log('pendidikan_pengajuan', 'hapus data pendidikan', $this->db->last_query());
            }
            $this->notif->update_flag_baca('data_pendidikan', $data_pengajuan->row()->id_karyawan, $data_pengajuan->row()->id_riwayat_pendidikan);
            $this->model->delete($id);
        }

        __response_delete($approve);
    }

    function move_file_to_history_hapus($jenis, $id)
    {
        //memindahkan file master ke history
        $id_company = $this->session->userdata('id_company');
        $data_temp  = $this->riwayat_pendidikan_m->getDataById($id);
        if ($data_temp->$jenis == '') {
            return '';
        } else {
            //data di master
            $directory      = FCPATH . $this->config->item('base_upload');
            $file_name_temp = pathinfo($data_temp->$jenis);
            $old            = $directory . $data_temp->$jenis;
            $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/riwayat-pendidikan/history');
            $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/riwayat-pendidikan/history/' . $file_name_temp['basename'];
            $new      = $directory . $new_temp;
            rename($old, $new);
            return $new_temp;
        }
    }

    function move_file_to_history($jenis, $id)
    {
        //memindahkan file master ke history
        $id_company            = $this->session->userdata('id_company');
        $data_temp             = $this->riwayat_pendidikan_m->getDataById($id);
        if ($data_temp->$jenis == '') {
            return '';
        } else {
            //data di master
            $data_pengajuan = $this->model->getDataById($id);
            //data di pengajuan
            if ($data_temp->$jenis == $data_pengajuan->row()->$jenis) {
                //jika nama di pengajuan dan di master sama (kondisi untuk edit foto saja)
                $new_temp = $data_temp->$jenis;
            } else {
                $directory      = FCPATH . $this->config->item('base_upload');
                $file_name_temp = pathinfo($data_temp->$jenis);
                $old            = $directory . $data_temp->$jenis;
                $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/riwayat-pendidikan/history');
                $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/riwayat-pendidikan/history/' . $file_name_temp['basename'];
                $new      = $directory . $new_temp;
                rename($old, $new);
            }
            return $new_temp;
        }
    }

    function create_directory($dir)
    {
        if (!file_exists($dir) && !is_dir($dir)) {
            mkdir($dir, 0755, true);
        }
    }

    function move_file_to_master($jenis, $id)
    {
        $id_company = $this->session->userdata('id_company');
        $data_temp  = $this->model->getDataById($id);
        if ($data_temp->row()->$jenis == '') {
            return '';
        } else {
            //data di pengajuan
            $data_master    = $this->riwayat_pendidikan_m->cek_data($id);
            $directory      = FCPATH . $this->config->item('base_upload');
            $file_name_temp = pathinfo($data_temp->row()->$jenis);
            $old            = $directory . $data_temp->row()->$jenis;
            if ($data_master->num_rows() == 0) {
                $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->row()->id_karyawan . '/riwayat-pendidikan');
                $new_temp = $id_company . '/karyawan/' . $data_temp->row()->id_karyawan . '/riwayat-pendidikan/' . $file_name_temp['basename'];
                $new      = $directory . $new_temp;
                rename($old, $new);
            } else {
                if ($data_master->$jenis == $data_temp->row()->$jenis) {
                    //jika cuma edit nomor
                    $new_temp = $data_temp->row()->$jenis;
                } else {
                    $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->row()->id_karyawan . '/riwayat-pendidikan');
                    $new_temp = $id_company . '/karyawan/' . $data_temp->row()->id_karyawan . '/riwayat-pendidikan/' . $file_name_temp['basename'];
                    $new      = $directory . $new_temp;
                    rename($old, $new);
                }
            }
            return $new_temp;
        }
    }

    function revisi()
    {
        $id                  = $this->input->get('id');
        $keterangan          = $this->input->get('keterangan');
        $approve             = $this->model->approve($id, '3', $keterangan);
        $data_pengajuan      = $this->model->getDataById($id);
        $cek_data_pendidikan = $this->model->cek_id($id);
        if ($approve) {
            notif_approval('detail_data_pendidikan', $data_pengajuan->row()->id_karyawan, ucwords(keterangan_action($this->lang->line('data_pendidikan'), $data_pengajuan->row()->action)), $this->lang->line('revisi') . ' ' . $keterangan, $data_pengajuan->row()->id_riwayat_pendidikan);
            notif_kepegawaian($data_pengajuan->row()->id_karyawan, 'data_pendidikan', $data_pengajuan->row()->id_riwayat_pendidikan, jenis_revisi($cek_data_pendidikan), 'setuju');
            $this->logger->create_log('data_diri_pengajuan', 'revisi', $this->db->last_query());
            $this->notif->update_flag_baca('data_pendidikan', $data_pengajuan->row()->id_karyawan, $data_pengajuan->row()->id_riwayat_pendidikan);
        }
        __response_revisi($approve);
    }
}
