<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Data_sertifikat_pengajuan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan/Data_sertifikat_pengajuan_m', 'model');
        $this->load->model('Data_sertifikat_m');
        $this->load->model('notif_kepegawaian_m', 'notif');
        $this->load->helper('approval');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'sertifikat_pengajuan';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan_md5 = null)
    {
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['tab_aktif']       = 'pengajuan';
        $data['tab']             = $this->load->view('karyawan/data_sertifikat/tab', $data, true);
        $this->load->view('karyawan/data_sertifikat/pengajuan/home', $data);
    }

    function form($jenis, $id)
    {
        $data['id'] = $id;
        if ($jenis == 'approve') {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_approve', $data);
        } elseif ($jenis == 'hapus') {
            $this->load->view('karyawan/form_hapus', $data);
        } else {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_revisi', $data);
        }
    }

    public function list_data($id_karyawan = null)
    {
        $data['data'] = $this->model->list_data($id_karyawan);
        $get_data                    = $this->model->get_data($id_karyawan)->num_rows();
        if ($get_data > 0) {
            $this->load->view('karyawan/data_sertifikat/pengajuan/list_data', $data);
        } else {
            echo $this->lang->line('data_tidak_ditemukan');
        }
    }

    function approve()
    {
        $id      = $this->input->get('id');
        $approve = $this->model->approve($id, '2');
        if ($approve) {
            $this->logger->create_log('sertifikat_pengajuan', 'approve', $this->db->last_query());
            $cek_id         = $this->model->cek_id($id);
            $data_pengajuan = $this->model->getDataById($id);
            if ($cek_id == 0) {
                //jika tidak ada id maka insert data
                $folder_master = $this->move_file_to_master('file', $id);
                $insert_master = $this->model->insert_master($id, $folder_master);
                if ($insert_master) {
                    $this->model->insert_history($id, $folder_master);
                    $id_history = $this->db->insert_id();
                    notif_approval('detail_data_sertifikat', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('sertifikat'), $data_pengajuan->action)), $this->lang->line('disetujui'), $id_history);
                    notif_kepegawaian($data_pengajuan->id_karyawan, 'sertifikat', $id_history, 'tambah', 'setuju');
                    $this->logger->create_log('sertifikat_pengajuan', 'approve insert data sertifikat', $this->db->last_query());
                    $this->notif->update_flag_baca('sertifikat', $data_pengajuan->id_karyawan, $data_pengajuan->id_sertifikat);
                }
            } else {
                //sebaliknya maka update
                $folder_history = $this->move_file_to_history('file', $id);
                $insert_history = $this->model->insert_history($id, $folder_history);
                if ($insert_history) {
                    $id_history = $this->db->insert_id();
                    $this->logger->create_log('sertifikat_pengajuan', 'approve insert histori', $this->db->last_query());
                    $this->model->update_path_foto_history($id, $folder_history);
                    $folder_master = $this->move_file_to_master('file', $id);
                    $update_data   = $this->model->update_data($id, $folder_master);
                    if ($update_data) {
                        notif_approval('detail_data_sertifikat', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('sertifikat'), $data_pengajuan->action)), $this->lang->line('disetujui'), $id_history);
                        notif_kepegawaian($data_pengajuan->id_karyawan, 'sertifikat', $id_history, 'update', 'setuju');
                        $this->logger->create_log('sertifikat_pengajuan', 'approve update data sertifikat', $this->db->last_query());
                        $this->notif->update_flag_baca('sertifikat', $data_pengajuan->id_karyawan, $data_pengajuan->id_sertifikat);
                    }
                }
            }
            $this->model->delete($id);
        }

        __response_approve($approve);
    }

    function revisi()
    {
        $id             = $this->input->get('id');
        $keterangan     = $this->input->get('keterangan');
        $approve        = $this->model->approve($id, '3', $keterangan);
        $data_pengajuan = $this->model->getDataById($id);
        $cek_sertifikat = $this->model->cek_id($id);
        if ($approve) {
            notif_approval('detail_data_sertifikat', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('sertifikat'), $data_pengajuan->action)), $this->lang->line('revisi') . ' ' . $keterangan, $data_pengajuan->id_sertifikat);
            notif_kepegawaian($data_pengajuan->id_karyawan, 'sertifikat', $data_pengajuan->id_sertifikat, jenis_revisi($cek_sertifikat), 'revisi');
            $this->logger->create_log('sertifikat_pengajuan', 'revisi', $this->db->last_query());
            $this->notif->update_flag_baca('sertifikat', $data_pengajuan->id_karyawan, $data_pengajuan->id_sertifikat);
        }
        __response_revisi($approve);
    }

    function move_file_to_history($jenis, $id)
    {
        $id_company = $this->session->userdata('id_company');
        $data_temp  = $this->Data_sertifikat_m->getDataById($id);
        //data master
        $data_pengajuan = $this->model->getDataById($id);
        if ($data_temp->file == $data_pengajuan->file) {
            $new_temp = $data_pengajuan->file;
        } else {
            $directory      = FCPATH . $this->config->item('base_upload');
            $file_name_temp = pathinfo($data_temp->$jenis);
            $old            = $directory . $data_temp->$jenis;
            $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/sertifikat/history');
            $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/sertifikat/history/' . $file_name_temp['basename'];
            $new      = $directory . $new_temp;
            rename($old, $new);
        }
        return $new_temp;
    }

    function create_directory($dir)
    {
        if (!file_exists($dir) && !is_dir($dir)) {
            mkdir($dir, 0755, true);
        }
    }

    function move_file_to_master($jenis, $id)
    {
        $id_company = $this->session->userdata('id_company');
        $data_temp  = $this->model->getDataById($id);
        //data pengajuan
        if ($data_temp->$jenis == '') {
            return '';
        } else {
            $data_master = $this->Data_sertifikat_m->getDataById($id);
            //data master
            if ($data_master->file == $data_temp->file) {
                $new_temp = $data_temp->file;
            } else {
                $directory      = FCPATH . $this->config->item('base_upload');
                $file_name_temp = pathinfo($data_temp->$jenis);
                $old            = $directory . $data_temp->$jenis;
                $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/sertifikat');
                $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/sertifikat/' . $file_name_temp['basename'];
                $new      = $directory . $new_temp;
                rename($old, $new);
            }
            return $new_temp;
        }
    }

    function hapus()
    {
        $id             = $this->input->get('id');
        $approve        = $this->model->approve($id, '2');
        $data_pengajuan = $this->model->getDataById($id);
        if ($approve) {
            $this->logger->create_log('sertifikat_pengajuan', 'hapus', $this->db->last_query());
            $folder_history = $this->move_file_to_history_hapus('file', $id);
            $insert_history = $this->model->insert_history($id, $folder_history);
            $id_history     = $this->db->insert_id();
            notif_approval('detail_data_sertifikat', $data_pengajuan->id_karyawan, ucwords(keterangan_action($this->lang->line('sertifikat'), $data_pengajuan->action)), $this->lang->line('disetujui'), $id_history);
            notif_kepegawaian($data_pengajuan->id_karyawan, 'sertifikat', $id_history, 'hapus', 'setuju');
            $this->notif->update_flag_baca('sertifikat', $data_pengajuan->id_karyawan, $data_pengajuan->id_sertifikat);
            $this->model->update_path_foto_history($id, $folder_history);
            $hapus_data = $this->model->hapus_data($id);
            if ($hapus_data) {
                $this->logger->create_log('sertifikat_pengajuan', 'hapus data sertifikat', $this->db->last_query());
            }
            $this->model->delete($id);
        }

        __response_delete($approve);
    }

    function move_file_to_history_hapus($jenis, $id)
    {
        $id_company     = $this->session->userdata('id_company');
        $data_temp      = $this->Data_sertifikat_m->getDataById($id);
        $directory      = FCPATH . $this->config->item('base_upload');
        $file_name_temp = pathinfo($data_temp->$jenis);
        $old            = $directory . $data_temp->$jenis;
        $this->create_directory($directory . $id_company . '/karyawan/' . $data_temp->id_karyawan . '/sertifikat/history');
        $new_temp = $id_company . '/karyawan/' . $data_temp->id_karyawan . '/sertifikat/history/' . $file_name_temp['basename'];
        $new      = $directory . $new_temp;
        rename($old, $new);
        return $new_temp;
    }
}
