<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Riwayat_pendidikan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Riwayat_pendidikan_m');
        $this->load->library('Uploadfile');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'pendidikan_verifikasi';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan)
    {
        $data['id']        = $id_karyawan;
        $data['tab_aktif'] = 'verifikasi';
        $data['tab']       = $this->load->view('karyawan/riwayat_pendidikan/tab', $data, true);
        $this->load->view('karyawan/riwayat_pendidikan/home', $data);
    }

    public function form($id_karyawan = null, $id_pendidikan = null)
    {
        $data['id_karyawan'] = $id_karyawan;

        if ($id_pendidikan != null) {
            $data['data'] = $this->Riwayat_pendidikan_m->getDataById($id_pendidikan);
        }
        $this->load->view('karyawan/riwayat_pendidikan/form', $data);
    }

    public function list_data($id_karyawan = null, $id_pendidikan = null)
    {
        $data['pendidikan'] = $this->Riwayat_pendidikan_m->listData($id_karyawan);
        $this->load->view('karyawan/riwayat_pendidikan/list_data', $data);
    }

    public function save()
    {
        $id = $this->input->post('id_pendidikan');
        $id_company = $this->id_company;
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($this->input->post('id_karyawan'));

        $transkrip_lama = $this->input->post('transkrip_lama');
        $ijazah_lama = $this->input->post('ijazah_lama');

        $file1 = $_FILES['ijazah'];
        if ($file1['name'] == "") {
            $ijazah = $ijazah_lama;
        } else {
            $fileUpload['fname']            = 'ijazah';
            $fileUpload['location']         = 'karyawan/' . $id_karyawan . '/riwayat-pendidikan';
            $fileUpload['allowed']          = 'jpg|png|jpeg';
            $fileUpload['compress_image']   = true;
            $fileUpload['filename']         = 'ijazah-' . str_replace("/", "-", $this->input->post('jenjang'));

            $uploadIjazah = $this->uploadfile->doUpload($fileUpload);
            if ($uploadIjazah["success"] == true) {
                $ijazah = $uploadIjazah['url'];
                if (!empty($ijazah_lama)) {
                    if ($ijazah != $ijazah_lama) {
                        $this->fungsi->delete_fileupload($ijazah_lama);
                    }
                }
            } else {
                $message = ["message" => $uploadIjazah["message"]];
                return __response_save(false, ["params" => $message]);
            }
        }

        $file2 = $_FILES['transkrip'];
        if ($file2['name'] == "") {
            $transkrip = $transkrip_lama;
        } else {
            $fileTranskrip['fname']            = 'transkrip';
            $fileTranskrip['location']         = 'karyawan/' . $id_karyawan . '/riwayat-pendidikan';
            $fileTranskrip['allowed']          = 'jpg|png|jpeg';
            $fileTranskrip['compress_image']   = true;
            $fileTranskrip['filename']         = 'transkrip-' . str_replace("/", "-", $this->input->post('jenjang'));

            $upload = $this->uploadfile->doUpload($fileTranskrip);
            if ($upload["success"] == true) {
                $transkrip = $upload['url'];
                if (!empty($transkrip_lama)) {
                    if ($transkrip != $transkrip_lama) {
                        $this->fungsi->delete_fileupload($transkrip_lama);
                    }
                }
            } else {
                $message = ["message" => $upload["message"]];
                return __response_save(false, ["params" => $message]);
            }
        }

        $data = array(
            'nama_sekolah' => $this->input->post('nama_sekolah'),
            'jenjang'      => $this->input->post('jenjang'),
            'jurusan'      => $this->input->post('jurusan'),
            'lulusan_asal' => $this->input->post('lulusan_asal'),
            'gelar'        => $this->input->post('gelar'),
            'tahun_masuk'  => $this->input->post('tahun_masuk'),
            'tahun_lulus'  => $this->input->post('tahun_lulus'),
            'ijazah'       => $ijazah,
            'transkrip'    => $transkrip,
            'id_company'   => $id_company,
            'id_karyawan'  => $id_karyawan
        );
        $this->Riwayat_pendidikan_m->save($data, $id);
    }

    public function delete()
    {
        $id = $this->input->post("id_riwayat_pendidikan");
        $this->Riwayat_pendidikan_m->delete($id);
    }
}
