<script type="text/javascript">
    $(function() {
        $(document).on('click', '.btn_tambah_m_lead', function() {
            $('#tampil_form').load("<?= route("sales_activity.master.lead.source.form.tambah") ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save_m_lead").addClass("btn_save_m_lead btn btn-primary");
                $(".btn_save_m_lead").append('<i class="fa fa-save"></i> ');
                $(".btn_save_m_lead").append("<?= $this->lang->line('button_form_simpan') ?>");
                $("#btn_new_input_m_lead").hide();
            });
        });

        $(document).on('click', '.btn_edit_m_lead', function() {
            $('#tampil_form').load("<?= route('sales_activity.master.lead.source.form.edit') ?>"+ "/" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                $(".btn_save_m_lead").addClass("btn_save_m_lead btn btn-warning");
                $(".btn_save_m_lead").append('<i class="fa fa-update"></i> ');
                $(".btn_save_m_lead").append("<?= $this->lang->line('button_form_perbarui') ?>");
                $("#btn_new_input_m_lead").hide();
            });
        });

        $(document).on('click', '.btn_delete_m_lead', function() {
            $('#tampil_form').load("<?= route('sales_activity.master.lead.source.form.hapus') ?>"+ "/" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                $("#form_input_m_lead input[type=text]").prop("disabled", true);
                $(".btn_save_m_lead").append('<i class="fa fa-trash"></i> ');
                $(".btn_save_m_lead").append('<?= $this->lang->line('button_form_hapus') ?>');
                $(".btn_save_m_lead").removeClass("btn_save_m_lead").addClass("btn_hapus_m_lead btn btn-danger");
            });
        });

        $(document).on('click', '#btn_new_input_m_lead', function() {
            $("#form_input_m_lead :input").prop("disabled", false);
            $("#form_input_m_lead input[type=text]").val('');
            $('.btn_save_m_lead').show();
            $('#btn_new_input_m_lead').hide();
            $('#message').html('');
        });

        $(document).on("click", ".btn_save_m_lead", function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#form_input_m_lead #nama").val() == '') {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_lead') ?></font>");
                $("#form_input_m_lead #nama").focus();
                return false;
            }

            loading.start();
            var param = {};
            param.id_lead_m = $("#form_input_m_lead #id_lead_m").val();
            param.nama        = $("#form_input_m_lead #nama").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('sales_activity.master.lead.source.save') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input_m_lead :input").prop("disabled", true);
                            $('.btn_save_m_lead').hide();
                            $('#btn_new_input_m_lead').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        $(document).on('click', '.btn_hapus_m_lead', function() {
            var loading = Ladda.create(this);
            loading.start();

            var param = {};
            param.id = $("#id_lead_m").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('sales_activity.master.lead.source.delete') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
                },
                error: function() {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    });
</script>