<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : false,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : false,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'Kode/Nama'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                        "url": "<?= route('pkwt.master.ttd.direktur.list.data') ?>",
                                        "type": "POST",
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(4)', nRow).css({'text-align':'center','width':'50px'});
                    }
        
        });

        $(document).on('click','.btn_tambah',function(){
            $('#tampil_form').load("<?= route('pkwt.master.ttd.direktur.form.tambah') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Tambah Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('SIMPAN');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_edit',function(){
            $('#tampil_form').load("<?= route('pkwt.master.ttd.direktur.form.edit') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Edit Data");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('PERBARUI');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_delete',function(){
            $('#tampil_form').load("<?= route('pkwt.master.ttd.direktur.form.hapus') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $('#form_input input[type=text]').prop("disabled",true);
                $('#form_input input[type=file]').prop("disabled",true);
                $('#form_input #direksi').prop("disabled",true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('HAPUS');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click','#btn_new_input', function(){
            $('#form_input input[type=text]').prop("disabled",false);
            $("#form_input input[type=text]").val('');
            $('#form_input input[type=file]').prop("disabled",false);
            $("#form_input input[type=file]").val('');
            $('.dropify-clear').trigger('click');

            $('#direksi').prop("disabled",false);
            $("#direksi").val('').trigger('change');
            
            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        // PROSES SAVE
        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);
        
            if($("#direksi").val() == null){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama lengkap belum diisi</font>");
                $("#direksi").focus();
                return false;
            }else if($("#nm_jabatan").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama jabatan belum diiisi</font>");
                $('#nm_jabatan').focus();
                return false;
            }else if($("#file").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanda tangan belum diupload</font>");
                $('#file').focus();
                return false;
            }
            
            loading.start();

            var param = new FormData();
            param.append('id',$("#form_input #id_hidden").val());
            param.append('id_karyawan',$("#form_input #direksi").val());
            param.append('nm_jabatan',$("#form_input #nm_jabatan").val());
            param.append('file',$('#file').prop('files')[0]);
            param.append('file_lama',$("#file_lama").val());
        
            $.ajax({
                type: 'POST',
                url: "<?= route('pkwt.master.ttd.direktur.save') ?>",
                data: param,
                dataType:'JSON',
                contentType: false,
				processData: false,
				cache: false,
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click','.btn_hapus',function(){
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?= route('pkwt.master.ttd.direktur.delete') ?>",
                data: 'id='+$("#id_hidden").val(),
                dataType:'JSON',
                success: function(result){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message);
                    
                },
                error:function(){
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
        
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">PKWT</li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
                if(in_array($this->level_user, array("1"))) {
            ?>
                    <div class="float-md-right">
                        <button type="button" class="btn_tambah btn btn-biru">
                            <i class="fa fa-plus"></i> Tambah Data
                        </button>
                    </div>
            <?php
                }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row mt-2">
                <div class="col-md-12 table-responsive">
                    <table id="list_data" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th class="text-center">NO</th>
                                <th class="text-left">NAMA LENGKAP</th>
                                <th class="text-left">JABATAN</th>
                                <th class="text-left">TANDATANGAN</th>
                                <th class="text-center">AKSI</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->