<style>
    th {
        vertical-align: middle !important;
    }
</style>

<div class="content-header mt-4">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div id="filter">
        <div class="row">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="align-self-center">BULAN</label>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="text" id="bulan" class="form-control" autocomplete="off" placeholder="mm-yyyy" spellcheck="false" value="<?= date('m-Y') ?>" onchange="onchange_dropdown_bulan()">
                        </div>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-2">
                        <label>KARYAWAN</label>
                    </div>
                    <div class="col-md-8">
                        <select id="id_karyawan" class="form-control"></select>
                    </div>
                    <div class="col-md-2">
                        <button type="button" id="btn_cari" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">CARI</button>
                    </div>
                </div>

                <div class="row mt-1">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>CABANG</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select id="cabang" class="form-control" onchange="onchange_dropdown_cabang()">
                            <option></option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label>DEPARTEMEN</label>
                    </div>
                    <div class="col-md-3">
                        <select class="form-control" id="departemen"></select>
                    </div>
                    <div class="col-md-2">
                        <button type="button" id="btn_filter" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">FILTER</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div id="view_data">
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        dropdown_cabang();
        dropdown_departemen();
        dropdown_karyawan();
        list_data();

        $("#filter #bulan").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
            endDate: "today"
        });

        $('#btn_cari').click(function(){
            let loading = Ladda.create(this);
            loading.start();
            let bulan           = ($("#filter #bulan").val() == null)?"0":$("#filter #bulan").val();
            let id_cabang       = "all";
            let id_departemen   = "all";
            let id_karyawan     = ($("#filter #id_karyawan").val() == null)?"all":$("#filter #id_karyawan").val();

            $('#view_data').load("<?= route('payroll.laporan.pph.view.data', ['bulan' => '"+bulan+"', 'id_cabang' => '"+id_cabang+"', 'id_departemen' => '"+id_departemen+"', 'id_karyawan' => '"+id_karyawan+"']) ?>", function(){
                loading.stop();
            });
        });

        $('#btn_filter').click(function(){
            let loading = Ladda.create(this);
            loading.start();
            let bulan           = (!$("#filter #bulan").val())?"0":$("#filter #bulan").val();
            let id_cabang       = (!$("#filter #cabang").val())?"all":$("#filter #cabang").val();
            let id_departemen   = (!$("#filter #departemen").val())?"all":$("#filter #departemen").val();
            let id_karyawan     = "all";

            $('#view_data').load("<?= route('payroll.laporan.pph.view.data', ['bulan' => '"+bulan+"', 'id_cabang' => '"+id_cabang+"', 'id_departemen' => '"+id_departemen+"', 'id_karyawan' => '"+id_karyawan+"']) ?>", function(){
                loading.stop();
            });
        });
    });

    function list_data() {
        let bulan           = (!$("#filter #bulan").val())?"0":$("#filter #bulan").val();
        let id_cabang       = "all";
        let id_departemen   = "all";
        let id_karyawan     = "all";

        $('#view_data').load("<?= route('payroll.laporan.pph.view.data', ['bulan' => '"+bulan+"', 'id_cabang' => '"+id_cabang+"', 'id_departemen' => '"+id_departemen+"', 'id_karyawan' => '"+id_karyawan+"']) ?>");
    }

    function onchange_dropdown_bulan(){
        $("#filter #id_karyawan").val('').trigger('change');
        $("#filter #cabang").val('').trigger('change');
        $("#filter #departemen").val('').trigger('change');
        dropdown_karyawan();
        dropdown_cabang();
        dropdown_departemen();
    }

    function dropdown_karyawan(){
        let bulan   = ($("#filter #bulan").val() == null)?"00-0000":$("#filter #bulan").val();
        $('#filter #id_karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan.pph") ?>/'+bulan,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_cabang(){
        let bulan   = ($("#filter #bulan").val() == null)?"00-0000":$("#filter #bulan").val();
        $('#filter #cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang.pph") ?>/'+bulan,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function onchange_dropdown_cabang(){
        $("#filter #departemen").val('').trigger('change');
        dropdown_departemen();
    }

    function dropdown_departemen(){
        let bulan   = ($("#filter #bulan").val() == null)?"00-0000":$("#filter #bulan").val();
        let id_cabang   = ($("#filter #cabang").val() == null)?"all":$("#filter #cabang").val();
        $("#filter #departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.pph") ?>/'+bulan+"/"+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }
</script>
