<script>
    $(function() {
        $('#<?= $column ?> .btn-save').on('click', function(e) {
            e.preventDefault();
            var loading = Ladda.create(this);
            const column = $(this).data("for");
            const old = $(this).data("old");

            var params = {};
            params.column = column;
            params.value = informasi_lembur_get_value_form(column);
            params.value_old = old;
            params.id_karyawan = "<?= $id_karyawan ?>";

            $.ajax({
                type: 'POST',
                url: "<?= route('master.karyawan.payroll.informasi_lembur.save') ?>",
                data: params,
                dataType: 'JSON',
                beforeSend: function() {
                    loading.start();
                    informasi_lembur_disable_form(column, true);
                },
                success: function(result) {
                    loading.stop();
                    if (result.success == true) {
                        load_informasi_lembur();
                    } else {
                        informasi_lembur_disable_form(column, false);
                        showMsg(result.message, false);
                    }
                },
                error: function() {
                    loading.stop();
                    informasi_lembur_disable_form(column, false);
                    showMsg("error", false);
                }
            });
        })
    });
</script>
<div class="input-group">
    <select class="form-control" style="font-size: 12px;">
        <option value="<?= ($aturan_lembur[$column] ? '' : 'selected') ?>">-</option>
        <?php
        foreach ($master_lembur as $key => $value) {
            if ($key == $aturan_lembur[$column][$column]) $default = $key;
            echo '<option value="' . $key . '" ' . ($key == $aturan_lembur[$column][$column] ? 'selected' : '') . '>' . $value['kode'] . '</option>';
        }
        ?>
    </select>
    <div class="input-group-append">
        <button class="btn btn-primary btn-save ladda-button" data-for="<?= $column ?>" data-old="<?= $default ?>" type="button" data-style="zoom-in"><i class="fa fa-check"></i></button>
    </div>
</div>
