<script type="text/javascript">
    $(document).ready(function() {
        datepicker();
        dropdown_kota();
        dropdown_kecamatan();
        dropdown_kelurahan();
        dropdown_supervisi();

        $("#username, #password").on({
            keydown: function(e) {
                if (e.which === 32)
                    return false;
            },
            keyup: function() {
                this.value = this.value.replace(/\s/g, "");
            }
        });


        $('#id_prov').select2({
            placeholder: '<?= $this->lang->line('pilih_provinsi') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.provinsi")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#id_prov").change(function() {
            $('#id_kab').val('0').trigger("change");
            dropdown_kota();
        });

        $("#id_kab").change(function() {
            $('#id_kec').val('0').trigger("change");
            dropdown_kecamatan();
        });

        $("#id_kec").change(function() {
            $('#id_kel').val('0').trigger("change");
            dropdown_kelurahan();
        });


        var status = $("#status").val();
        statusKaryawan(status);

        $("#status").change(function() {
            var status = $(this).val();
            statusKaryawan(status);
        });

        $('#jabatan').select2({
            placeholder: '<?= $this->lang->line('pilih_jabatan') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.jabatan") ?>' + "?karyawan_tab_status=YA",
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });


        $("#jabatan").change(function() {
            if ($(this).select2('data').lenght > 0) {
                var level_user = $("#jabatan option:selected").attr("leveluser");
            } else {
                var level_user = $("#jabatan").select2('data')[0].leveluser;
            }
            levelUser(level_user);
        });

        $('#cabang').select2({
            placeholder: '<?= $this->lang->line('pilih_cabang') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#cabang").change(function() {
            $('#supervisi').val('0');
            dropdown_supervisi();
        });

        $('#departemen').select2({
            placeholder: '<?= $this->lang->line('pilih_departemen') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.departemen")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#departemen").change(function() {
            $('#supervisi').val('0');
            dropdown_supervisi();
        });


        $(".btn_save_datadiri").click(function(e) {
            e.preventDefault();
            $('#form_input #message').html("");
            var loading = Ladda.create(this);

            if (typeof $("#jabatan").select2('data')[0].leveluser === "undefined") {
                var level_user = $("#jabatan option:selected").attr("leveluser");
            } else {
                var level_user = $("#jabatan").select2('data')[0].leveluser;
            }

            if ($("#no_induk_karyawan").val() == "") {
                $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nomor_induk_karyawan') ?></font>");
                $("#no_induk_karyawan").focus();
                return false;
            } else if ($("#nama_lengkap").val() == "") {
                $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_lengkap') ?></font>");
                $("#nama_lengkap").focus();
                return false;
            }
            // else if($("#jenis_kelamin").val() ==""){
            //     $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Jenis Kelamin belum diiisi</font>");
            //     $('#jenis_kelamin').focus();
            //     return false;
            // }
            else if ($("#jml_anak").val() == "") {
                $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jumlah_anak') ?></font>");
                $('#jml_anak').focus();
                return false;
            } else if ($("#jabatan").val() == null) {
                $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_jabatan') ?></font>");
                $('#jabatan').select2('open');
                return false;
            }
            // else if(level_user == "1"){
            //     if($("#cabang").val() == null){
            //         $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
            //         $('#cabang').select2('open');
            //         return false;
            //     }
            // }
            else if (level_user == "2") {
                if ($("#cabang").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                } else if ($("#departemen").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_departemen') ?></font>");
                    $('#departemen').select2('open');
                    return false;
                }
            } else if (level_user == "3") {
                if ($("#cabang").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                } else if ($("#departemen").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_departemen') ?></font>");
                    $('#departemen').select2('open');
                    return false;
                }
            } else if (level_user == "4") {
                if ($("#cabang").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            } else if (level_user == "5") {
                if ($("#cabang").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }
            // else if(level_user == "6"){
            //     if($("#cabang").val() == null){
            //         $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
            //         $('#cabang').select2('open');
            //         return false;
            //     }
            // }
            else if (level_user == "7") {
                if ($("#cabang").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                } else if ($("#departemen").val() == null) {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_departemen') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }

            if (level_user != "1" && level_user != "6") {
                if ($("#status").val() == "") {
                    $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_status_karyawan') ?></font>");
                    $('#status').focus();
                    return false;
                } else if ($("#status").val() == "1") {
                    if ($("#tgl_aktif_bekerja").val() == "") {
                        $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_mulai_kontrak') ?></font>");
                        $('#tgl_aktif_bekerja').focus()
                        return false;
                    } else if ($("#tgl_berhenti_bekerja").val() == "") {
                        $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_berakhir_kontrak') ?></font>");
                        $('#tgl_berhenti_bekerja').focus();
                        return false;
                    }
                } else if ($("#status").val() == "2") {
                    if ($("#tgl_aktif_bekerja").val() == "") {
                        $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_mulai_aktif') ?></font>");
                        $('#tgl_aktif_bekerja').focus()
                        return false;
                    }
                } else if ($("#status").val() == "5") {
                    if ($("#tgl_berhenti_bekerja").val() == "") {
                        $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_resign') ?></font>");
                        $('#tgl_berhenti_bekerja').focus()
                        return false;
                    }
                } else if ($("#status").val() == "6") {
                    if ($("#tgl_berhenti_bekerja").val() == "") {
                        $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_phk') ?></font>");
                        $('#tgl_berhenti_bekerja').focus()
                        return false;
                    }
                } else if ($("#status").val() == "7") {
                    if ($("#tgl_berhenti_bekerja").val() == "") {
                        $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_pensiun') ?></font>");
                        $('#tgl_berhenti_bekerja').focus()
                        return false;
                    }
                }
            }

            if ($("#join_date").val() == "") {
                $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_join') ?></font>");
                $('#join_date').focus()
                return false;
            } else if ($("#username").val() == "") {
                $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_username') ?></font>");
                $('#username').focus()
                return false;
            } else if ($("#password").val() == "") {
                $('#form_input #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_password') ?></font>");
                $('#password').focus()
                return false;
            }

            loading.start();

            var param = new FormData();
            param.append('id_karyawan', $("#id_karyawan").val());
            param.append('no_induk_karyawan', $("#no_induk_karyawan").val());
            param.append('nama_lengkap', $("#nama_lengkap").val());
            param.append('gelar_depan', $("#gelar_depan").val());
            param.append('gelar_belakang', $("#gelar_belakang").val());
            param.append('golongan_darah', $("#golongan_darah").val());
            param.append('jenis_kelamin', $("#jenis_kelamin").val());
            param.append('agama', $("#agama").val());
            param.append('tempat_lahir', $("#tempat_lahir").val());
            param.append('tgl_lahir', $("#tgl_lahir").val());
            param.append('alamat_ktp', $("#alamat_ktp").val());
            param.append('alamat_domisili', $("#alamat_domisili").val());
            param.append('rt', $("#rt").val());
            param.append('rw', $("#rw").val());
            param.append('id_kel', $("#id_kel").val());
            param.append('id_kec', $("#id_kec").val());
            param.append('id_kab', $("#id_kab").val());
            param.append('id_prov', $("#id_prov").val());
            param.append('kode_pos', $("#kode_pos").val());
            param.append('telepon', $("#telepon").val());
            param.append('no_ktp', $("#no_ktp").val());
            param.append('no_bpjs_kes', $("#no_bpjs_kes").val());
            param.append('no_bpjs_tk', $("#no_bpjs_tk").val());
            param.append('jml_anak_temp', $("#jml_anak_temp").val());
            param.append('jml_anak', $("#jml_anak").val());
            param.append('email', $("#email").val());
            param.append('tgl_aktif_bekerja', $("#tgl_aktif_bekerja").val());
            param.append('tgl_berhenti_bekerja', $("#tgl_berhenti_bekerja").val());
            param.append('departemen', $("#departemen").val());
            param.append('level_user', level_user);
            param.append('cabang', $("#cabang").val());
            param.append('jabatan', $("#jabatan").val());
            param.append('supervisi', $("#supervisi").val());
            param.append('flag_sales', $("#flag_sales").val());
            param.append('jatah_cuti', $("#jatah_cuti").val());
            param.append('pendidikan_terakhir', $("#pendidikan_terakhir").val());
            param.append('status', $("#status").val());
            param.append('foto_lama', $("#foto_lama").val());
            param.append('foto', $('#foto').prop('files')[0]);
            param.append('join_date', $('#join_date').val());
            param.append('username', $('#username').val());
            param.append('password', $('#password').val());

            $.ajax({
                type: 'POST',
                url: "<?= route('master.karyawan.datadiri.save') ?>",
                data: param,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if (result.success == true) {
                        id_kar = result.id_karyawan;
                        form_datadiri();
                    }
                    loading.stop();
                    $('#form_input #message').show();
                    $('#form_input #message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#form_input #message').show();
                    $('#form_input #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    });

    function statusKaryawan(status) {
        if (status == '1') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html('<?= $this->lang->line('tgl_mulai_kontrak') ?> <i class="text-danger">*</i>');
            $("#tgl_aktif_bekerja").prop("disabled", false);

            $("#div_tgl_berakhir_kerja").show();
            $("#lbl_tgl_berakhir_kerja").html('<?= $this->lang->line('tgl_berakhir_kontrak') ?> <i class="text-danger">*</i>');
            <?php if (isset($data)) {
                if ($data->status == '1' and $data->tgl_berhenti_bekerja != "0000-00-00") {
                    $tanggal_berhenti = date('d-m-Y', strtotime($data->tgl_berhenti_bekerja));
                } else {
                    $tanggal_berhenti = "";
                }
            ?>
                $("#tgl_berhenti_bekerja").val("<?= $tanggal_berhenti ?>");
            <?php } else { ?>
                $("#tgl_berhenti_bekerja").val("");
            <?php } ?>
        } else if (status == '2') {
            var level_user = $("#level_user").val();
            if (level_user == '1') {
                $("#div_tgl_mulai_kerja").hide();
            } else {
                $("#div_tgl_mulai_kerja").show();
                $("#lbl_tgl_mulai_kerja").html('<?= $this->lang->line('tgl_aktif') ?> <i class="text-danger">*</i>');
                $("#tgl_aktif_bekerja").prop("disabled", false);

                $("#div_tgl_berakhir_kerja").hide();
            }
        } else if (status == '3') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html("<?= $this->lang->line('tgl_aktif') ?>");
            $("#tgl_aktif_bekerja").prop("disabled", true);

            $("#div_tgl_berakhir_kerja").hide();
        } else if (status == '4') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html("<?= $this->lang->line('tgl_aktif') ?>");
            $("#tgl_aktif_bekerja").prop("disabled", true);

            $("#div_tgl_berakhir_kerja").hide();
        } else if (status == '5') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html("<?= $this->lang->line('tgl_aktif') ?>");
            $("#tgl_aktif_bekerja").prop("disabled", true);

            $("#div_tgl_berakhir_kerja").show();
            $("#lbl_tgl_berakhir_kerja").html('<?= $this->lang->line('tgl_resign') ?> <i class="text-danger">*</i>');
            if ($("#tgl_berhenti_bekerja").val() == '01-01-1970') {
                $("#tgl_berhenti_bekerja").val("");
            }

        } else if (status == '6') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html("<?= $this->lang->line('tgl_aktif') ?>");
            $("#tgl_aktif_bekerja").prop("disabled", true);

            $("#div_tgl_berakhir_kerja").show();
            $("#lbl_tgl_berakhir_kerja").html('<?= $this->lang->line('tgl_phk') ?> <i class="text-danger">*</i>');
            if ($("#tgl_berhenti_bekerja").val() == '01-01-1970') {
                $("#tgl_berhenti_bekerja").val("");
            }
        } else if (status == '7') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html("<?= $this->lang->line('tgl_aktif') ?>");
            $("#tgl_aktif_bekerja").prop("disabled", true);

            $("#div_tgl_berakhir_kerja").show();
            $("#lbl_tgl_berakhir_kerja").html('<?= $this->lang->line('tgl_pensiun') ?> <i class="text-danger">*</i>');
            if ($("#tgl_berhenti_bekerja").val() == '01-01-1970') {
                $("#tgl_berhenti_bekerja").val("");
            }
        } else {

        }
    }

    function levelUser(level_user) {
        if (typeof level_user === 'undefined') {
            var level_user = $("#level_user").val();
        }

        if (level_user == '1') {
            $("#div_cabang").hide();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

            $("#div_tgl_mulai_kerja").hide();
            $("#div_tgl_berakhir_kerja").hide();
            $("#div_cuti").hide();
            $("#div_status").hide();

        } else if (level_user == '2') {
            $("#div_cabang").show();
            $("#div_departemen").show();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

            $("#div_tgl_mulai_kerja").show();
            $("#div_tgl_berakhir_kerja").show();
            $("#div_cuti").show();
            $("#div_status").show();

        } else if (level_user == '3') {
            $("#div_cabang").show();
            $("#div_departemen").show();
            $("#div_supervisi").show();

            $("#div_tgl_mulai_kerja").show();
            $("#div_tgl_berakhir_kerja").show();
            $("#div_cuti").show();
            $("#div_status").show();

        } else if (level_user == '4') {
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

            $("#div_tgl_mulai_kerja").show();
            $("#div_tgl_berakhir_kerja").show();
            $("#div_cuti").show();
            $("#div_status").show();

        } else if (level_user == '5') {
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

            $("#div_tgl_mulai_kerja").show();
            $("#div_tgl_berakhir_kerja").show();
            $("#div_cuti").show();
            $("#div_status").show();
        } else if (level_user == '6') {
            $("#div_cabang").hide();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

            $("#div_tgl_mulai_kerja").hide();
            $("#div_tgl_berakhir_kerja").hide();
            $("#div_cuti").hide();
            $("#div_status").hide();

        } else if (level_user == '7') {
            $("#div_cabang").show();
            $("#div_departemen").show();
            $("#div_supervisi").hide();

            $("#div_tgl_mulai_kerja").show();
            $("#div_tgl_berakhir_kerja").show();
            $("#div_cuti").show();
            $("#div_status").show();
        } else {
            $("#cabang").val("");
            $("#departemen").val("").trigger("change");
            $("#supervisi").val("");

            $("#div_cabang").hide();
            $("#div_departemen").hide();
            $("#div_supervisi").hide();
        }
    }




    function detail_datadiri(id) {
        enable_li(true);
        $("#myTabContent").load("<?= route('master.karyawan.datadiri.detail') ?>" + "/" + id);
    }

    function enable_li(parameter) {
        if (parameter == true) {
            $('#keluarga').attr('onclick', 'informasi_keluarga()');
            $('#pendidikan').attr('onclick', 'informasi_pendidikan()');
            $('#pengalaman').attr('onclick', 'informasi_pengalamankerja()');
            $('#riwayat').attr('onclick', 'informasi_riwayatkerja()');
            $('#akun').attr('onclick', 'informasi_akun()');
            $('#file').attr('onclick', 'informasi_file()');
        } else {
            $('#keluarga').attr('onclick', 'return false');
            $('#pendidikan').attr('onclick', 'return false');
            $('#pengalaman').attr('onclick', 'return false');
            $('#riwayat').attr('onclick', 'return false');
            $('#akun').attr('onclick', 'return false');
            $('#file').attr('onclick', 'return false');

            $('#keluarga').attr('style', 'cursor : not-allowed');
            $('#pendidikan').attr('style', 'cursor : not-allowed');
            $('#pengalaman').attr('style', 'cursor : not-allowed');
            $('#riwayat').attr('style', 'cursor : not-allowed');
            $('#akun').attr('style', 'cursor : not-allowed');
            $('#file').attr('style', 'cursor : not-allowed');
        }
    }


    function dropdown_kota() {
        $('#id_kab').select2({
            placeholder: '<?= $this->lang->line('pilih_kota') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.kota") . "/" ?>' + $('#id_prov').val(),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_kecamatan() {
        $('#id_kec').select2({
            placeholder: '<?= $this->lang->line('pilih_kecamatan') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.kecamatan") . "/" ?>' + $('#id_kab').val(),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_kelurahan() {
        $('#id_kel').select2({
            placeholder: '<?= $this->lang->line('pilih_kelurahan') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.kelurahan") . "/" ?>' + $('#id_kec').val(),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_supervisi() {
        $('#supervisi').select2({
            placeholder: '<?= $this->lang->line('pilih_supervisi') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.supervisi")  ?>' + '/' + $('#cabang').val() + '/' + $('#departemen').val(),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function validate_input(e, regex) {
        var value = e.value;
        if (!regex.test(value)) {
            e.value = value.slice(0, -1);
        }
    }
</script>
<input type="hidden" name="id_karyawan" id="id_karyawan" value="<?= isset($data->id_karyawan) ? md5($data->id_karyawan) : '' ?>">
<div id="form_input" class="row">
    <div class="col-md-8">
        <div class="row">
            <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_diri') ?></label></div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('nomor_induk_karyawan') ?> <i class="text-danger">*</i></label>
                    <input type="text" id="no_induk_karyawan" class="form-control" oninput="validate_input(this, /^[A-Za-z0-9\-\.\/]+$/)" placeholder="<?= $this->lang->line('nomor_induk_karyawan') ?>" value="<?= isset($data->nik) ? $data->nik : '' ?>">
                    <span class="text-light" style="font-size: 11px;">Huruf, Angka, Simbol(. - dan /)</span>
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('nama_lengkap') ?> <i class="text-danger">*</i></label>
                    <input type="text" value="<?= isset($data->nama_lengkap) ? $data->nama_lengkap : '' ?>" class="form-control" name="nama_lengkap" id="nama_lengkap" placeholder="<?= $this->lang->line('nama_lengkap') ?>">
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('pendidikan_terakhir') ?></label>
                    <select id="pendidikan_terakhir" class="form-control">
                        <option value=""><?= $this->lang->line('pilih_opsi') ?></option>
                        <option value="SD" <?= ((isset($data) and $data->pendidikan_terakhir == 'SD') ? 'selected' : '') ?>><?= $this->lang->line('sd_mi') ?></option>
                        <option value="SMP" <?= ((isset($data) and $data->pendidikan_terakhir == 'SMP') ? 'selected' : '') ?>><?= $this->lang->line('smp_mts') ?></option>
                        <option value="SMA" <?= ((isset($data) and $data->pendidikan_terakhir == 'SMA') ? 'selected' : '') ?>><?= $this->lang->line('sma_smk') ?></option>
                        <option value="D3" <?= ((isset($data) and $data->pendidikan_terakhir == 'D3') ? 'selected' : '') ?>><?= $this->lang->line('d3') ?></option>
                        <option value="D4" <?= ((isset($data) and $data->pendidikan_terakhir == 'D4') ? 'selected' : '') ?>><?= $this->lang->line('d4') ?></option>
                        <option value="S1" <?= ((isset($data) and $data->pendidikan_terakhir == 'S1') ? 'selected' : '') ?>><?= $this->lang->line('s1') ?></option>
                        <option value="S2" <?= ((isset($data) and $data->pendidikan_terakhir == 'S2') ? 'selected' : '') ?>><?= $this->lang->line('s2') ?></option>
                        <option value="S3" <?= ((isset($data) and $data->pendidikan_terakhir == 'S3') ? 'selected' : '') ?>><?= $this->lang->line('s3') ?></option>
                    </select>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('gelar_depan') ?></label>
                    <input type="text" id="gelar_depan" class="form-control" placeholder="<?= $this->lang->line('gelar_depan') ?>" value="<?= isset($data->gelar_depan) ? $data->gelar_depan : '' ?>">
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('gelar_belakang') ?></label>
                    <input type="text" id="gelar_belakang" class="form-control" placeholder="<?= $this->lang->line('gelar_belakang') ?>" value="<?= isset($data->gelar_belakang) ? $data->gelar_belakang : '' ?>">
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label>Jenis Kelamin</label>
                    <select id="jenis_kelamin" class="form-control">
                        <option value="uknown"><?= $this->lang->line('pilih_opsi') ?></option>
                        <option value="L" <?= ((isset($data) and $data->jenis_kelamin == 'L') ? 'selected' : '') ?>><?= $this->lang->line('laki_laki') ?></option>
                        <option value="P" <?= ((isset($data) and $data->jenis_kelamin == 'P') ? 'selected' : '') ?>><?= $this->lang->line('perempuan') ?></option>
                    </select>
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('golongan_darah') ?></label>
                    <select id="golongan_darah" class="form-control">
                        <option value=""><?= $this->lang->line('pilih_opsi') ?></option>
                        <option value="A" <?= ((isset($data) and $data->golongan_darah == 'A') ? 'selected' : '') ?>>A</option>
                        <option value="AB" <?= ((isset($data) and $data->golongan_darah == 'AB') ? 'selected' : '') ?>>AB</option>
                        <option value="B" <?= ((isset($data) and $data->golongan_darah == 'B') ? 'selected' : '') ?>>B</option>
                        <option value="O" <?= ((isset($data) and $data->golongan_darah == 'O') ? 'selected' : '') ?>>O</option>
                    </select>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('tempat_lahir') ?></label>
                    <input type="text" id="tempat_lahir" class="form-control" placeholder="<?= $this->lang->line('tempat_lahir') ?>" value="<?= isset($data->tempat_lahir) ? $data->tempat_lahir : '' ?>">
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('tgl_lahir') ?></label>
                    <?php
                    if (!empty($data->tgl_lahir) && $data->tgl_lahir != '1970-01-01' && $data->tgl_lahir != '0000-00-00') {
                        $tanggal_lahir = date('d-m-Y', strtotime($data->tgl_lahir));
                    } else {
                        $tanggal_lahir = "";
                    }
                    ?>
                    <input type="text" id="tgl_lahir" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy" value="<?= $tanggal_lahir ?>">
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('no_telp') ?></label>
                    <input type="text" name="telepon" value="<?= isset($data->telepon) ? $data->telepon : '' ?>" class="form-control numberbox" id="telepon" placeholder="<?= $this->lang->line('no_telp') ?>">
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('email') ?></label>
                    <input type="email" value="<?= isset($data->email) ? $data->email : '' ?>" name="email" class="form-control" id="email" placeholder="<?= $this->lang->line('email') ?>">
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('agama') ?></label>
                    <select id="agama" class="form-control">
                        <option value="" <?= ((isset($data) and $data->agama == '') ? 'selected' : '') ?>><?= $this->lang->line('pilih_opsi') ?></option>
                        <option value="Islam" <?= ((isset($data) and $data->agama == 'Islam') ? 'selected' : '') ?>><?= $this->lang->line('islam') ?></option>
                        <option value="Kristen" <?= ((isset($data) and $data->agama == 'Kristen') ? 'selected' : '') ?>><?= $this->lang->line('kristen') ?></option>
                        <option value="Hindu" <?= ((isset($data) and $data->agama == 'Hindu') ? 'selected' : '') ?>><?= $this->lang->line('hindu') ?></option>
                        <option value="Buddha" <?= ((isset($data) and $data->agama == 'Buddha') ? 'selected' : '') ?>><?= $this->lang->line('buddha') ?></option>
                        <option value="Katolik" <?= ((isset($data) and $data->agama == 'Katolik') ? 'selected' : '') ?>><?= $this->lang->line('katolik') ?></option>
                        <option value="Khonghucu" <?= ((isset($data) and $data->agama == 'Khonghucu') ? 'selected' : '') ?>><?= $this->lang->line('khonghucu') ?></option>
                    </select>
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('no_ktp') ?></label>
                    <input type="text" id="no_ktp" class="form-control numberbox" placeholder="<?= $this->lang->line('no_ktp') ?>" value="<?= isset($data->no_ktp) ? $data->no_ktp : '' ?>">
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('no_bpjs_kes') ?></label>
                    <input type="text" id="no_bpjs_kes" class="form-control numberbox" placeholder="<?= $this->lang->line('no_bpjs_kes') ?>" value="<?= isset($data->no_bpjs_kes) ? $data->no_bpjs_kes : '' ?>">
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('no_bpjs_tk') ?></label>
                    <input type="text" id="no_bpjs_tk" class="form-control numberbox" placeholder="<?= $this->lang->line('no_bpjs_tk') ?>" value="<?= isset($data->no_bpjs_tk) ? $data->no_bpjs_tk : '' ?>">
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('jml_anak') ?></label>
                    <input type="hidden" id="jml_anak_temp" value="<?= isset($data->jml_anak) ? $data->jml_anak : '0' ?>">
                    <input type="number" id="jml_anak" class="form-control numberbox" placeholder="<?= $this->lang->line('jml_anak') ?>" value="<?= isset($data->jml_anak) ? $data->jml_anak : '0' ?>">
                </fieldset>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_alamat_ktp') ?></label></div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <fieldset class="form-group">
                    <textarea id="alamat_ktp" class="form-control" rows="3" placeholder="<?= $this->lang->line('data_alamat_ktp') ?>"><?= isset($data->alamat_ktp) ? $data->alamat_ktp : '' ?></textarea>
                </fieldset>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_alamat_domisili') ?></label></div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('provinsi') ?></label>
                    <select id="id_prov" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        <option value="<?= (($data->id_prov) ? $data->id_prov : '') ?>" selected><?= (($data->nama_prov) ? $data->nama_prov : '') ?></option>
                    </select>
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('kota_kabupaten') ?></label>
                    <select id="id_kab" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        <option value="<?= (($data->id_kota) ? $data->id_kota : '') ?>" selected><?= (($data->nama_kota) ? $data->nama_kota : '') ?></option>
                    </select>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('kecamatan') ?></label>
                    <select id="id_kec" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        <option value="<?= (($data->id_kecamatan) ? $data->id_kecamatan : '') ?>" selected><?= (($data->nama_kec) ? $data->nama_kec : '') ?></option>
                    </select>
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('kelurahan') ?></label>
                    <select id="id_kel" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        <option value="<?= (($data->id_kelurahan) ? $data->id_kelurahan : '') ?>" selected><?= (($data->nama_kel) ? $data->nama_kel : '') ?></option>
                    </select>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label>RT</label>
                    <input type="text" id="rt" class="form-control numberbox" placeholder="RT" value="<?= isset($data->rt) ? $data->rt : '' ?>">
                </fieldset>
            </div>
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label>RW</label>
                    <input type="text" id="rw" class="form-control numberbox" placeholder="RW" value="<?= isset($data->rw) ? $data->rw : '' ?>">
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('alamat') ?></label>
                    <textarea id="alamat_domisili" class="form-control" rows="3" placeholder="<?= $this->lang->line('alamat') ?>"><?= isset($data->alamat_domisili) ? $data->alamat_domisili : '' ?></textarea>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('kode_pos') ?></label>
                    <input type="text" id="kode_pos" class="form-control numberbox" placeholder="<?= $this->lang->line('kode_pos') ?>" value="<?= isset($data->kode_pos) ? $data->kode_pos : '' ?>">
                </fieldset>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_kepegawaian') ?></label></div>
        </div>
        <?php

        if (isset($data->level_user)) {
            $level_user = $data->level_user;
            if (in_array($level_user, array('1', '6'))) { # Admin HR, Direksi, Admin Finance
                $hidden_cabang = "style='display:none'";
                $hidden_cuti = "style='display:none'";
                $hidden_status = "style='display:none'";
                $hidden_tgl_mulai_kerja = "style='display:none'";
                $hidden_tgl_berakhir_kerja = "style='display:none'";
                $hidden_departemen = "style='display:none'";
                $hidden_supervisi = "style='display:none'";
            } else if ($level_user == '4') {
                $hidden_departemen = "style='display:none'";
                $hidden_supervisi = "style='display:none'";
            } else if ($level_user == '5') { # Kepala Cabang
                $hidden_departemen = "style='display:none'";
                $hidden_supervisi = "style='display:none'";
            } else if ($level_user == '2') { # Kepala Departemen
                $hidden_departemen = " ";
                $hidden_supervisi = "style='display:none'";
            } else if ($level_user == '7') { # Supervisi
                $hidden_departemen = " ";
                $hidden_supervisi = "style='display:none'";
            } else { # STaff
                $hidden_departemen = " ";
                $hidden_supervisi = " ";
            }


            if ($level_user == '1' && $id_karyawan == md5($id_karyawan_sess)) {
                $disable = 'disabled="true"';
            } else {
                $disable = '';
            }
        } else {
            $hidden_departemen = "";
            $hidden_supervisi = "";
        }
        ?>
        
        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label><?= $this->lang->line('jabatan') ?> <i class="text-danger">*</i></label>
                    <input type="hidden" id="level_user" value="<?= $data->level_user ?>">
                    <select class="form-control" id="jabatan" class="select2 form-control" <?= $disable ?> style="border-radius: 5px; width: 100%;">
                        <?php
                        if (isset($data->id_jabatan)) {
                            echo '<option value="' . $data->id_jabatan . '" leveluser="' . $data->level_user . '" selected>' . $data->kode_jabatan . ' - ' . $data->nama_jabatan . '</option>';
                        }
                        ?>
                    </select>
                </fieldset>
            </div>

            <div id="div_cabang" class="col-md-6" <?= $hidden_cabang ?>>
                <fieldset class="form-group">
                    <label><?= $this->lang->line('cabang') ?> <i class="text-danger">*</i></label>
                    <select id="cabang" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        <?php
                            if (isset($data->id_cabang)) {
                                echo '<option value="' . $data->id_cabang . '" selected>' . $data->kode_cabang . ' - ' . $data->nama_cabang . '</option>';
                            }
                        ?>
                    </select>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div id="div_departemen" class="col-md-6" <?= $hidden_departemen ?>>
                <fieldset class="form-group">
                    <label><?= $this->lang->line('departemen') ?> <i class="text-danger">*</i></label>
                    <select id="departemen" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        <?php
                        if (isset($data->id_departemen)) {
                            echo '<option value="' . $data->id_departemen . '" selected>' . $data->kode_departemen . ' - ' . $data->nama_departemen . '</option>';
                        }
                        ?>
                    </select>
                </fieldset>
            </div>

            <div id="div_supervisi" class="col-md-6" <?= $hidden_supervisi ?>>
                <fieldset class="form-group">
                    <label><?= $this->lang->line('supervisi') ?> </label>
                    <select id="supervisi" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                        <?php
                        if (isset($data->id_supervisi)) {
                            echo '<option value="' . $data->id_supervisi . '" selected>' . $data->nik_supervisi . ' - ' . $data->nama_supervisi . '</option>';
                        }
                        ?>
                    </select>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div id="div_cuti" class="col-md-6" <?= $hidden_cuti ?>>
                <fieldset class="form-group">
                    <label><?= $this->lang->line('sisa_cuti_tahunan') ?></label>
                    <input type="text" id="jatah_cuti" class="form-control numberbox" placeholder="<?= $this->lang->line('sisa_cuti_tahunan') ?>" value="<?= isset($data->jatah_cuti) ? $data->jatah_cuti : '' ?>">
                </fieldset>
            </div>
            <div id="div_status" class="col-md-6" <?= $hidden_status ?>>
                <fieldset class="form-group">
                    <label>Status <i class="text-danger">*</i></label>
                    <select class="form-control" id="status">
                        <option value="1" <?= ((isset($data) and $data->status == '1') ? 'selected' : '') ?>><?= $this->lang->line('kontrak') ?></option>
                        <option value="2" <?= ((isset($data) and $data->status == '2') ? 'selected' : '') ?>><?= $this->lang->line('tetap') . ' (' . $this->lang->line('aktif') . ')' ?></option>
                        <?php
                        if (isset($data) && $data->id_karyawan != "") {
                            if(isset($data) && ($data->status == '3' || $data->status == '4')){
                                echo "<option value='3' ".((isset($data) && $data->status == '3') ? 'selected' : '') .">".$this->lang->line('izin_belajar')."</option>";
                                echo "<option value='4' ".((isset($data) && $data->status == '4') ? 'selected' : '') .">".$this->lang->line('tugas_belajar')."</option>";
                            }
                        ?>
                            <option value="5" <?= ((isset($data) && $data->status == '5') ? 'selected' : '') ?>><?= $this->lang->line('resign') ?></option>
                            <option value="6" <?= ((isset($data) && $data->status == '6') ? 'selected' : '') ?>><?= $this->lang->line('dikeluarkan') ?></option>
                            <option value="7" <?= ((isset($data) && $data->status == '7') ? 'selected' : '') ?>><?= $this->lang->line('pensiun') ?></option>
                        <?php
                        }
                        ?>
                    </select>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div id="div_tgl_mulai_kerja" class="col-md-6" <?= $hidden_tgl_mulai_kerja ?>>
                <fieldset class="form-group">
                    <label id="lbl_tgl_mulai_kerja"><?= $this->lang->line('tgl_aktif_bekerja') ?> <i class="text-danger">*</i></label>
                    <?php
                    if (!empty($data->tgl_aktif_bekerja) && $data->tgl_aktif_bekerja != '1970-01-01' && $data->tgl_aktif_bekerja != '0000-00-00') {
                        $tanggal_aktif = date('d-m-Y', strtotime($data->tgl_aktif_bekerja));
                    } else {
                        $tanggal_aktif = "";
                    }
                    ?>
                    <input type="text" id="tgl_aktif_bekerja" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy" value="<?= $tanggal_aktif ?>">
                </fieldset>
            </div>
            <div id="div_tgl_berakhir_kerja" class="col-md-6" <?= $hidden_tgl_berakhir_kerja ?>>
                <fieldset class="form-group">
                    <label id="lbl_tgl_berakhir_kerja"><?= $this->lang->line('tgl_berhenti_bekerja') ?></label>
                    <?php
                    if (!empty($data->tgl_berhenti_bekerja) && $data->tgl_berhenti_bekerja != '1970-01-01' && $data->tgl_berhenti_bekerja != '0000-00-00') {
                        if ($data->tgl_berhenti_bekerja != "0000-00-00") {
                            $tanggal_berhenti = date('d-m-Y', strtotime($data->tgl_berhenti_bekerja));
                        } else {
                            $tanggal_berhenti = "";
                        }
                    } else {
                        $tanggal_berhenti = "";
                    }
                    ?>
                    <input type="text" value="<?= $tanggal_berhenti ?>" name="tgl_berhenti_bekerja" class="form-control datepicker" id="tgl_berhenti_bekerja" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy">
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <fieldset class="form-group">
                    <label>Join Date<i class="text-danger">*</i></label>
                    <?php
                    if (!empty($data->join_date) && $data->join_date != '1970-01-01'  && $data->join_date != '0000-00-00') {
                        $join_date = date('d-m-Y', strtotime($data->join_date));
                    } else {
                        $join_date = "";
                    }
                    ?>
                    <input type="text" id="join_date" value="<?= $join_date ?>" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy">
                </fieldset>
            </div>
        </div>
        <?php
        if (empty($id_karyawan)) {
        ?>
            <div class="row mt-3">
                <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_akun') ?></label></div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <fieldset class="form-group">
                        <label>Username <i class="text-danger">*</i></label>
                        <input type="text" id="username" class="form-control">
                    </fieldset>
                </div>
                <div class="col-md-6">
                    <fieldset class="form-group">
                        <label>Password <i class="text-danger">*</i></label>
                        <input type="text" id="password" class="form-control">
                    </fieldset>
                </div>
            </div>
        <?php
        }
        ?>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body p-0">
                <label><?= $this->lang->line('foto_profil') ?></label>
                <?php
                if ($data->foto == "") {
                    $foto = '';
                } else {
                    $foto = 'data-default-file="' . $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $data->foto . '"';
                }
                ?>
                <input type="hidden" name="foto_lama" id="foto_lama" value="<?= $data->foto ?>">
                <input type="file" name="foto" id="foto" id="input-file-now-custom-1" class="dropify" <?= $foto ?> data-allowed-file-extensions="jpg png jpeg" data-max-file-size="2M">
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-7 text-left">
                <div id="message"></div>
            </div>
            <div class="col-md-5 text-right">
                <button class="btn_save_datadiri btn btn-primary btn-min-width ladda-button" data-style="expand-left"><i class="fa fa-save"></i> <?= $this->lang->line('button_form_simpan') ?></button>
                <?php
                if (!empty($id_karyawan)) { ?>
                    <button class="btn btn-secondary btn-min-width" onclick="detail_datadiri('<?= md5($data->id_karyawan) ?>')">
                        <i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?>
                    </button>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- jQuery file upload -->
<script>
    $(document).ready(function() {

        $('.dropify').dropify(
            <?php if ($this->code_lang == 'id') { ?> {
                    messages: {
                        'default': 'Seret dan lepas atau klik disini',
                        'replace': 'Seret dan lepas atau klik disini',
                        'remove': 'Hapus',
                        'error': 'Ooops, terjadi kesalahaan.'
                    },
                    error: {
                        'fileSize': 'The file size is too big ({{ value }} max).',
                        'minWidth': 'The image width is too small ({{ value }}}px min).',
                        'maxWidth': 'The image width is too big ({{ value }}}px max).',
                        'minHeight': 'The image height is too small ({{ value }}}px min).',
                        'maxHeight': 'The image height is too big ({{ value }}px max).',
                        'imageFormat': 'Format file tidak diperbolehkan ({{ value }} only).'
                    }
                }
            <?php } ?>
        );

        foto = $('#form_input #foto').dropify();

        foto.on('dropify.afterClear', function(event, element) {
            $("#foto_lama").val("");
        });
    });
</script>
