<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Aktivitas extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/master/Aktivitas_m');
    }

    public function list_data(){
        $list = $this->Aktivitas_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();

            $row[] = '<span class="sort" style="cursor:-webkit-grab; cursor:grab;" title="Tarik keatas / kebawah" data-key="' . $field->id_activity_m . '">
                        <i class="fa fa-sort"></i>&nbsp&nbsp'. $no.
                    '</span>';

            $row[] = htmlspecialchars($field->nama);
            $row[] = htmlspecialchars($field->poin);
            $row[] = $this->_flag_badge($field->flag_lokasi);
            $row[] = $this->_flag_badge($field->flag_upload_foto);

            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_activity_m) . '" class="btn_edit_m_aktivitas fa fa-edit (alias) "> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_activity_m) . '" class="btn_delete_m_aktivitas fa fa-trash"></i></a>';
            $row[] = $btn_edit. '&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Aktivitas_m->count_all(),
            "recordsFiltered" => $this->Aktivitas_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Aktivitas_m->getDataById($id);
		}
		$this->load->view('sales_activity/master/aktivitas/form',$data);
    }

    public function save(){
        $id = $this->input->post('id_activity_m');

        $data = array('nama'            => $this->input->post('nama'),
                    'poin'              => preg_replace('/[^0-9]/', '', $this->input->post('poin')),
                    'flag_lokasi'       => $this->input->post('flag_lokasi'),
                    'flag_upload_foto'  => $this->input->post('flag_upload_foto'),
                    'id_company'        => $this->id_company);

        $this->Aktivitas_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Aktivitas_m->delete($id);
    }

    public function update_order(){
        $order = $this->input->post('order');

        $data = array();
        foreach ($order as $key) {
            $data[] = [
                'concat(id_activity_m,id_company)' => $key['id_activity_m'] . $this->id_company,
                'no_urut' => $key['no_urut']
            ];
        }
        $this->Aktivitas_m->update_order($data);
    }

    private function _flag_badge($flag = "0"){
        if($flag == "1"){
            $badge = '<div class="badge badge-success">' . 'Ya' . '</div>';
        }else{
            $badge = '<div class="badge badge-danger">' . 'Tidak' . '</div>';
        }

        return $badge;
    }
}