<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Kanban_detail extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['sales_activity/kanban/Kanban_detail_m' => 'model', 'sales_activity/kanban/Kanban_m' => 'kanban']);
    }

    public function detail_perusahaan($id, $periode)
    {
        $periode ?: $periode = date('Y-m');
        $split = explode('-', $periode);
        $tahun = $split[0];
        $bulan = $split[1];

        $data['id']       = $id;
        $data['periode']  = $periode;
        $data['pipeline'] = $this->model->get_detail_pipeline($id);
        $data['tahapan']  = $this->kanban->get_data_tahapan_trx($tahun, $bulan);
        $this->load->view('sales_activity/kanban/detail/detail_perusahaan', $data);
    }

    public function detail_perusahaan_form($id)
    {
        $data['id']       = $id;
        $data['pipeline'] = $this->model->get_detail_pipeline($id);
        $this->load->view('sales_activity/kanban/detail/detail_perusahaan_form', $data);
    }

    public function update_perusahaan()
    {
        $id                   = $this->input->post('id');
        $jenis_pelanggan      = $this->input->post('jenis_pelanggan');
        $pelanggan            = $this->input->post('pelanggan');
        $jenis_perusahaan     = $this->input->post('jenis_perusahaan');
        $lead_source          = $this->input->post('lead_source');
        $alamat_perusahaan    = $this->input->post('alamat_perusahaan');
        $provinsi_perusahaan  = $this->input->post('provinsi_perusahaan');
        $kota_perusahaan      = $this->input->post('kota_perusahaan');
        $kecamatan_perusahaan = $this->input->post('kecamatan_perusahaan');
        $kelurahan_perusahaan = $this->input->post('kelurahan_perusahaan');
        $nama_pic             = $this->input->post('nama_pic');
        $email_pic            = $this->input->post('email_pic');
        $telp_pic             = $this->input->post('telp_pic');
        $title                = $this->input->post('title');
        $keterangan           = $this->input->post('keterangan');

        // validation
        if (!$id) return __response_update(false);
        if (!$jenis_pelanggan) {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_jenis_pelanggan_kosong')]) . '</font>';
        }
        if ($jenis_pelanggan == 'perusahaan') {
            if (!$pelanggan) {
                return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_pilih_perusahaan_kosong')]) . '</font>';
            }
            if (!$jenis_perusahaan) {
                return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_pilih_jenis_perusahaan_kosong')]) . '</font>';
            }
            if ($nama_pic == '') {
                return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_nama_kosong')]) . '</font>';
            }
            // reformat data
            $nama_pic = preg_replace('/[^a-zA-Z0-9\.\,\-\' ]/', '', $nama_pic);
        } else {
            if (!$pelanggan) {
                return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_nama_kosong')]) . '</font>';
            }
            // reformat data
            $pelanggan = preg_replace('/[^a-zA-Z0-9\.\,\-\' ]/', '', $pelanggan);
        }
        if (!$lead_source) {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_pilih_lead_source_kosong')]) . '</font>';
        }
        if ($alamat_perusahaan == '') {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_alamat_perusahaan')]) . '</font>';
        }
        if (!$provinsi_perusahaan) {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_provinsi')]) . '</font>';
        }
        if (!$kota_perusahaan) {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_kota')]) . '</font>';
        }
        if ($telp_pic == '') {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_telp_pic_kosong')]) . '</font>';
        }
        if ($title == '') {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_judul')]) . '</font>';
        }

        // reformat data
        $telp_pic = preg_replace('/[^0-9]/', '', $telp_pic);

        // data insert new
        $pelanggan_is_exist = $this->db->get_where('sales_pelanggan', ['id_company' => $this->id_company, 'id_pelanggan' => $pelanggan])->num_rows();
        $data_pelanggan = [
            'id_jenis_perusahaan_m' => $jenis_perusahaan,
            'id_lead_m'             => $lead_source,
            'kategori_pelanggan'    => $jenis_pelanggan,
            'alamat'                => $alamat_perusahaan,
            'id_provinsi'           => $provinsi_perusahaan,
            'id_kota'               => $kota_perusahaan,
            'id_kecamatan'          => !empty($kecamatan_perusahaan) ? $kecamatan_perusahaan : "",
            'id_kelurahan'          => !empty($kelurahan_perusahaan) ? $kelurahan_perusahaan : "",
            'pic_nama'              => ($jenis_pelanggan == 'perorangan') ? $pelanggan : $nama_pic,
            'pic_email'             => $email_pic,
            'pic_telp'              => $telp_pic,
            'id_company'            => $this->id_company,
            'user_input'            => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
        ];

        if ($pelanggan_is_exist > 0) {
            $id_pelanggan_update = $pelanggan;
        } else {
            $id_pelanggan_update = "";
            $data_pelanggan = array_merge($data_pelanggan, [
                'id_pelanggan'    => $this->fungsi->getNextId('sales_pelanggan', 'id_pelanggan', $this->id_company, 5),
                'nama_perusahaan' => $pelanggan,
                'jenis'           => '2',
            ]);
        }

        $nama_lead_source = $this->db->select('nama')->where(['id_company' => $this->id_company, 'id_lead_m' => $lead_source])->get('sales_lead_m')->row()->nama;
        
        $data_pipeline_main = [
            'id_lead_m'        => $lead_source,
            'nama_lead_source' => $nama_lead_source,
            'pic_nama'         => ($jenis_pelanggan == 'perorangan') ? $pelanggan : $nama_pic,
            'pic_email'        => $email_pic,
            'pic_telp'         => $telp_pic,
            'title'            => $title,
            'keterangan'       => $keterangan
        ];

        $this->model->update_perusahaan($data_pelanggan, $data_pipeline_main, $id, $id_pelanggan_update);
    }

    public function detail_layanan($id)
    {
        $data['id']      = $id;
        $data['layanan'] = $this->model->get_detail_layanan($id)->result();
        $this->load->view('sales_activity/kanban/detail/detail_layanan', $data);
    }

    public function detail_layanan_hapus($id, $id_layanan)
    {
        $data['id']      = $id;
        $data['layanan'] = $this->model->get_detail_layanan($id, $id_layanan)->row();
        $this->load->view('sales_activity/kanban/detail/hapus_layanan', $data);
    }

    public function save_layanan()
    {
        $harga            = $this->input->post('harga');
        $jumlah           = $this->input->post('jumlah');
        $diskon           = $this->input->post('diskon');
        $id_product       = $this->input->post('id_product');
        $id_pipeline_main = $this->input->post('id_main');

        // validation
        if (!$id_product) {
            return __response_save(false, ['message' => '<i class="fa fa-exclamation-triangle pr-1"></i>' . $this->lang->line('error_pilih_layanan_kosong')]);
        }

        // insert layanan
        $id_pipeline_layanan = $this->fungsi->getNextId('sales_pipeline_layanan', 'id_pipeline_layanan', $this->id_company, 5);
        preg_match('/^([^#]+)/', $id_product, $matches);
        $id_product  = $matches[1];
        $harga       = (int)$harga;
        $jumlah      = (int)$jumlah;
        $diskon      = $diskon ? (float)$diskon : 0;
        $harga_total = ($harga * $jumlah) - (($harga * $jumlah) * $diskon / 100);

        $data_pipeline_layanan = [
            'id_pipeline_layanan' => $id_pipeline_layanan,
            'id_pipeline_main'    => $id_pipeline_main,
            'id_product_m'        => $id_product,
            'harga'               => $harga,
            'jumlah'              => $jumlah,
            'diskon'              => $diskon,
            'harga_total'         => $harga_total,
            'id_company'          => $this->id_company,
            'user_input'          => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
        ];

        $pipeline = (object)array_values($this->kanban->get_data_list_kanban('', '', '', '', '', $id_pipeline_main))[0][0];
        if ($pipeline->status == 'approve') {
            // get data
            $tahapan = $this->kanban->get_data_tahapan_trx($pipeline->tahun, $pipeline->bulan, $pipeline->id_tahapan_m)[0];
            // update pipeline_trx
            $data_pipeline_trx = [
                'update'    => $harga_total,
                'condition' => [
                    'id_company'       => $this->id_company,
                    'id_karyawan'      => $pipeline->id_karyawan,
                    'tahun'            => $pipeline->tahun,
                    'bulan'            => $pipeline->bulan,
                    'id_pipeline_main' => $id_pipeline_main,
                    'id_tahapan'       => $tahapan->id_tahapan_m
                ]
            ];
            // update target_personil_r
            if ($tahapan->jenis == 'wont') {
                $data_personil_r = [
                    'nominal' => $harga_total,
                    'update'  => [
                        'user_update' => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
                        'tgl_update'  => date('Y-m-d H:i:s'),
                    ],
                    'condition' => [
                        'id_company'  => $this->id_company,
                        'id_karyawan' => $pipeline->id_karyawan,
                        'tahun'       => $pipeline->tahun,
                        'bulan'       => $pipeline->bulan,
                    ]
                ];
            }
        }
        $data = [
            'pipeline_layanan' => $data_pipeline_layanan,
            'pipeline_trx'     => $data_pipeline_trx,
            'personil_r'       => $data_personil_r
        ];
        $this->model->save_layanan($data, $pipeline->status, $tahapan->jenis);
    }

    public function update_layanan()
    {
        $harga            = $this->input->post('harga');
        $jumlah           = $this->input->post('jumlah');
        $diskon           = $this->input->post('diskon');
        $id_product       = $this->input->post('id_product');
        $id_layanan       = $this->input->post('id_layanan');
        $id_pipeline_main = $this->input->post('id_main');

        // validation
        if (!$id_product) {
            return __response_update(false, ['message' => '<i class="fa fa-exclamation-triangle pr-1"></i>' . $this->lang->line('error_pilih_layanan_kosong')]);
        }
        if (!$id_layanan) {
            return __response_update(false);
        }

        // update layanan
        preg_match('/^([^#]+)/', $id_product, $matches);
        $id_product  = $matches[1];
        $harga       = (int)$harga;
        $jumlah      = (int)$jumlah;
        $diskon      = $diskon ? (float)$diskon : 0;
        $harga_total = ($harga * $jumlah) - (($harga * $jumlah) * $diskon / 100);

        $data_pipeline_layanan = [
            'update' => [
                'id_product_m' => $id_product,
                'harga'        => $harga,
                'jumlah'       => $jumlah,
                'diskon'       => $diskon,
                'harga_total'  => $harga_total,
                'user_update'  => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
                'tgl_update'   => date('Y-m-d H:i:s')
            ],
            'condition' => [
                'id_pipeline_layanan' => $id_layanan
            ]
        ];

        $pipeline = (object)array_values($this->kanban->get_data_list_kanban('', '', '', '', '', $id_pipeline_main))[0][0];
        if ($pipeline->status == 'approve') {
            // get data
            $layanan  = $this->model->get_ttl_layanan($id_pipeline_main, '', $id_layanan);
            $tahapan  = $this->kanban->get_data_tahapan_trx($pipeline->tahun, $pipeline->bulan, $pipeline->id_tahapan_m)[0];
            // update pipeline_trx
            $data_pipeline_trx = [
                'update' => [
                    'nominal_layanan' => ($layanan) ? ($layanan->nominal_layanan + $harga_total) : $harga_total,
                ],
                'condition' => [
                    'id_company'       => $this->id_company,
                    'id_karyawan'      => $pipeline->id_karyawan,
                    'tahun'            => $pipeline->tahun,
                    'bulan'            => $pipeline->bulan,
                    'id_pipeline_main' => $id_pipeline_main,
                    'id_tahapan'       => $tahapan->id_tahapan_m
                ]
            ];
            // update target_personil_r
            if ($tahapan->jenis == 'wont') {
                $layanan_exist   = $this->model->get_ttl_layanan($id_pipeline_main, $id_layanan);
                $new_nominal     = $layanan_exist->nominal_layanan - $harga_total;
                $data_personil_r = [
                    'nominal' => $new_nominal,
                    'update' => [
                        'user_update' => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
                        'tgl_update'  => date('Y-m-d H:i:s'),
                    ],
                    'condition' => [
                        'id_company'  => $this->id_company,
                        'id_karyawan' => $pipeline->id_karyawan,
                        'tahun'       => $pipeline->tahun,
                        'bulan'       => $pipeline->bulan,
                    ]
                ];
            }
        }

        $data = [
            'pipeline_layanan' => $data_pipeline_layanan,
            'pipeline_trx'     => $data_pipeline_trx,
            'personil_r'       => $data_personil_r
        ];
        $this->model->update_layanan($data, $pipeline->status, $tahapan->jenis);
    }

    public function delete_layanan()
    {
        $id_layanan       = $this->input->post('id_layanan');
        $id_pipeline_main = $this->input->post('id_main');

        // validation
        if (!$id_layanan) {
            return __response_delete(false);
        }

        $pipeline = (object)array_values($this->kanban->get_data_list_kanban('', '', '', '', '', $id_pipeline_main))[0][0];
        if ($pipeline->status == 'approve') {
            // get data
            $layanan  = $this->model->get_ttl_layanan($id_pipeline_main, $id_layanan);
            $tahapan  = $this->kanban->get_data_tahapan_trx($pipeline->tahun, $pipeline->bulan, $pipeline->id_tahapan_m)[0];
            // update pipeline_trx
            $data_pipeline_trx = [
                'update'    => $layanan->nominal_layanan,
                'condition' => [
                    'id_company'       => $this->id_company,
                    'id_karyawan'      => $pipeline->id_karyawan,
                    'tahun'            => $pipeline->tahun,
                    'bulan'            => $pipeline->bulan,
                    'id_pipeline_main' => $id_pipeline_main,
                    'id_tahapan'       => $tahapan->id_tahapan_m
                ]
            ];
            // update target_personil_r
            if ($tahapan->jenis == 'wont') {
                $data_personil_r = [
                    'nominal' => $layanan->nominal_layanan,
                    'update'  => [
                        'user_update' => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
                        'tgl_update'  => date('Y-m-d H:i:s'),
                    ],
                    'condition' => [
                        'id_company'  => $this->id_company,
                        'id_karyawan' => $pipeline->id_karyawan,
                        'tahun'       => $pipeline->tahun,
                        'bulan'       => $pipeline->bulan,
                    ]
                ];
            }
        }

        $data = [
            'pipeline_layanan' => $id_layanan,
            'pipeline_trx'     => $data_pipeline_trx,
            'personil_r'       => $data_personil_r
        ];

        $this->model->delete_layanan($data, $pipeline->status, $tahapan->jenis);
    }

    public function detail_aktivitas($id)
    {
        $data['id']        = $id;
        $data['aktivitas'] = $this->model->get_detail_aktivitas($id);
        $pipeline          = $this->model->get_status_pipeline($id);
        $data['pipeline']  = $pipeline;

        if(in_array($pipeline->jenis, ['wont', 'lost'])){
            $data['keterangan_wont_lost'] = $this->model->get_keterangan_wont_lost($pipeline->id_pipeline_main, $pipeline->nama_tahapan);
        }

        $this->load->view('sales_activity/kanban/detail/detail_aktivitas', $data);
    }

    public function detail_aktivitas_form($id, $aktivitas = '')
    {
        $data['id']           = $id;
        $data['aktivitas']    = [];
        $data['is_new']       = true;
        $data['id_aktivitas'] = '';
        if ($aktivitas) {
            $data['is_new']       = false;
            $data['aktivitas']    = $this->model->preview_aktivitas($aktivitas);
            $data['id_aktivitas'] = $aktivitas;
        }

        $this->load->view('sales_activity/kanban/detail/detail_aktivitas_form', $data);
    }

    public function detail_aktivitas_preview($id, $po_or_fail = "")
    {
        $data['preview'] = $this->model->preview_aktivitas($id, $po_or_fail);
        $this->load->view('sales_activity/kanban/detail/detail_aktivitas_preview', $data);
    }

    public function save_aktivitas()
    {
        $id             = $this->input->post('id');
        $jenis_activity = $this->input->post('jenis_activity');
        $tgl_activity   = $this->input->post('tgl_activity');
        $jam_activity   = $this->input->post('jam_activity');
        $keterangan     = $this->input->post('keterangan');

        // validation
        if (!$id) return __response_save(false);
        if (!$jenis_activity) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_pilih_aktivitas_kosong') . '</font>']);
        if (!$tgl_activity) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_tgl_aktivitas_kosong') . '</font>']);
        if (!$jam_activity) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_jam_aktivitas_kosong') . '</font>']);
        if (!$keterangan) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_ket_aktivitas_kosong') . '</font>']);
        $master_activity = $this->db->select('nama, poin')
            ->from('sales_activity_m')
            ->where('id_activity_m', $jenis_activity)
            ->where('id_company', $this->id_company)
            ->get();
        if ($master_activity->num_rows() == 0) return __response_save(false);
        $index_activity = $this->db->select('id_karyawan')
            ->from('sales_pipeline_activity')
            ->where('id_company', $this->id_company)
            ->where('id_karyawan', $this->id_karyawan)
            ->where('tgl_activity', date('Y-m-d', strtotime($tgl_activity)))
            ->where('jam_activity', $jam_activity)
            ->get();
        if ($index_activity->num_rows() > 0) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> Sudah ada aktivitas pada tanggal dan jam tersebut.</font>']);

        // last record / 2nd last record
        $status_pipeline = $this->model->get_status_pipeline($id);
        $exclude_last_record = false;
        if ($status_pipeline->status == 'pengajuan' && $status_pipeline->jenis != 'incoming') {
            $exclude_last_record = true;
        }

        // get data kanban
        $pipeline = array_values($this->kanban->get_data_list_kanban('', '', '', '', '', $id, $exclude_last_record))[0][0];

        $data = [
            'id_pipeline_main'     => $pipeline['id_pipeline_main'],
            'id_pipeline_main_log' => $pipeline['id_pipeline_main_log'],
            'id_pelanggan'         => $pipeline['id_pelanggan'],
            'id_karyawan'          => $this->id_karyawan,
            'nik'                  => $this->nik_karyawan,
            'nama_karyawan'        => $this->nm_karyawan,
            'tgl_activity'         => date('Y-m-d', strtotime($tgl_activity)),
            'jam_activity'         => $jam_activity,
            'jenis_activity'       => $master_activity->row()->nama,
            'keterangan'           => $keterangan,
            'poin'                 => $master_activity->row()->poin,
            'id_group_m'           => $pipeline['id_group'],
            'nama_group'           => $pipeline['kode_group']. " - ". $pipeline['kode_group'],
            'id_company'           => $this->id_company,
            'user_input'           => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
        ];

        // tanpa approval
        if ($this->is_sales_skip_approval) {
            $data['status']      = 'approve';
            $data['tgl_approve'] = date('Y-m-d H:i:s');
        }

        $this->model->save_aktivitas($data);
    }

    public function update_aktivitas()
    {
        $id             = $this->input->post('id');
        $tgl_activity   = $this->input->post('tgl_activity');
        $jam_activity   = $this->input->post('jam_activity');
        $keterangan     = $this->input->post('keterangan');

        // validation
        if (!$id) return __response_save(false);
        if (!$tgl_activity) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_tgl_aktivitas_kosong') . '</font>']);
        if (!$jam_activity) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_jam_aktivitas_kosong') . '</font>']);
        if (!$keterangan) return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> ' . $this->lang->line('error_ket_aktivitas_kosong') . '</font>']);
        $index_activity = $this->db->select('status')
            ->from('sales_pipeline_activity')
            ->where('id_company', $this->id_company)
            ->where('id_karyawan', $this->id_karyawan)
            ->where('tgl_activity', date('Y-m-d', strtotime($tgl_activity)))
            ->where('jam_activity', $jam_activity)
            ->get();
        if ($index_activity->num_rows() > 0 && $index_activity->row()->status == 'approve') return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> Sudah ada aktivitas pada tanggal dan jam tersebut.</font>']);

        $data = [
            'tgl_activity' => date('Y-m-d', strtotime($tgl_activity)),
            'jam_activity' => $jam_activity,
            'keterangan'   => $keterangan
        ];

        $this->model->update_aktivitas($data, $id);
    }
}
