<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Daily_activity extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('sales_activity/daily_activity/Daily_activity_m', 'model');
    }

    public function index()
    {
        $data['judul']           = 'Daily Activity';
        $data['periode_mulai']   = date('d-m-Y', time());
        $data['periode_selesai'] = date('d-m-Y',  time());
        if ($this->is_sales_admin === true || $this->level_user == '1' || $this->is_sales_atasan === true) {
            $data['karyawan'] = 'all';
        } else {
            $data['karyawan'] = $this->id_karyawan;
        }
        $this->load->view('sales_activity/daily_activity/index', $data);
    }

    public function list_data($mulai, $selesai, $status, $pelanggan, $karyawan, $group)
    {
        // reformat date
        $mulai   = $mulai ? date('Y-m-d', strtotime($mulai)) : '';
        $selesai = $selesai ? date('Y-m-d', strtotime($selesai)) : '';

        $list = $this->model->get_datatables($mulai, $selesai, $status, $pelanggan, $karyawan, $group);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = date('d-m-Y H:i', strtotime($field->waktu));
            if ($this->is_sales_admin === true || $this->level_user == '1' || $this->is_sales_atasan === true) {
                $row[] = $field->nama_lengkap . '<p class="text-light" style="font-size: 11px">' . $field->nik . '</p>';
            }
            if ($field->tabel === 'log') {
                if ($field->kategori === 'move') {
                    $aktivitas = explode(',', $field->aktivitas_pindah_bulan);
                    $row[] = '<i class="text-warning">' . $aktivitas[0] . '</i> ' . $aktivitas[1] . ' <i class="fa fa-long-arrow-right"></i> ' . $aktivitas[2];
                } else {
                    if ($field->aktivitas == 'Move') {
                        $row[] = '<i class="text-warning">' . $field->aktivitas . '</i> ' . $field->tahapan_sebelum . ' <i class="fa fa-long-arrow-right"></i> ' . $field->tahapan_sekarang;
                    } else {
                        $row[] = '<i class="text-primary">' . $field->aktivitas . '</i> ' . $field->tahapan_sekarang;
                    }
                }
            } else {
                $row[] = $field->aktivitas;
            }
            $row[] = ($field->poin != '') ? number_format($field->poin, 0, ',', '.') : '-';
            $row[] = htmlspecialchars(($field->kategori === 'move') ? $field->keterangan : ($field->aktivitas_pindah_bulan ?: $field->keterangan));
            $row[] = $field->nama_perusahaan;
            $row[] = $field->nama_lead_source ?: '-';

            if ($field->status === 'approve') {
                $row[] = '<span class="badge badge-success">' . $this->lang->line('disetujui') . '</span>';
            } elseif ($field->status === 'pengajuan') {
                $row[] = '<span class="badge badge-warning">' . $this->lang->line('pengajuan') . '</span>';
            } else {
                $row[] = '<span class="badge badge-danger">' . $this->lang->line('ditolak') . '</span>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($mulai, $selesai, $status, $pelanggan, $karyawan, $group),
            "recordsFiltered" => $this->model->count_filtered($mulai, $selesai, $status, $pelanggan, $karyawan, $group),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }
}
