<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Data_kelengkapan_file_histori extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan/Data_kelengkapan_file_histori_m', 'model');
        $this->load->helper('approval');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'file_histori';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    function data($id_karyawan_md5)
    {
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['tab_aktif']       = 'histori';
        $data['tab']             = $this->load->view('karyawan/data_kelengkapan_file/tab', $data, true);
        $this->load->view('karyawan/data_kelengkapan_file/histori/home', $data);
    }

    function table()
    {
        $list = $this->model->get_datatables();
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row    = array();
            $row[]  = $no;
            $row[]  = ucwords(keterangan_action($this->lang->line('data_kelengkapan_file'), $field->action));
            $row[]  = date('d-m-Y H:i:s', strtotime($field->tanggal_input));
            $row[]  = '<a onclick="detail(\'' . md5($field->id) . '\')"><i class="fa fa-file" aria-hidden="true"></i></a>';
            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all(),
            "recordsFiltered" => $this->model->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    function detail($id_md5)
    {
        $data['data'] = $this->model->get_data($id_md5);
        $this->load->view('karyawan/data_kelengkapan_file/histori/detail', $data);
    }
}

/* End of file data_karyawan/data_kelengkapan_file/Histori.php */
