<script type="text/javascript">
    $(document).ready(function() {
        $(".numberbox").keydown(function (e) {
            // Allow: backspace, delete, tab, escape, enter and
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                    // let it happen, don't do anything
                    return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
                $("#jumlah_barang").focus();
                return false();
            }
        });
    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_jenis_izin" class="form-control" value="<?= ((isset($data))?md5($data->id_jenis_izin):'') ?>">
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Kode Jenis Izin <i class="text-danger">*</i></label>
                    <input type="text" id="kd_jenis_izin" class="form-control" value="<?= ((isset($data))?$data->kode_izin:'') ?>" maxlength="5">
                    <input type="hidden" id="kd_jenis_izin_old" value="<?= ((isset($data))?$data->kode_izin:'') ?>">
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label>Jenis Izin <i class="text-danger">*</i></label>
                    <select id="jenis_izin" name="jenis_izin" class="form-control">
                        <option value="">Pilih Jenis Izin</option>
                        <option value="sakit" <?= ((isset($data) AND $data->jenis_izin == 'sakit')?'selected':'') ?>>Sakit</option>
                        <option value="izin" <?= ((isset($data) AND $data->jenis_izin == 'izin')?'selected':'') ?>>Izin</option>
                        <option value="cuti" <?= ((isset($data) AND $data->jenis_izin == 'cuti')?'selected':'') ?>>Cuti</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12">
            <div class="form-group">
                <label>Nama Jenis izin <i class="text-danger">*</i></label>
                <input type="text" id="nm_jenis_izin" class="form-control" value="<?= ((isset($data))?$data->nama:'') ?>">
            </div>
    </div>

    <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Max Izin (Hari)</label>
                    <input type="text" id="max_izin" class="form-control numberbox" value="<?= ((isset($data))?$data->max_izin:'') ?>" max="">
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label>Mengurangi Cuti Tahunan</label>
                    <select id="flag" name="flag" class="form-control">
                        <option value="0" <?= ((isset($data) AND $data->flag == '0')?'selected':'') ?>>Tidak</option>
                        <option value="1" <?= ((isset($data) AND $data->flag == '1')?'selected':'') ?>>Ya</option>
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

