<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Shift extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Shift_m');

		$this->level_user   = $this->session->userdata("level_user");
		$this->level_khusus = $this->session->userdata("level_khusus");
        $this->id_company   = $this->session->userdata("id_company");
        $this->id_cabang    = $this->session->userdata("id_cabang");
        $this->multi_cabang    = $this->session->userdata("multi_cabang");
    }

	public function index(){
		$data['judul'] = 'Shift';
		$data['aktif'] = 'shift';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('shift/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$id_cabang = $this->input->post('id_cabang');
		$list = $this->Shift_m->get_datatables($id_cabang);
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;

			if(in_array($this->level_user,["1","4"]) || $this->multi_cabang == true){
				$row[] = $field->kode_cabang." - ".$field->nama_cabang;
			}

			$row[] = $field->kode_shift;
			$row[] = $field->nama_shift;

			if ($field->libur == "1") {
				$label = '<span class="badge badge-success">Ya</span>';
				$jam_masuk = "-";
				$jam_pulang = "-";
				$start_absen_masuk = "-";
				$batas_absen_pulang = "-";
			}else{
				$label = '<span class="badge badge-danger">Tidak</span>';
				$jam_masuk 			= date_format(date_create($field->jam_masuk),"H:i");
				$jam_pulang 		= date_format(date_create($field->jam_pulang),"H:i");
				$start_absen_masuk 	= date_format(date_create($field->start_absen_masuk),"H:i");
				$batas_absen_pulang = date_format(date_create($field->batas_absen_pulang),"H:i");
			}

			if ($field->flag_jam_pulang == "1") {
				$keterangan = '<span class="badge badge-danger">Lewat Hari</span>';
			}else{
				$keterangan = "";
			}

			if ($field->flag_batas_absen_pulang == "1") {
				$keterangan2 = '<span class="badge badge-danger">Lewat Hari</span>';
			}else{
				$keterangan2 = "";
			}

			$row[] = $label;
			$row[] = $start_absen_masuk;
			$row[] = $jam_masuk;
			$row[] = $jam_pulang."<br>".$keterangan;
			$row[] = $batas_absen_pulang."<br>".$keterangan2;

			if(in_array($this->session->userdata('level_user'), array("1","5")) || in_array($this->session->userdata('level_user'), array("1"))) {
				$row[] = '<a href="#" class="text-warning" title="EDIT">
								<i id="'.md5($field->id_master_shift).'" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
							<a href="#" class="text-danger" title="HAPUS">
								<i id="'.md5($field->id_master_shift).'" class="btn_delete fa fa-trash"></i>
							</a>';
			}
	
			$data[] = $row;
		}
	
			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Shift_m->count_all($id_cabang),
							"recordsFiltered" => $this->Shift_m->count_filtered($id_cabang),
							"data"            => $data);
	
		$output = __response($this->MY_response, $output);
				
		echo json_encode($output);
	}

	public function form($id=null){
		$id_company = $this->session->userdata('id_company');
		if($id==null){
			$this->load->view('shift/form',$data);
		}else{
			$data['data'] = $this->Shift_m->getDataById($id);
			$this->load->view('shift/form',$data);
		}
		
	}

	public function save(){
		$id_shift = $this->input->post('id_shift');
		
		if($this->input->post('libur') == '1') {
			$jam_masuk = "";
			$jam_pulang = "";
			$minimal_jam_masuk = "";
			$maksimal_jam_pulang = "";
			$flag_jam_pulang = '0';
			$flag_batas_absen_pulang = '0';
		}else{
			$jam_masuk = $this->input->post('jam_masuk');
			$jam_pulang = $this->input->post('jam_pulang');
			$minimal_jam_masuk = $this->input->post('minimal_jam_masuk');
			$maksimal_jam_pulang = $this->input->post('maksimal_jam_pulang');

			$date_now = date("Y-m-d");
			$jam_masuk_ymdhis = date_format(date_create($date_now." ".$jam_masuk.":00"),"Y-m-d H:i:s");
			$minimal_jam_masuk_ymdhis = date_format(date_create($date_now." ".$minimal_jam_masuk.":00"),"Y-m-d H:i:s");
			$jam_pulang_ymdhis = date_format(date_create($date_now." ".$jam_pulang.":00"),"Y-m-d H:i:s");
			$maksimal_jam_pulang_ymdhis = date_format(date_create($date_now." ".$maksimal_jam_pulang.":00"),"Y-m-d H:i:s");

			if($minimal_jam_masuk_ymdhis > $jam_masuk_ymdhis){
				$message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Minimal jam masuk harus lebih kecil dari jam masuk</font>');
				return __response_save(false,$message);
			}


			if($jam_pulang_ymdhis < $jam_masuk_ymdhis){
				$flag_jam_pulang = '1';
				$flag_batas_absen_pulang = '1';
			}else{
				$flag_jam_pulang = '0';
				if($maksimal_jam_pulang_ymdhis < $jam_pulang_ymdhis){
					$flag_batas_absen_pulang = '1';
				}else{
					$flag_batas_absen_pulang = '0';
				}
			}
		}

		$data = array('kode_shift'				=>$this->input->post('kd_shift'),
					'nama_shift'				=>$this->input->post('nm_shift'),
					'libur'						=>$this->input->post('libur'),
					'jam_masuk'					=>$jam_masuk,
					'jam_pulang'				=>$jam_pulang,
					'start_absen_masuk'			=>$minimal_jam_masuk,
					'batas_absen_pulang'		=>$maksimal_jam_pulang,
					'flag_jam_pulang' 			=>$flag_jam_pulang,
					'flag_batas_absen_pulang' 	=>$flag_batas_absen_pulang,
					'id_cabang'					=>$this->input->post('id_cabang'),
					'id_company' 				=>$_SESSION['id_company']);

		$this->Shift_m->save($data,$id_shift);
	}

	public function delete(){
		$id = $this->input->post("id_shift");
		$this->Shift_m->delete($id);
	}
}
