<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id" class="form-control" value="<?= ((isset($data)) ? md5($data->id_karyawan) : '') ?>">
    
    <div class="form-group">
        <label><?= $this->lang->line('nama_karyawan'); ?> <span class="text-danger">*</span></label>
        <select class="form-control" id="id_karyawan" style="width: 100%">
            <?php echo '<option value="' . $data->id_karyawan . '" selected>' . $data->nik . ' - ' . $data->nama_lengkap . '</option>' ?>;
        </select>
    </div>

    <div class="form-group">
        <label><?= $this->lang->line('group_area'); ?> <span class="text-danger">*</span></label>
        <select class="form-control" id="id_group_m" style="width: 100%" multiple="multiple">
            <?php
                if(!empty($data->id_group_m)){
                    foreach ($group as $group) {
                        echo '<option value="' . $group['id_group_m'] . '" selected>' . $group['nama_group'] . '</option>';
                    }
                }
            ?>;
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none" onclick="new_input(this)"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        dropdown_karyawan();
        dropdown_group_area();
            
        $("#id_group_m").on("select2:select", function(e) {
            var selectedValues = [];
            var selectedValues = $(this).val();
            var allValue = "all";
            
            if (selectedValues.includes(allValue)) {
                // Jika "All" dipilih, hapus semua opsi lain & hanya biarkan "All" tetap dipilih
                $(this).val([allValue]).trigger("change");
            } else {
                // Jika ada opsi lain yang dipilih, hapus "All" dari daftar pilihan
                var index = selectedValues.indexOf(allValue);
                if (index !== -1) {
                    selectedValues.splice(index, 1);
                    $(this).val(selectedValues).trigger("change");
                }
            }
        });
    });

    function dropdown_group_area(){
        var opsi_all = "yes";
        $("#id_group_m").select2({
            placeholder: "Pilih Group",
            allowClear: true,
            // width: 'resolve',
            ajax: {
                url: '<?= route("sales_activity.master.dropdown.group.area") ?>' + '/' + opsi_all,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
    
    function dropdown_karyawan(){
        $("#id_karyawan").select2({
            placeholder: "<?= $this->lang->line('pilih_karyawan'); ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan.aktif.sales.activity") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
</script>
