<script type="text/javascript">
    $(function() {
        $('#tambah_pembulatan').on('click', function() {
            if (!validate_pembulatan(true)) return false;

            // hide delete button
            $(".hapus_pembulatan").addClass("hidden");

            const min = parseInt($(".row_pembulatan:last input:eq(1)").val()) + 1;
            let row_pembulatan = '<div class="row_pembulatan border border-light p-1 rounded mb-1"><div onclick="hapus_pembulatan($(this))" class="hapus_pembulatan position-absolute" style="right:15px"><span class="badge badge-pill badge-danger cursor-pointer position-relative" title="Hapus" style="top:-25px">X</span></div><div class="row"><div class="col-md-3"><div class="input-group"><input type="number" min="' + min + '" max="59" class="form-control" oninput="format_input(this,/^[0-9]{1,2}$/,0,59)" placeholder="0" style="height:30px;font-size:11px"><div class="input-group-append" style="height:30px"><span class="input-group-text" style="font-size:11px;padding:0 10px">menit</span></div></div><div></div></div><div class="col-md-1 text-center"><span style="font-size:11px">s/d</span></div><div class="col-md-3"><div class="input-group"><input type="number" min="' + min + '" max="59" class="form-control" oninput="format_input(this,/^[0-9]{1,2}$/,0,59)" placeholder="0" style="height:30px;font-size:11px"><div class="input-group-append" style="height:30px"><span class="input-group-text" style="font-size:11px;padding:0 10px">menit</span></div></div><div></div></div><div class="col-md-1 text-center"><span>=</span></div><div class="col-md-3"><div class="input-group"><input type="number" max="59" class="form-control" oninput="format_input(this,/^[0-9]{1,2}$/,0,59)" placeholder="0" style="height:30px;font-size:11px"><div class="input-group-append" style="height:30px"><span class="input-group-text" style="font-size:11px;padding:0 10px">menit</span></div></div><div></div></div></div></div>';

            $('#pembulatan_waktu').append(row_pembulatan);
        })

        $('#tambah_kompensasi').on('click', function() {
            if (!validate_kompensasi(true)) return false;

            // hide delete button
            $(".hapus_kompensasi").addClass("hidden");

            const min = parseInt($(".row_kompensasi:last input:eq(1)").val()) + 1;
            let row_kompensasi = '<div class="row_kompensasi border border-light p-1 rounded mb-1"><div onclick="hapus_kompensasi($(this))" class="hapus_kompensasi position-absolute" style="right:15px"><span class="badge badge-pill badge-danger cursor-pointer position-relative" title="Hapus" style="top:-25px">X</span></div><div class="row"><div class="col-md-8"><label style="font-size:12px">jam<i class="text-danger">*</i></label></div><div class="col-md-4"><label style="font-size:12px">Pengali<i class="text-danger">*</i></label></div></div><div class="row"><div class="col-md-3"><div class="input-group"><input type="number" min="' + min + '" max="99" class="form-control" oninput="format_input(this,/^[0-9]{1,2}$/,0,99)" placeholder="0" style="height:30px;font-size:11px" required><div class="input-group-append" style="height:30px"><span class="input-group-text" style="font-size:11px;padding:0 10px">jam</span></div></div><div></div></div><div class="col-md-1 text-center"><span style="font-size:11px">s/d</span></div><div class="col-md-3"><div class="input-group"><input type="number" min="' + min + '" max="99" class="form-control" oninput="format_input(this,/^[0-9]{1,2}$/,0,99)" placeholder="0" style="height:30px;font-size:11px" required><div class="input-group-append" style="height:30px"><span class="input-group-text" style="font-size:11px;padding:0 10px">jam</span></div></div><div></div></div><div class="col-md-1 text-center"><span>=</span></div><div class="col-md-3"><div class="input-group"><input type="decimal" min="0" class="form-control" oninput="format_input(this,/^[0-9]{1,5}$|(?=^.{1,5}$)^[0-9]+[.][0-9]{0,2}$/)" placeholder="0" style="height:30px;font-size:11px" required><div class="input-group-append" style="height:30px"><span class="input-group-text" style="font-size:11px;padding:0 10px">x</span></div></div><div></div></div></div></div>';

            $('#kompensasi_rate').append(row_kompensasi);
        })

        $('input[type="checkbox"]').on('change', function() {
            $('input[name="' + this.name + '"]').prop('checked', true);
            $('input[name="' + this.name + '"]').not(this).prop('checked', false);
        });

        $('input[name="flag_rounding"]').on('change', function() {
            let checkbox = $('input[name="flag_rounding"]:checked');
            if (checkbox.val() == '0') {
                $("#pembulatan_waktu").hide();
                $("#tambah_pembulatan").hide();
            } else if (checkbox.val() == '1') {
                $("#pembulatan_waktu").show();
                $("#tambah_pembulatan").show();
            }
        });

        $('input[name="jenis_upah_lembur"]').on('change', function() {
            let checkbox = $('input[name="jenis_upah_lembur"]:checked');
            if (checkbox.val() == 'flat') {
                $("#nominal_flat").prop('disabled', false);
                $("#divide_prorate").prop('disabled', true);
            } else if (checkbox.val() == 'prorate') {
                $("#nominal_flat").prop('disabled', true);
                $("#divide_prorate").prop('disabled', false);
            }
        });

        $('#kode').on('input', function(e) {
            var value = e.target.value;
            var regex = /^[0-9A-Za-z_-]*$/;
            if (!regex.test(value)) {
                e.target.value = value.slice(0, -1);
            }
        });

        $('.btn_save').on('click', function(e) {
            e.preventDefault();
            var loading = Ladda.create(this);

            var valid = formValidation();
            if (!valid) {
                return false;
            }
            $("#message").html("");

            loading.start();

            var param = {};
            param.kode = $("#kode").val();
            param.keterangan = $("#keterangan").val();
            param.flag_rounding = $("input[name='flag_rounding']:checked").val();
            param.flag_pph21 = $("input[name='flag_pph21']:checked").val();
            param.flag_pot_absensi = $("input[name='flag_pot_absensi']:checked").val();

            if (param.flag_rounding == "1") {
                var row_pembulatan = $(".row_pembulatan").toArray();
                var arr_pembulatan = [];
                for (let index = 0; index < row_pembulatan.length; index++) {
                    let value_pembulatan = [];
                    $(".row_pembulatan:eq(" + index + ") input").toArray().forEach(element => {
                        value_pembulatan.push(element.value);
                    });
                    arr_pembulatan.push(value_pembulatan);
                }
                param.arr_pembulatan = arr_pembulatan;
            }

            var row_kompensasi = $(".row_kompensasi").toArray();
            var arr_kompensasi = [];
            for (let index = 0; index < row_kompensasi.length; index++) {
                let value_kompensasi = [];
                $(".row_kompensasi:eq(" + index + ") input").toArray().forEach(element => {
                    value_kompensasi.push(element.value);
                });
                arr_kompensasi.push(value_kompensasi);
            }
            param.arr_kompensasi = arr_kompensasi;

            param.jenis_upah_lembur = $("input[name='jenis_upah_lembur']:checked").val();
            param.nominal_flat = $("#nominal_flat").val();
            param.divide_prorate = $("#divide_prorate").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.master.lembur.pengaturan.save') ?>",
                data: param,
                dataType: 'JSON',
                beforeSend: function() {
                    $("#form_input :input").prop("disabled", true);
                    $('#tambah_pembulatan').hide();
                    $('#tambah_kompensasi').hide();
                },
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $('#btn_submit').hide();
                            $('#btn_new_input').show();
                        }
                    } else {
                        $("#form_input :input").prop("disabled", false);
                        if ($("input[name='flag_rounding']:checked").val() == '1') $('#tambah_pembulatan').show();
                        $('#tambah_kompensasi').show();
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $("#form_input :input").prop("disabled", false);
                    if ($("input[name='flag_rounding']:checked").val() == '1') $('#tambah_pembulatan').show();
                    $('#tambah_kompensasi').show();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        $('#btn_new_input').on('click', function() {
            $("#tambah_data").click();
        });

        $('.btn_update').on('click', function(e) {
            e.preventDefault();
            var loading = Ladda.create(this);

            var valid = formValidation();
            if (!valid) {
                return false;
            }
            $("#message").html("");

            loading.start();

            var param = {};
            param.id = $("#encrypt_id").val();
            param.kode = $("#kode").val();
            param.keterangan = $("#keterangan").val();
            param.flag_rounding = $("input[name='flag_rounding']:checked").val();

            if (param.flag_rounding == "1") {
                var row_pembulatan = $(".row_pembulatan").toArray();
                var arr_pembulatan = [];
                for (let index = 0; index < row_pembulatan.length; index++) {
                    let value_pembulatan = [];
                    $(".row_pembulatan:eq(" + index + ") input").toArray().forEach(element => {
                        value_pembulatan.push(element.value);
                    });
                    arr_pembulatan.push(value_pembulatan);
                }
                param.arr_pembulatan = arr_pembulatan;
            }

            var row_kompensasi = $(".row_kompensasi").toArray();
            var arr_kompensasi = [];
            for (let index = 0; index < row_kompensasi.length; index++) {
                let value_kompensasi = [];
                $(".row_kompensasi:eq(" + index + ") input").toArray().forEach(element => {
                    value_kompensasi.push(element.value);
                });
                arr_kompensasi.push(value_kompensasi);
            }
            param.arr_kompensasi = arr_kompensasi;

            param.jenis_upah_lembur = $("input[name='jenis_upah_lembur']:checked").val();
            param.nominal_flat = $("#nominal_flat").val();
            param.divide_prorate = $("#divide_prorate").val();
            param.flag_pph21 = $("input[name='flag_pph21']:checked").val();
            param.flag_pot_absensi = $("input[name='flag_pot_absensi']:checked").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.master.lembur.pengaturan.update', ['id' => '"+param.id+"']) ?>",
                data: param,
                dataType: 'JSON',
                beforeSend: function() {
                    $("#form_input :input").prop("disabled", true);
                    $('#tambah_pembulatan').hide();
                    $('#tambah_kompensasi').hide();
                },
                success: function(result) {
                    $("#form_input :input").prop("disabled", false);
                    if ($("input[name='flag_rounding']:checked").val() == '1') $('#tambah_pembulatan').show();
                    $('#tambah_kompensasi').show();

                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $("#form_input :input").prop("disabled", false);
                    if ($("input[name='flag_rounding']:checked").val() == '1') $('#tambah_pembulatan').show();
                    $('#tambah_kompensasi').show();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    });

    /**
     * Find index in row
     *
     * @param {number} count
     * @param {number} position => 3 = kiri, 2 = tengah, 1 = kanan
     * @return {array}
     */
    function find_index_in_row(count, position) {
        const output = [];
        for (let i = 1; i <= count; i++) {
            if (i % 3 === 0) {
                output.push(i - (position - 1));
            }
        }
        return output;
    }

    function hapus_pembulatan(e) {
        $(e).parent().remove();
        $(".hapus_pembulatan:last").removeClass("hidden");
        $('#alert_pembulatan_waktu').hide();
    }

    function hapus_kompensasi(e) {
        $(e).parent().remove();
        $(".hapus_kompensasi:last").removeClass("hidden");
        $('#alert_kompensasi_rate').hide();
    }

    function format_input(e, regex, min = 0, max) {
        var value = e.value;
        if (!regex.test(value)) {
            e.value = value.slice(0, -1);
        }
        if (value < min) {
            e.value = min;
        }
        if (max && (value > max)) {
            e.value = max;
        }
    }

    function validate_pembulatan(alert_batas = false) {
        $('#alert_pembulatan_waktu').hide();

        let stop = false;
        let row = 0;
        let row_kiri = find_index_in_row($(".row_pembulatan input").toArray().length, 3);
        let row_tengah = find_index_in_row($(".row_pembulatan input").toArray().length, 2);
        let prev_input = 0;
        let next_input = 0;
        $(".row_pembulatan input").toArray().forEach(element => {
            element.style.borderColor = "";

            let msg = element.closest("div").nextElementSibling;
            msg.innerHTML = "";

            row++;
            if (row_kiri.includes(row)) {
                element.min = (parseInt(next_input) > 0) ? (parseInt(next_input) + 1) : 0;
                prev_input = element.value;
                next_input = 0;
            }
            if (row_tengah.includes(row)) {
                element.min = parseInt(prev_input);
                prev_input = 0;
                next_input = element.value;
            }

            if (!element.value) {
                stop = true;
                element.style.borderColor = "red";
                text = "Tidak boleh kosong";
                msg.innerHTML = "<font style='color:Crimson;font-size:10px'>" + text + "</font>";
            } else if (parseInt(element.value) < parseInt(element.min)) {
                stop = true;
                element.style.borderColor = "red";
                text = "Minimal waktu <b>" + element.min + "</b> menit";
                msg.innerHTML = "<font style='color:Crimson;font-size:10px'>" + text + "</font>";
            }

            if (alert_batas) {
                if (parseInt(next_input) >= 59) {
                    stop = true;
                    $('#alert_pembulatan_waktu').slideDown();
                }
            }
        });
        if (stop) return false;

        return true;
    }

    function validate_kompensasi(alert_batas = false) {
        $('#alert_kompensasi_rate').hide();

        let stop = false;
        let row = 0;
        let row_kiri = find_index_in_row($(".row_kompensasi input").toArray().length, 3);
        let row_tengah = find_index_in_row($(".row_kompensasi input").toArray().length, 2);
        let prev_input = 0;
        let next_input = 0;
        $(".row_kompensasi input").toArray().forEach(element => {
            element.style.borderColor = "";

            let msg = element.closest("div").nextElementSibling;
            msg.innerHTML = "";

            row++;
            if (row_kiri.includes(row)) {
                element.min = (parseInt(next_input) > 0) ? (parseInt(next_input) + 1) : 0;
                prev_input = element.value;
                next_input = 0;
            }
            if (row_tengah.includes(row)) {
                element.min = parseInt(prev_input);
                prev_input = 0;
                next_input = element.value;
            }

            if (!element.value) {
                stop = true;
                element.style.borderColor = "red";
                text = "Tidak boleh kosong";
                msg.innerHTML = "<font style='color:Crimson;font-size:10px'>" + text + "</font>";
            } else if (parseInt(element.value) < parseInt(element.min)) {
                stop = true;
                element.style.borderColor = "red";
                text = "Minimal waktu <b>" + element.min + "</b> jam";
                msg.innerHTML = "<font style='color:Crimson;font-size:10px'>" + text + "</font>";
            }

            if (alert_batas) {
                if (parseInt(next_input) >= 99) {
                    stop = true;
                    $('#alert_kompensasi_rate').slideDown();
                }
            }
        });
        if (stop) return false;

        return true;
    }

    function formValidation() {
        if (($("#kode").val() == "")) {
            $("#kode").addClass("border border-danger");
            return error_message($("#kode"), "Kode harus diisi");
        } else {
            $("#kode").removeClass("border border-danger");
        }

        if (($("#keterangan").val() == "")) {
            $("#keterangan").addClass("border border-danger");
            return error_message($("#keterangan"), "Keterangan harus diisi");
        } else {
            $("#keterangan").removeClass("border border-danger");
        }

        if ($("input[name='flag_rounding']:checked").val() == "1") {
            if (!validate_pembulatan(false)) return false;
        }

        if (!validate_kompensasi(false)) return false;

        $("#nominal_flat").removeClass("border border-danger");
        if ($("input[name='jenis_upah_lembur']:checked").val() == "flat") {
            if (($("#nominal_flat").val() == "")) {
                $("#nominal_flat").addClass("border border-danger");
                return error_message($("#nominal_flat"), "Nominal flat harus diisi");
            }
        }

        $("#divide_prorate").removeClass("border border-danger");
        if ($("input[name='jenis_upah_lembur']:checked").val() == "prorate") {
            if (($("#divide_prorate").val() == "")) {
                $("#divide_prorate").addClass("border border-danger");
                return error_message($("#divide_prorate"), "Nilai prorate harus diisi");
            }
        }

        return true;
    }

    function error_message(e, message) {
        $("#message").show();
        $("#message").html("");
        if (Array.isArray(message)) {
            message.forEach(msg => {
                $("#message").append("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> " + msg + "</font><br>");
            });
        } else {
            $("#message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> " + message + "</font>");
        }
        if (e) e.focus();
        return false;
    }
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input" class="card-body" disabled>
    <input id="encrypt_id" type="text" value="<?= $data->id_lembur_p ? md5($data->id_lembur_p) : '' ?>" class="hidden" disabled>
    <div class="form-group">
        <div class="row">
            <div class="col-md-4">
                <label>Kode<i class="text-danger">*</i></label>
                <input id="kode" type="text" class="form-control" value="<?= $data->kode ?: '' ?>" placeholder="Kode" required>
                <span class="text-light" style="font-size: 11px;">Huruf, Angka, Simbol(- dan _)</span>
            </div>
            <div class="col-md-8">
                <label>Keterangan<i class="text-danger">*</i></label>
                <input id="keterangan" type="text" class="form-control" value="<?= $data->keterangan ?: '' ?>" placeholder="Keterangan" required>
            </div>
        </div>
    </div>

    <!-- pembulatan waktu -->
    <div class="form-group pt-1">
        <label>Pembulatan Waktu<i class="text-danger">*</i></label>
        <div class="row pb-1">
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-6">
                        <div>
                            <input id="flag_rounding_ya" type="checkbox" name="flag_rounding" value="1" <?= (isset($data->flag_rounding) ? ($data->flag_rounding == '1' ? 'checked' : '') : 'checked') ?>>
                            <label class="text" for="flag_rounding_ya" style="font-size: 12px;">Ya</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div>
                            <input id="flag_rounding_tidak" type="checkbox" name="flag_rounding" value="0" <?= (isset($data->flag_rounding) ? ($data->flag_rounding == '0' ? 'checked' : '') : '') ?>>
                            <label class="text" for="flag_rounding_tidak" style="font-size: 12px;">Tidak</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 text-right">
                <a href="javascript:void(0)" id="tambah_pembulatan" class="text-primary font-weight-bold" style="font-size: 12px;<?= (isset($data->flag_rounding) ? ($data->flag_rounding == '0' ? 'display: none' : '') : '') ?>">
                    <i class="fa fa-plus"></i> Tambah Pembulatan Waktu
                </a>
            </div>
        </div>
        <!-- waktu -->
        <div id="pembulatan_waktu" style="<?= (isset($data->flag_rounding) ? ($data->flag_rounding == '0' ? 'display: none;' : '') : '') ?>">
            <div id="alert_pembulatan_waktu" style="display:none">
                <div class="alert alert-danger" role="alert">
                    <span style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> Sudah melebihi batas pembulatan waktu</span>
                </div>
            </div>
            <?php if (!$data->id_lembur_p) : ?>
                <div class="row_pembulatan border border-light p-1 rounded mb-1">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="number" min="0" max="59" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                <div class="input-group-append" style="height: 30px;">
                                    <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                </div>
                            </div>
                            <!-- for alert message -->
                            <div></div>
                        </div>
                        <div class="col-md-1 text-center">
                            <span style="font-size: 11px;">s/d</span>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="number" min="0" max="59" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                <div class="input-group-append" style="height: 30px;">
                                    <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                </div>
                            </div>
                            <!-- for alert message -->
                            <div></div>
                        </div>
                        <div class="col-md-1 text-center">
                            <span>=</span>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="number" max="59" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                <div class="input-group-append" style="height: 30px;">
                                    <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                </div>
                            </div>
                            <!-- for alert message -->
                            <div></div>
                        </div>
                    </div>
                </div>
            <?php else : ?>
                <?php if (count($data->pembulatan) == 0) : ?>
                    <div class="row_pembulatan border border-light p-1 rounded mb-1">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="59" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                            <div class="col-md-1 text-center">
                                <span style="font-size: 11px;">s/d</span>
                            </div>
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="59" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                            <div class="col-md-1 text-center">
                                <span>=</span>
                            </div>
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="59" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php
                $i = 1;
                foreach ($data->pembulatan as $value) {
                ?>
                    <div class="row_pembulatan border border-light p-1 rounded mb-1">
                        <?php if ($i > 1) : ?>
                            <div onclick="hapus_pembulatan($(this))" class="hapus_pembulatan position-absolute <?= ($i >= count($data->pembulatan)) ? '' : 'hidden' ?>" style="right:15px">
                                <span class="badge badge-pill badge-danger cursor-pointer position-relative" title="Hapus" style="top:-25px">X</span>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="59" class="form-control" value="<?= $value->menit_mulai ?>" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                            <div class="col-md-1 text-center">
                                <span style="font-size: 11px;">s/d</span>
                            </div>
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="59" class="form-control" value="<?= $value->menit_selesai ?>" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                            <div class="col-md-1 text-center">
                                <span>=</span>
                            </div>
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="59" class="form-control" value="<?= $value->menit_dihitung ?>" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 59)" placeholder="0" style="height: 30px; font-size: 11px;">
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">menit</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                        </div>
                    </div>
                <?php
                    $i++;
                }
                ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- kompensasi rate -->
    <div class="form-group">
        <div class="row py-1">
            <div class="col-md-6">
                <label>Kompensasi Rate<i class="text-danger">*</i></label>
            </div>
            <div class="col-md-6 text-right">
                <a href="javascript:void(0)" id="tambah_kompensasi" class="text-primary font-weight-bold" style="font-size: 12px">
                    <i class="fa fa-plus"></i> Tambah Kompensasi
                </a>
            </div>
        </div>
        <!-- rate -->
        <div id="kompensasi_rate">
            <div id="alert_kompensasi_rate" style="display:none">
                <div class="alert alert-danger" role="alert">
                    <span style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> Batas kompensasi sudah maksimal</span>
                </div>
            </div>
            <?php if (!$data->id_lembur_p) : ?>
                <div class="row_kompensasi border border-light p-1 rounded mb-1">
                    <div class="row">
                        <div class="col-md-8">
                            <label style="font-size: 12px;">jam<i class="text-danger">*</i></label>
                        </div>
                        <div class="col-md-4">
                            <label style="font-size: 12px;">Pengali<i class="text-danger">*</i></label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="number" min="0" max="99" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 99)" placeholder="0" style="height: 30px; font-size: 11px;" required>
                                <div class="input-group-append" style="height: 30px;">
                                    <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">jam</span>
                                </div>
                            </div>
                            <!-- for alert message -->
                            <div></div>
                        </div>
                        <div class="col-md-1 text-center">
                            <span style="font-size: 11px;">s/d</span>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="number" min="0" max="99" class="form-control" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 99)" placeholder="0" style="height: 30px; font-size: 11px;" required>
                                <div class="input-group-append" style="height: 30px;">
                                    <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">jam</span>
                                </div>
                            </div>
                            <!-- for alert message -->
                            <div></div>
                        </div>
                        <div class="col-md-1 text-center">
                            <span>=</span>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="decimal" min="0" class="form-control" oninput="format_input(this, /^[0-9]{1,5}$|(?=^.{1,5}$)^[0-9]+[.][0-9]{0,2}$/)" placeholder="0" style="height: 30px; font-size: 11px;" required>
                                <div class="input-group-append" style="height: 30px;">
                                    <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">x</span>
                                </div>
                            </div>
                            <!-- for alert message -->
                            <div></div>
                        </div>
                    </div>
                </div>
            <?php else : ?>
                <?php
                $i = 0;
                foreach ($data->perkalian as $value) {
                ?>
                    <div class="row_kompensasi border border-light p-1 rounded mb-1">
                        <?php if ($i > 1) : ?>
                            <div onclick="hapus_kompensasi($(this))" class="hapus_kompensasi position-absolute <?= ($i >= count($data->perkalian)) ? '' : 'hidden' ?>" style="right:15px">
                                <span class="badge badge-pill badge-danger cursor-pointer position-relative" title="Hapus" style="top:-25px">X</span>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-8">
                                <label style="font-size: 12px;">jam<i class="text-danger">*</i></label>
                            </div>
                            <div class="col-md-4">
                                <label style="font-size: 12px;">Pengali<i class="text-danger">*</i></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="99" class="form-control" value="<?= $value->jam_mulai ?>" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 99)" placeholder="0" style="height: 30px; font-size: 11px;" required>
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">jam</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                            <div class="col-md-1 text-center">
                                <span style="font-size: 11px;">s/d</span>
                            </div>
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="number" min="0" max="99" class="form-control" value="<?= $value->jam_selesai ?>" oninput="format_input(this, /^[0-9]{1,2}$/, 0, 99)" placeholder="0" style="height: 30px; font-size: 11px;" required>
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">jam</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                            <div class="col-md-1 text-center">
                                <span>=</span>
                            </div>
                            <div class="col-md-3">
                                <div class="input-group">
                                    <input type="decimal" min="0" class="form-control" value="<?= $value->perkalian ?>" oninput="format_input(this, /^[0-9]{1,5}$|(?=^.{1,5}$)^[0-9]+[.][0-9]{0,2}$/)" placeholder="0" style="height: 30px; font-size: 11px;" required>
                                    <div class="input-group-append" style="height: 30px;">
                                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">x</span>
                                    </div>
                                </div>
                                <!-- for alert message -->
                                <div></div>
                            </div>
                        </div>
                    </div>
                <?php
                    $i++;
                } ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- overtime rate -->
    <div class="form-group pt-1">
        <label>Jenis Upah Lembur(Per Jam)<i class="text-danger">*</i></label>
        <div class="row">
            <div class="col-md-6">
                <div>
                    <input id="flat" type="checkbox" name="jenis_upah_lembur" value="flat" <?= ($data->jenis_upah_lembur ? ($data->jenis_upah_lembur == 'flat' ? 'checked' : '') : 'checked') ?>>
                    <label class="text" for="flat" style="font-size: 12px;">Flat</label>
                </div>
                <div class="input-group">
                    <div class="input-group-prepend" style="height: 30px;">
                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">RP</span>
                    </div>
                    <input id="nominal_flat" type="text" class="form-control" value="<?= number_format($data->nominal_flat, 0, ',', '.') ?>" oninput="format_amount($(this))" placeholder="0" style="height: 30px; font-size: 11px;" <?= ($data->jenis_upah_lembur ? ($data->jenis_upah_lembur == 'flat' ? '' : 'disabled') : '') ?>>
                </div>
            </div>
            <div class="col-md-6">
                <div>
                    <input id="prorate" type="checkbox" name="jenis_upah_lembur" value="prorate" <?= ($data->jenis_upah_lembur ? ($data->jenis_upah_lembur == 'prorate' ? 'checked' : '') : '') ?>>
                    <label class="text" for="prorate" style="font-size: 12px;">Prorate</label>
                </div>
                <div class="input-group">
                    <div class="input-group-prepend" style="height: 30px;">
                        <span class="input-group-text" style="font-size: 11px;padding: 0px 10px;">salary /</span>
                    </div>
                    <input id="divide_prorate" type="number" min="0" class="form-control" value="<?= $data->divide_prorate ?: '173' ?>" oninput="format_input(this, /^[0-9]{1,5}$/)" placeholder="0" style="height: 30px; font-size: 11px;" <?= ($data->jenis_upah_lembur ? ($data->jenis_upah_lembur == 'prorate' ? '' : 'disabled') : 'disabled') ?>>
                </div>
                <span class="text-light" style="font-size: 11px;">Salary = Gaji Pokok + Komponen yang diikutsertakan dalam hitungan lembur</span>
            </div>
        </div>
    </div>

    <!-- diikutsertakan hitungan -->
    <div class="form-group mt-3">
        <h6 class="font-weight-bold" style="color: #1c77d4;">Diikutsertakan Hitungan</h6>
        <hr>
        <div class="row">
            <div class="col-md-5 my-auto">
                <label>PPH21</label>
            </div>
            <div class="col-md-3">
                <label>
                    <input type="radio" name="flag_pph21" value="0" <?= ((isset($data) && $data->flag_pph21 == "0") ? "checked" : ((!isset($data)) ? "checked" : "")) ?>>
                    <span class="text">Tidak</span>
                </label>
            </div>
            <div class="col-md-4">
                <label>
                    <input type="radio" name="flag_pph21" value="1" <?= ((isset($data) && $data->flag_pph21 == "1") ? "checked" : "") ?>>
                    <span class="text">Ya</span>
                </label>
            </div>
        </div>
        <div class="row">
            <div class="col-md-5 my-auto">
                <label>Potongan Absensi</label>
            </div>
            <div class="col-md-3">
                <label>
                    <input type="radio" name="flag_pot_absensi" value="0" <?= ((isset($data) && $data->flag_pot_absensi == "0") ? "checked" : ((!isset($data)) ? "checked" : "")) ?>>
                    <span class="text">Tidak</span>
                </label>
            </div>
            <div class="col-md-4">
                <label>
                    <input type="radio" name="flag_pot_absensi" value="1" <?= ((isset($data) && $data->flag_pot_absensi == "1") ? "checked" : "") ?>>
                    <span class="text">Ya</span>
                </label>
            </div>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button id="btn_submit" class="ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
