<!-- BAGIN DATATABLE -->
<script type="text/javascript">
    $(document).ready(function () {
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function (e, settings, techNote, message) {
            if (confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': false,
            'delay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'stateSave': true,
            'fixedColumns': {
                leftColumns: 3,
                rightColumns: 1
            },
            'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'Kode/Nama'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('payroll.gaji.datatable', ['bulan' => $periode, 'id_cabang' => $cabang, 'id_departemen' => $departemen, 'id_karyawan' => $karyawan]) ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                },
                "complete": function (data) {
                    $(".btn_download_excel").attr("bulande", $("#filter #bulan").val());
                    // reconfigure(data);
                },
            },

            "aoColumnDefs": [
                {
                    "targets": [1, 3, 4],
                    "className": "align-top text-left"
                },
                {
                    "targets": [0, 2, 5, -1, -2, -3, -4],
                    "className": "align-top text-center"
                },
            ],
            "fnCreatedRow": function (row, data, dataIndex) {
                $(row).addClass('align-top text-right');
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td', nRow).css({
                    'white-space': 'nowrap'
                });
            }
        });
    });
</script>
<!-- END DATATABLE -->
<table id="list_data" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr class="bg-tr">
            <th rowspan="3" class="align-middle text-center">NO</th>
            <th rowspan="3" class="align-middle text-center">NAMA KARYAWAN</th>
            <th rowspan="3" class="align-middle text-center">BULAN</th>
            <th rowspan="3" class="align-middle text-center">CABANG</th>
            <th rowspan="3" class="align-middle text-center">DEPARTEMEN</th>
            <th rowspan="3" class="align-middle text-center">PERIODE</th>
            <th rowspan="3" class="align-middle text-center">GAJI POKOK</th>
            <?php
            $tunj_tetap_rows = 1;
            if (count($komponen_tunj_tetap->result()) > 0) {
                $tunj_tetap_rows = count($komponen_tunj_tetap->result());
            }
            $tunj_tdk_tetap_rows = 1;
            if (count($komponen_tunj_tdk_tetap->result()) > 0) {
                $tunj_tdk_tetap_rows = count($komponen_tunj_tdk_tetap->result());
            }
            $tunj_kehadiran_rows = 1;
            if (count($komponen_tunj_kehadiran->result()) > 0) {
                $tunj_kehadiran_rows = count($komponen_tunj_kehadiran->result());
            }
            ?>
            <th colspan="<?= $tunj_tetap_rows + $tunj_tdk_tetap_rows + $tunj_kehadiran_rows + 1 ?>" class="align-middle text-center">TUNJANGAN</th>
            <th rowspan="3" class="align-middle text-center">UPAH LEMBUR</th>

            <?php
            $pot_tetap_rows = 1;
            if (count($komponen_pot_tetap->result()) > 0) {
                $pot_tetap_rows = count($komponen_pot_tetap->result());
            }
            $pot_tdk_tetap_rows = 1;
            if (count($komponen_pot_tdk_tetap->result()) > 0) {
                $pot_tdk_tetap_rows = count($komponen_pot_tdk_tetap->result());
            }
            ?>
            <th colspan="<?= $pot_tetap_rows + $pot_tdk_tetap_rows + 5 ?>" class="align-middle text-center">POTONGAN</th>
            <th rowspan="3" class="align-middle text-center">THP</th>
            <th colspan="3" class="align-middle text-center">TUNJ. DIBIAYAI PERUSAHAAN</th>
            <th colspan="3" class="align-middle text-center">PUBLISH</th>
            <th rowspan="3" class="align-middle text-center">AKSI</th>
        </tr>
        <tr class="bg-tr">
            <!-- PENGHASILAN -->
            <th <?= 'colspan="' . $tunj_tetap_rows . '" ' ?> class="align-middle text-center">TETAP</th>
            <th <?= 'colspan="' . $tunj_tdk_tetap_rows . '" ' ?> class="align-middle text-center">TIDAK TETAP</th>
            <th <?= 'colspan="' . $tunj_kehadiran_rows . '" ' ?> class="align-middle text-center">KEHADIRAN</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th>

            <!-- LEMBUR -->
            <!-- <th rowspan="2" class="align-middle text-center">TOTAL MENIT</th>
            <th rowspan="2" class="align-middle text-center">PER JAM</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th> -->

            <!-- PENGURANGAN -->
            <th <?= 'colspan="' . $pot_tetap_rows . '" ' ?> class="align-middle text-center">TETAP</th>
            <th <?= 'colspan="' . $pot_tdk_tetap_rows . '" ' ?> class="align-middle text-center">TIDAK TETAP</th>
            <th rowspan="2" class="align-middle text-center">BPJS KES.</th>
            <th rowspan="2" class="align-middle text-center">BPJS TK</th>
            <th rowspan="2" class="align-middle text-center">ABSENSI</th>
            <th rowspan="2" class="align-middle text-center">PPH 21</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th>

            <th rowspan="2" class="align-middle text-center">BPJS KES.</th>
            <th rowspan="2" class="align-middle text-center">BPJS TK</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th>

            <th rowspan="2" class="align-middle text-center">JADWAL</th>
            <th rowspan="2" class="align-middle text-center">TANGGAL</th>
            <th rowspan="2" class="align-middle text-center">STATUS</th>
        </tr>
        <tr class="bg-tr">
            <?php
            // PENGHASILAN
            if (count($komponen_tunj_tetap->result()) > 0) {
                foreach ($komponen_tunj_tetap->result() as $row) {
                    echo '<th class="align-top text-center">' . strtoupper($row->nm_komponen) . '</th>';
                }
            } else {
                echo '<th class="align-top text-center">-</th>';
            }
            if (count($komponen_tunj_tdk_tetap->result()) > 0) {
                foreach ($komponen_tunj_tdk_tetap->result() as $row) {
                    echo '<th class="align-top text-center">' . strtoupper($row->nm_komponen) . '</th>';
                }
            } else {
                echo '<th class="align-top text-center">-</th>';
            }
            if (count($komponen_tunj_kehadiran->result()) > 0) {
                foreach ($komponen_tunj_kehadiran->result() as $row) {
                    echo '<th class="align-top text-center">' . strtoupper($row->nm_komponen) . '</th>';
                }
            } else {
                echo '<th class="align-top text-center">-</th>';
            }
            // PENGURANGAN
            if (count($komponen_pot_tetap->result()) > 0) {
                foreach ($komponen_pot_tetap->result() as $row) {
                    echo '<th class="align-top text-center">' . strtoupper($row->nm_komponen) . '</th>';
                }
            } else {
                echo '<th class="align-top text-center">-</th>';
            }
            if (count($komponen_pot_tdk_tetap->result()) > 0) {
                foreach ($komponen_pot_tdk_tetap->result() as $row) {
                    echo '<th class="align-top text-center">' . strtoupper($row->nm_komponen) . '</th>';
                }
            } else {
                echo '<th class="align-top text-center">-</th>';
            }
            ?>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>